/*---------------------------------------------------------------------
	Let's Chip-8! by Kpan
	HSP 2.61 (+g}N)

	Chip 8 emulator in Javascript by Robert Gamble
---------------------------------------------------------------------*/

#module		; 10i -> 2i (l̔zzW[)
#deffunc dec2bin val,int
	mref code,24
	mref number,1

	code = ""
	repeat 8
		bit = number & 1
		number = number >> 1
		code = ""+bit + code
	loop
	return
#global


	screen ,256,128 : title "Let's Chip-8!" : objmode 1,1

	color 33,36,255
	boxf ,,256,128

	sdim debug_data2,80000
	notesel debug_data2
	debug_data2 = ""

	dim screen_data,30000
	dim k,64
	screen_mode = 1
	waiting = "no"

	gsel ,1
	onexit *exit

;	ǂݍ݃_CAO
	dialog "c8;*.ch8;*.sc;*.sc8;*.*",16,"chip-8 file"
	if stat != 1 : end

	sdim filepath,256
	filepath = refstr

	getpath filename,filepath,8
	title "Let's Chip-8! - "+filename+""

	exist filepath
	filesize = strsize

	sdim filedata_entry,filesize
	sdim filedata,$FFF

;	Q[f[^$200
	bload filepath,filedata_entry,filesize
	memcpy filedata,filedata_entry,filesize,$200

;	tHgf[^$0
	dim fontdata,$80
	fontdata.0  = $0909090F,$0206020F,$010F0702,$0F0F080F,$0F010F01,$010F0909,$0F080F01,$080F0F01
	fontdata.8  = $0F0F090F,$04040201,$090F090F,$0F090F0F,$090F0F01,$0E09090F,$0E090E09,$0808080F
	fontdata.16 = $09090E0F,$080F0E09,$0F0F080F,$08080F08
	memcpy filedata,fontdata,$80
;	bsave "lchip8_memory.dat",filedata

	reg_pc = $200

/*-----------------------------------------------------------------------
	Loop
-----------------------------------------------------------------------*/
	repeat

		if (dtimer - 1) >= 0 : dtimer--
		if (stimer - 1) >= 0 : stimer--

		await 1

		repeat
			gosub *fetch_exe

;;			CPUXs[h (10=1.0khz炢?A傫)
			if cnt = 10 : break
		loop

	loop


/*-----------------------------------------------------------------------
	Key
	KȂ̂ŁAρB
-----------------------------------------------------------------------*/
*keycheck
	i = 0
	k.i = 0
	keydata = 0

	getkey keydata,49
	if keydata = 1 : i = $1 : k.i = 1 : return

	getkey keydata,50
	if keydata = 1 : i = $2 : k.i = 1 : return

	getkey keydata,51
	if keydata = 1 : i = $3 : k.i = 1 : return

	getkey keydata,52
	if keydata = 1 : i = $C : k.i = 1 : return

	getkey keydata,81
	if keydata = 1 : i = $4 : k.i = 1 : return

	getkey keydata,87
	if keydata = 1 : i = $5 : k.i = 1 : return

	getkey keydata,69
	if keydata = 1 : i = $6 : k.i = 1 : return

	getkey keydata,49
	if keydata = 1 : i = $D : k.i = 1 : return

	getkey keydata,65
	if keydata = 1 : i = $7 : k.i = 1 : return

	getkey keydata,83
	if keydata = 1 : i = $8 : k.i = 1 : return

	getkey keydata,68
	if keydata = 1 : i = $9 : k.i = 1 : return

	getkey keydata,70
	if keydata = 1 : i = $E : k.i = 1 : return

	getkey keydata,90
	if keydata = 1 : i = $A : k.i = 1 : return

	getkey keydata,88
	if keydata = 1 : i = $0 : k.i = 1 : return

	getkey keydata,66
	if keydata = 1 : i = $B : k.i = 1 : return

	getkey keydata,86
	if keydata = 1 : i = $F : k.i = 1 : return

	keydata = 0

	return


/*-----------------------------------------------------------------------

-----------------------------------------------------------------------*/
*fetch_exe

	if waiting != "no" {

		wait 10

		i = 0

		k1 = ""+k
		strlen k_length,k1

		gosub *keycheck

;		while i < k_length
;			k1 = ""+k
;			strlen k_length,k1

			if k.i = 1 {
				reg_v.waiting = i
				waiting = "no"
			}

			i++
;		wend

		if waiting != "no" {
			fetch_exe_return = 1
			return
		}
	}

	peek opcode1,filedata,reg_pc
	peek opcode2,filedata,reg_pc + 1

	opcode = opcode1 << 8 + opcode2
	A = opcode >> 12

/*------
;	Debug
;	gosub *debug_info1
;	gosub *debug_info2
------*/

	if A = $0 {
		gosub *stuff
		if stuff_return = 1 : stuff_return = 0 : return

		reg_pc += 2
		return
	}

	if A = $1 {
		reg_pc = opcode & $FFF

		stuff_return = 0
		return
	}

	if A = $2 {
		dim reg_s,17
		i = 16

		repeat
			i2 = i - 1
			reg_s.i = reg_s.i2
			i--

			if i > 0 : break
		loop

		reg_s.0 = reg_pc + 2
		reg_pc = opcode & $FFF

		stuff_return = 0
		return
	}

	if A = $3 {
		getreg = opcode >> 8 & $F
		if reg_v.getreg = (opcode & $FF) : reg_pc += 2

		reg_pc += 2
		return
	}

	if A = $4 {
		getreg = opcode >> 8 & $F
		if reg_v.getreg != (opcode & $FF) : reg_pc += 2

		reg_pc += 2
		return
	}

	if A = $5 {
		getreg = opcode >> 8 & $F
		getreg2 = opcode & $FF >> 4
		if reg_v.getreg = reg_v.getreg2 : reg_pc += 2

		reg_pc += 2
		return
	}

	if A = $6 {
		getreg = opcode >> 8 & $F
		reg_v.getreg = opcode & $FF

		reg_pc += 2
		return
	}

	if A = $7 {
		getreg = opcode >> 8 & $F
		reg_v.getreg += opcode & $00FF
		reg_v.getreg = reg_v.getreg & $FF

		reg_pc += 2
		return
	}

	if A = $8 {
		gosub *maths

		reg_pc += 2
		return
	}


	if A = $9 {
		getreg = opcode >> 8 & $F
		getreg2 = opcode & $FF >> 4
		if reg_v.getreg != reg_v.getreg2 : reg_pc += 2
		reg_pc += 2
		return
	}

	if A = $A{
		reg_i = opcode & $0FFF

		reg_pc += 2
		return
	}

	if A = $B{
		reg_pc = opcode & $FFF + reg_v.0 & $FFF

		reg_pc += 2
		return
	}

	if A = $C{
		getreg = opcode >> 8 & $F

		randomize
		rnd round,1001
		reg_v.getreg = round & opcode & $FF
;;		reg_v.getreg = reg_v.getreg & $FF

		reg_pc += 2
		return
	}

	if A = $D{
		gosub *draw_sprite

		reg_pc += 2
		return
	}

	if A = $E{


		getreg = opcode >> 8 & $F
		key = reg_v.getreg

wait 1

;pos 200,100 : mes k.key

getkey tes,49 : if tes = 1 : k.key = 1 : tes = 0
getkey tes,86 : if tes = 1 : k.key = 14 : tes = 0

		if (opcode & $000F = $1) & (opcode & $000F != k.key) {
			reg_pc += 2
		}
		else if (opcode & $000F = $E) & (opcode & $000F = k.key) {
			reg_pc += 2
		}

k.key = 0

		reg_pc += 2
		return
	}

	if A = $F {
		gosub *io

		reg_pc += 2
		return
	}

	maincode_debug = A : str maincode_debug,16
	dialog "Invalid Opcode. (main - $"+maincode_debug+")",3,"Error"
	if stat = 7 : end

	return


/*-----------------------------------------------------------------------
	IO ($F)
-----------------------------------------------------------------------*/
*io
	iocode = opcode & $000F

	if iocode = $0 {	; font
		getreg = opcode >> 8 & $F
		reg_i = reg_v.getreg & $F * 5
		return
	}

	if iocode = $3 {	; 
		getreg = opcode >> 8 & $F
		i = reg_v.getreg

		if i >= 100 {
			repeat
				if i >= 100 : j = cnt : break
				i -= 100
			loop
		}

		poke filedata,reg_i,j

		if i >= 10 {
			repeat
				if i >= 10 : j = cnt : break
				i -= 10
			loop
		}

		reg_i1 = reg_i + 1
		reg_i2 = reg_i + 2
		poke filedata,reg_i1,j
		poke filedata,reg_i2,i

		return
	}

	if iocode = $5 {
		if (opcode & $00FF >> 4) = $1 {		; set delay timer
			getreg = opcode >> 8 & $F
			dtimer = reg_v.getreg

			return
		}
	
		if (opcode & $00FF >> 4) = $5 {		; store registers

			j = opcode >> 8 & $0F
			repeat
				if cnt <= j : i = cnt : break
			loop

			poke filedata,reg_i + i,reg_v.i

			return
		}

		if (opcode & $00FF >> 4) = $6 {		; load registers

			j = opcode >> 8 & $0F
			repeat
				if cnt <= j : i = cnt : break
			loop

			peek reg_v.i,filedata,reg_i + i

			return
		}

		if (opcode & $00FF >> 4) = $7 {		; save

		}

		if (opcode & $00FF >> 4) = $8 {		; load

		}

		return
	}

	if iocode = $7 {	; get delay timer 
		getreg = opcode >> 8 & $F
		reg_v.getreg = dtimer
		return
	}

	if iocode = $8 {	; sound timer
		getreg = opcode >> 8 & $F
		stimer = reg_v.getreg
		return
	}

	if iocode = $9 {	; font
		getreg = opcode >> 8 & $F
		reg_i = reg_v.getreg & $F * 5
		return
	}

	if iocode = $A {	; wait for for keypress
		waiting = opcode >> 8 & $F
		return
	}

	if iocode = $E {	;
		getreg = opcode >> 8 & $F
		reg_i += reg_v.getreg
		reg_i = reg_i & $FFF
		return
	}

	iocode_debug = iocode : str iocode_debug,16
	dialog "Invalid Opcode. (io - $"+iocode_debug+")",3,"Error"
	if stat = 7 : end

	return


/*-----------------------------------------------------------------------
	Stuff ($0)
-----------------------------------------------------------------------*/
*stuff
	stuffcode = opcode & $000F

	if opcode & $FFF0 >> 4 = $00C {		; Scroll Down
		gosub *scrolldown

		stuff_return = 0		; false
		return
	}

	if stuffcode = $0 {			; Clear Screen
;		h = 32
;		w = 64
;		px = 6

;		gosub *create_dsp_area

;		color 33,36,255
;		boxf ,,256,128

		return
	}

	if stuffcode = $B {			; Scroll Right
		gosub *scrollright
		return
	}

	if stuffcode = $C {			; Scroll Left
		gosub *scrollleft
		return
	}

	if stuffcode = $D {			; Quit
		dialog "Super Chip-8 Quit.",,"Info"
		end
	}

	if stuffcode = $E {
		if opcode & $FF >> 4 = $E {	; Return Subroutine
			reg_pc = reg_s.0
			i = 0

			reg_s1 = ""+reg_s+"
			strlen reg_s_length,reg_s1

			while i < reg_s_length
				reg_s1 = ""+reg_s+"
				strlen reg_s_length,reg_s1

				i2 = i + 1
				reg_s.i = reg_s.i2
				i++
			wend

			stuff_return = 1	; true
			return
		} else {
			screen_mode = 1		; Disable Extende Screen

;			h = 32
;			w = 64
;			px = 6

;			gosub *create_dsp_area

		}
		return
	}

	if stuffcode = $F {
		screen_mode = 2			; Unable Extende Screen

;		h = 32
;		w = 64
;		px = 6

;		gosub *create_dsp_area

		return
	}

	stuff_return = 0	; false
	return


/*-----------------------------------------------------------------------
	Math ($8)
-----------------------------------------------------------------------*/
*maths
	mathcode = opcode & $000F
	r = opcode >> 8 & $F

	if mathcode = $0 {			; MOV
		getreg2 = opcode & $FF >> 4
		reg_v.r = reg_v.getreg2
		return
	}

	if mathcode = $1 {			; OR
		getreg2 = opcode & $FF >> 4
		reg_v.r = reg_v.r | reg_v.getreg2
		return
	}

	if mathcode = $2 {			; AND
		getreg2 = opcode & $FF >> 4
		reg_v.r = reg_v.r & reg_v.getreg2
		return
	}

	if mathcode = $3 {			; XOR
		getreg2 = opcode & $FF >> 4
		reg_v.r = reg_v.r ^ reg_v.getreg2
		return
	}

	if mathcode = $4 {
		getreg2 = opcode & $FF >> 4
		reg_v.r += reg_v.getreg2

		reg_v.$F = reg_v.r >> 8
		reg_v.r = reg_v.r & $FF
		return
	}

	if mathcode = $5 {
		getreg2 = opcode & $FF >> 4
		reg_v.r -= reg_v.getreg2

		reg_v.$F = reg_v.r >> 8 + 1
		reg_v.r = reg_v.r & $FF
		return
	}

	if mathcode = $6 {
		reg_v.$F = reg_v.r & 1

		reg_v.r = reg_v.r >> 1
		reg_v.r = reg_v.r & $FF
		return
	}

	if mathcode = $7 {
		getreg2 = opcode & $FF >> 4
		reg_v.r = reg_v.getreg2 - reg_v.r
		reg_v.$F = reg_v.r >> 8 + 1
		reg_v.r = reg_v.r & $FF
		return
	}

	if mathcode = $E {
		reg_v.$F = reg_v.r >> 7
		reg_v.r = reg_v.r << 1
		reg_v.r = reg_v.r & $FF
		return
	}

	mathcode_debug = mathcode : str mathcode_debug,16
	dialog "Invalid Opcode. (maths - $"+mathcode_debug+")",3,"Error"
	if stat = 7 : end

	return


/*-----------------------------------------------------------------------
	Draw Sprite ($D)
-----------------------------------------------------------------------*/
*draw_sprite
	x = opcode >> 8 & $F
	y = opcode & $00FF >> 4
	h = opcode & $F

	xp = reg_v.x
	yp = reg_v.y

	y = 0
	N = 0
	offset = 0

	if h = 0 {
		h = 16 : w = 16
	} else {
		w = 8
	}

	while y < h

		x = 0

/*
		if w = 16 {
			peek sprite2_a,filedata,reg_i + N
			peek sprite2_b,filedata,reg_i + N + 1

			sprite2_c = sprite2_a;; << 8
			dec2bin sprite2_d,sprite2_c
;dialog ""+sprite2_d,3 : if stat = 7 :end
			dec2bin sprite2_e,sprite2_b
			
			sprite = ""+sprite2_d+""+sprite2_e+""
;dialog ""+sprite,3 : if stat = 7 :end
			strlen sprite_length,sprite
			while sprite_length < 16
				sprite = "0"+sprite
				strlen sprite_length,sprite
			wend
		} else {
			peek sprite_a,filedata,reg_i + N
			dec2bin sprite_b,sprite_a
			sprite = ""+sprite_b

			strlen sprite_length,sprite
			while sprite_length < 8
				sprite = "0"+sprite
				strlen sprite_length,sprite
			wend
		}
*/

;	OLD
		peek sprite_a,filedata,reg_i + N
		dec2bin sprite_b,sprite_a

		sprite = ""+sprite_b
		
		strlen sprite_length,sprite
		while sprite_length < 8
			sprite = "0"+sprite
			strlen sprite_length,sprite
		wend

		if w = 16 {
			peek sprite2_a,filedata,reg_i + N + 1
			dec2bin sprite2_b,sprite2_a

			sprite2 = ""+sprite2_b

			strlen sprite2_length,sprite2
			while sprite2_length < 8
				sprite2 = "0"+sprite2
				strlen sprite2_length,sprite2
			wend
			sprite = ""+sprite+""+sprite2+""
		}


		repeat

			strmid sprite_data,sprite,x,1

			if sprite_data = "1" {

				tx = x + xp
				ty = y + yp

				ty += yoffst
				if ty > 63 : ty -= 63

				tx += (xoffst * 4)
				if tx > 127 : tx -= 127

				posa = 64 * screen_mode * ty + tx
				screen_data.posa = screen_data.posa ^ 1

				if (screen_data.posa != 1) {
					reg_v.$F = 1

					color 33,36,255		; obNOEh
					boxf tx*2, ty*2, tx*2+1, ty*2+1
;;					pset tx,ty

				} else {
					reg_v.$F = 0

					color 255,255,255	; XvCg
					boxf tx*2, ty*2, tx*2+1, ty*2+1
;;					pset tx,ty
				}
			}

			x++
			if x < w : continue : else : break
		loop

		N++
		if w = 16 : N++
		y++

	wend

	return


*create_dsp_area
	h = 32
	w = 64

	y = 0

	h = h * screen_mode
	w = w * screen_mode
	i = 0

	while y < h

		x = 0

		while x < w

;			color 33,36,255
;			pset x,y
;			boxf ,,256,128

			x++
		wend

	y++

	wend

	return


*scrolldown
	px = opcode & $FF >>4

	SS = 6 / screen_mode

	ypos = yoffst - 1
	if ypos < 0 : ypos = 63

	arraypos = 128 * ypos

	x = 0
	while x < 128
		color 33,36,255
		pset x,ypos
		arraypos2 = arraypos + x
		screen_data.arraypos2 = 0
		x++
	wend

	yoffst--
	if yoffst < 0 : yoffst = 63

	return


*scrollright
	xpos = xoffst - 1
	if xpos < 0 : xpos = 127

	xoffst--
	if xoffst < 0 : yoffst = 127

	return


*scrollleft
;	dialog ""
	SS = 6 / screen_mode * 4

	xpos = xoffst - 1
	if xpos < 0 : xpos = 31

	x = xoffst * 4

	repeat

		repeat
			leftdata = 128 * cnt + x
			screen_data.leftdata = 0
			
			color 33,36,255
			pset x,cnt

			if cnt < 64 : break
		loop

		x++
		if cnt < 4 : break
	loop

	xoffst++
	if xoffst > 31 : xoffst = 0

	return


/*-----------------------------------------------------------------------
	Debug
-----------------------------------------------------------------------*/
*debug_info1
	reg_pc_debug = reg_pc : str reg_pc_debug,16
	opcode_debug = opcode : str opcode_debug,20
	A_debug = A : str A_debug,16
	reg_i_debug = reg_i : str reg_i_debug,16

	reg_v_debug_0 = reg_v.0 : str reg_v_debug_0,16
	reg_v_debug_1 = reg_v.1 : str reg_v_debug_1,16
	reg_v_debug_2 = reg_v.2 : str reg_v_debug_2,16
	reg_v_debug_3 = reg_v.3 : str reg_v_debug_3,16
	reg_v_debug_4 = reg_v.4 : str reg_v_debug_4,16
	reg_v_debug_5 = reg_v.5 : str reg_v_debug_5,16
	reg_v_debug_6 = reg_v.6 : str reg_v_debug_6,16
	reg_v_debug_7 = reg_v.7 : str reg_v_debug_7,16
	reg_v_debug_8 = reg_v.8 : str reg_v_debug_8,16
	reg_v_debug_9 = reg_v.9 : str reg_v_debug_9,16
	reg_v_debug_A = reg_v.$A : str reg_v_debug_A,16
	reg_v_debug_B = reg_v.$B : str reg_v_debug_B,16
	reg_v_debug_C = reg_v.$C : str reg_v_debug_C,16
	reg_v_debug_D = reg_v.$D : str reg_v_debug_D,16
	reg_v_debug_E = reg_v.$E : str reg_v_debug_E,16
	reg_v_debug_F = reg_v.$F : str reg_v_debug_F,16

	sdim debug_data1,256
	debug_data1 = "\n"+opcode_debug+" ($"+A_debug+")\nPC : "+reg_pc_debug+";  I : "+reg_i_debug+"\n0 : "+reg_v_debug_0+";  1 : "+reg_v_debug_1+"\n2 : "+reg_v_debug_2+";  3 : "+reg_v_debug_3+"\n4 : "+reg_v_debug_4+";  5 : "+reg_v_debug_5+"\n6 : "+reg_v_debug_6+";  7 : "+reg_v_debug_7+"\n8 : "+reg_v_debug_8+";  9 : "+reg_v_debug_9+"\nA : "+reg_v_debug_A+";  B : "+reg_v_debug_B+"\nC : "+reg_v_debug_C+";  D : "+reg_v_debug_D+"\nE : "+reg_v_debug_E+";  F : "+reg_v_debug_F+"\nDT: "+dtimer+""
	dialog debug_data1,2,"Dubug"
	if stat = 7 : end

	return

*debug_info2
	reg_pc_debug = reg_pc : str reg_pc_debug,16
	opcode_debug = opcode : str opcode_debug,20
	A_debug = A : str A_debug,16
	reg_i_debug = reg_i : str reg_i_debug,16

	debug_data2 += ""+opcode_debug+" ($"+A_debug+");  PC: "+reg_pc_debug+";  I: "+reg_i_debug+"\n"

//	if cnt = 100 : notesave exedir+"\\lchip8_debug.txt" : exec "notepad "+exedir+"\\lchip8_debug.txt" : end	

	return

*exit
	end
