// ******************************************************
// 			  buffer.h  
// by Windy 2002-2003
// *******************************************************
#include <stdio.h>
#include <stdlib.h>
#include "buffer.h"

// ****************************************************************************
//          soundbuffer: $B%5%&%s%I%P%C%U%!(B
// ****************************************************************************
//  short  buffer[SOUND_BUFSIZE*101];

struct _buffer {
  int   read_idx;
  int   write_idx;
  int   length;
  int   datas;
  short *buffer;
} soundbuffer;



// ****************************************************************************
//          init_soundbuffer: $B%5%&%s%I%P%C%U%!$N=i4|2=(B
// ****************************************************************************
int init_soundbuffer(int size)
{
    int ret;
    soundbuffer.read_idx=0;
    soundbuffer.write_idx=0;
    soundbuffer.length= size;
    soundbuffer.datas =0;
  
    soundbuffer.buffer = (short*)malloc( (size+1024)*sizeof(short) );
    if( soundbuffer.buffer !=NULL)
        {
        memset( soundbuffer.buffer,0, (size+1024)*sizeof(short));
        ret = 1;
        }
    else
        ret = 0;
    return( ret);
  //printf("init_soundbuff() \n");
}

void Trash_soundbuffer(void)
{
    if( soundbuffer.buffer !=NULL)
        {
        free( soundbuffer.buffer );
        soundbuffer.buffer = NULL;
        }
}

// ****************************************************************************
//          read_soundbuffer: $B%5%&%s%I%P%C%U%!$NFI$_9~$_(B
//  IN: buffer:$B%P%C%U%!(B
//      size:  $B%P%$%H?t(B
//  Out: non zero: read data numbers     0 :no data
// ****************************************************************************
int read_soundbuffer(short *buffer,unsigned int size)
{
 int ret;
 ret=0;
// assert( soundbuffer.datas >=0 && soundbuffer.datas < soundbuffer.length-1);
    if( soundbuffer.buffer ==NULL) {printf("not initialize sound buffer"); return 0;}


    if( soundbuffer.datas>0)
      	{
         unsigned int i;
         for(i=0;i<size /sizeof(short) ;i++)
         	{
    		 *(buffer+i) =soundbuffer.buffer[ soundbuffer.read_idx];
    		 if( ++soundbuffer.read_idx > soundbuffer.length)
    			{
    			 soundbuffer.read_idx=0;
    			}
    		 soundbuffer.datas--; if( soundbuffer.datas<0) {soundbuffer.datas=0; break;}
             ret++;
    		 printf("read) zan datas==%d\n",soundbuffer.datas);
            }
	    }
/* else
	 printf("read) no data \n"); */
     
 return(ret);
}


// ****************************************************************************
//          write_soundbuffer: $B%5%&%s%I%P%C%U%!$X$N=q$-9~$_(B
//  IN: buffer:$B%P%C%U%!(B
//      size:  $B%P%$%H?t(B
// ****************************************************************************
void write_soundbuffer(short *buffer,unsigned int size)
{
    if( soundbuffer.buffer ==NULL) {printf("not initialize sound buffer"); return;}

    if( soundbuffer.datas < soundbuffer.length)
      	{
    	 unsigned int i;
         for(i=0; i< size/sizeof(short); i++)
         	{
    	     soundbuffer.buffer[ soundbuffer.write_idx] = *(buffer+i);
    	     if( ++soundbuffer.write_idx >soundbuffer.length)
    			{
    			soundbuffer.write_idx=0;
    			}
    		soundbuffer.datas++;
          	}
         printf("write_soundbuffer datas=%d \n",soundbuffer.datas);
    	}
}










// ****************************************************************************
//           key buffer (ring buffer)
// ****************************************************************************
struct _buffer2 {
  int   read_idx;
  int   write_idx;
  int   length;
  DWORD wParam[1024];
  DWORD lParam[1024];
  char  chr   [1024];
} keybuffer;



void init_keybuffer(void)
{
  keybuffer.read_idx=0;
  keybuffer.write_idx=0;
  keybuffer.length=1024-1;
}

void write_keybuffer(DWORD wParam , DWORD lParam , char chr)
{
  keybuffer.wParam[ keybuffer.write_idx]= wParam;
  keybuffer.lParam[ keybuffer.write_idx]= lParam;
  keybuffer.chr   [ keybuffer.write_idx]= chr;
  if( ++keybuffer.write_idx >keybuffer.length)
	{
	 keybuffer.write_idx=0;
	}
}

int read_keybuffer(DWORD *wParam , DWORD *lParam , char *chr)
{
 int ret;
 ret=0;
  if( keybuffer.read_idx != keybuffer.write_idx)
  	{
	 if(wParam) *wParam = keybuffer.wParam[ keybuffer.read_idx];
	 if(lParam) *lParam = keybuffer.lParam[ keybuffer.read_idx];
	 if(chr   ) *chr    = keybuffer.chr   [ keybuffer.read_idx];
	 if( ++keybuffer.read_idx >keybuffer.length)
		{
		 keybuffer.read_idx=0;
		}
	 ret=1;
	}
 return(ret);
}

