/** iP6: PC-6000/6600 series emualtor ************************/
/**                                                         **/
/**                     fm.cpp                              **/
/**               fmgen interface                           **/
/** Written by Windy 2002                                   **/
/*************************************************************/



#define  NDEBUG
#include <stdio.h>
#include <assert.h>
#include <memory.h>
#include "Sound.h"
#include "fmgen/headers.h"
#include "fmgen/opna.h"

#define  EXTERNC	// extern "C" interface
#include "fm.h"


FM::OPN opn;
FM::Sample buffMix[ SOUND_BUFSIZE];



// **************************************************
//	YM-2203 init
// **************************************************
int ym2203_init(void)
{
 if( !opn.Init( 3993600, SOUND_RATE,1)) {
 	printf("opn initialize error \n");
 	return(0);
 	}
 opn.Reset();
 opn.SetVolumeFM(12);
 opn.SetVolumePSG(12);
 return(1);
}

// **************************************************
//	YM-2203 setreg
// **************************************************
void ym2203_setreg(int r,int v)
{
 //printf("r=%2X ,v=%2X \n",r,v);
 opn.SetReg( r,v);
}

// **************************************************
//	YM-2203 getreg
// **************************************************
int ym2203_getreg(int r)
{
 int v;
 v= opn.GetReg( r);
 return( v);
}

// **************************************************
//	YM-2203 makewave
// In: dest: buffer
//     size: $B%P%$%H?t(B 
// **************************************************
void ym2203_makewave( short *dest ,int size)
{
 assert(size <= SOUND_BUFSIZE*2);

 memset(  buffMix, 0, sizeof(buffMix));
 opn.Mix( buffMix, size/ sizeof( FM::Sample));
//opn.Mix( buffMix, SOUND_BUFSIZE/2);
// opn.Mix( buffMix, sizeof(buffMix)/sizeof(buffMix[0])/2);
// opn.Count( 1000000/10);
// opn.Count( 20000);		// $BE,@5$JCM$O$$$/$i$G$7$g$&!)!!(B(^^;; 2003/10/13
 opn.Count( 30000);	
 downcast16( dest , buffMix ,size/sizeof(short));		// down cast
}

// **************************************************
//	fmgen down cast  32bit --> 16bit
// **************************************************
void downcast16( short *dest , FM::Sample *src ,int length)
{
 short *p;
 FM::Sample tmp;
 int i;
 
 if( CHANNEL==1) length/=2;		 // channel =1 , left sound only 2003/1/2
 
 p=dest;
 for(i=0 ; i< length  ; i++)
 	{
 	 tmp= *src;
 	 if( tmp < -32768) {tmp= -32768;}
 	 if( tmp >  32767) {tmp=  32767;}
 	 *p= (short)tmp;
 	 src+= (CHANNEL==2)? 1:2;	// channel =1 , left sound only 2003/1/2
 	 p++;

 	}
}


// ****************************************************************************
//          ym2203_Count : fmgen $B%+%&%s%H=hM}(B
// ****************************************************************************
int ym2203_Count(int us)
{
 return( opn.Count( us));
}

// ****************************************************************************
//          ym2203_GetNextEvent : fmgen $B<!$K%?%$%^!<$,H/@8$9$k$^$G$N;~4V$r5a$a$k(B
// ****************************************************************************
int ym2203_GetNextEvent(void)
{
 return( opn.GetNextEvent());
}





// ****************************************************************************
//          ym2203_ReadStatus: YM2203 $B$N%9%F!<%?%9$rFI$`(B
//
// Out: YM2203 $B$N%9%F!<%?%9!!(B(TimerA $B$H(BTimerB$B$N%*!<%P!<%U%m!<%U%i%0!&(BBUSY$B%U%i%0$b!#(B)
// ****************************************************************************
int ym2203_ReadStatus(void)
{
 static int cnt=5;  /* 10;*/	/* $B$3$NCM$OE,Ev!#(B(^^;  */
 int ret;
 ret= opn.ReadStatus();


 cnt--;			/* $B5<;wE*$K!"(BBUSY$B%U%i%0$r:n$C$F$_$k!#(Badd 2003/10/26 */
 if( cnt >0)
 	ret |= 0x80;	/* BUSY */
 else
 	{
    cnt  = 5; /* 100; */
 	ret &= ~0x80;	/* READY */
    }
 return( ret);
}

/* bug fixed:

$BIT3P$K$b!"0lEY(BREADY$B$K$J$C$?$"$H$N=i4|CM$r!"(B
100$B$K$7$F$$$?$N$G!"(BFM$B2;8;$,CY$/$J$C$F$$$^$7$?!#?=$7Lu$J$$$G$9!#(B

Rel.4.7 $B$N(BBlocking Bug 
2004/2/3  Windy
*/

#if 0
// **************************************************
//	YM-2203 makewave
// **************************************************
void ym2203_makewave( short *dest )
{
 memset(  buffMix, 0, sizeof(buffMix));
 opn.Mix( buffMix, SOUND_BUFSIZE/2);
// opn.Mix( buffMix, sizeof(buffMix)/sizeof(buffMix[0])/2);
// opn.Count( 1000000/10);
// opn.Count( 20000);		// $BE,@5$JCM$O$$$/$i$G$7$g$&!)!!(B(^^;; 2003/10/13
   opn.Count( 30000);	
    downcast16( dest , buffMix ,SOUND_BUFSIZE);		// down cast
}
#endif
