/** iP6: PC-6000/6600 series emualtor ************************/
/**                                                         **/
/**                         WinSound.c                      **/
/**                                                         **/
/** modified by windy 2002-2003                             **/
/** This code is based on fMSX written by Marat Fayzullin   **/
/*************************************************************/
/*
int InitSound(void );       $B%5%&%s%I%I%i%$%P$r=i4|2=$7$^$9!#(B

void TrashSound(void);  	$B%5%&%s%I%I%i%$%P$N8e=hM}$r$7$^$9!#(B

void PSGOut(byte R,byte V)	$B%5%&%s%I%I%i%$%P$K!"%l%8%9%?$H%G!<%?$NAH$r=PNO$7$^$9!#(B

void SoundOut(byte R,byte V);	$B%5%&%s%I%I%i%$%P$K!"%l%8%9%?$H%G!<%?$NAH$r=PNO$7$^$9!#(B

void FlushSound(void)       $B%l%8%9%?$H%G!<%?$NAH$_$r!!%P%C%U%!%j%s%0$7$F$$$k$N$r%U%i%C%7%e$7$^$9!#(B

void StopSound(void)        $B%5%&%s%I%9%l%C%I$r0l;~Dd;_$7$^$9!#(B

void ResumeSound(void)      $B0l;~Dd;_$7$?(B $B%5%&%s%I%9%l%C%I$r:F3+$7$^$9!#(B

static DWORD WINAPI SoundMainLoop( LPVOID param)

	$B%5%&%s%I%G%P%$%9$,!!<!$N%5%&%s%I%G!<%?$r=PNO$9$k%?%$%_%s%0$r!!4F;k$9$k%9%l%C%I$G$9!#(B
	$BI,MW$G$"$l$P!"<!$N%G!<%?$r(B fmgen $B$G@8@.$7$F!"(B
	$B%5%&%s%I%G%P%$%9$K=PNO$7$^$9!#(B

static DWORD WINAPI SoundSubLoop( LPVOID param)

	$B%l%8%9%?!"%G!<%?$NAH$,Aw$i$l$F$/$k$N$rBT$A<u$1$k%9%l%C%I$G$9!#(B
	fmgen $B$KBP$7$F!"%l%8%9%?!"%G!<%?$rJQ99$7$^$9!#(B


static void play_sub(short *src,int len)

	$B%5%&%s%I%G%P%$%9$K=PNO$7$^$9!#%P%C%U%!%j%s%0$b$7$F$$$^$9!#(B

----------------------------------------------------------------------
Special Thanks:

$B%A%g%3$\$s$5$s$K!"%9%l%C%I$rDI2C$7$F$b$i$$$^$7$?!#(B(^^; 
CPU$B@jM-N($NDc2<$K4sM?$7$F$$$^$9!#(B
$B$"$j$,$H$&$4$6$$$^$7$?!#(B(2003/11)
*/
#define USECREATE
#define USEPIPE
#define USERING

#ifdef SOUND
#ifdef WIN32

#include "P6.h"
#include "Z80.h"
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>

#include <assert.h>
#include <windows.h>
#include <process.h>
#include "fm.h"
#include "Win32.h"
#include "buffer.h"
#include "Sound.h"


// **************************************************
//		Variables
// **************************************************
int sounddev=-1;
int sound_rate=SOUND_RATE;
int UseSound=1;
int newUseSound;
int UseSCC=0;

int SoundThreadRun;
int SoundSubThreadRun;

short soundbuf[SOUND_BUFSIZE];

// --------------- WIN32 Variables -------------
MMRESULT     mmRes;					// result
HWAVEOUT     hwo;					// sound device handle
WAVEFORMATEX wfx;					// format setting
WAVEHDR      whdr[ WINSOUND_BUFFERS];		// data block

static short pcmBuffer[ WINSOUND_BUFFERS][ SOUND_BUFSIZE];  // pcm buffer
static int sidx;
static int pre_sidx;

CRITICAL_SECTION   CriticalSection;	// critical section 

static DWORD    dwThreadId1;	        	// id of thread
static DWORD    dwThreadId2;	        	// id of thread
HANDLE   hThread1;					// handle of thread
HANDLE   hWrite=0 ,hstd=0;  		// handle of pipe



// **************************************************
//		functions
// **************************************************
static void play_sub(short *src,int len);
static void idle(DWORD msec);

#ifdef USECREATE
DWORD WINAPI SoundMainLoop( LPVOID param);
#else
void _USERENTRY SoundMainLoop( void *param);
#endif



// **************************************************
//		Trash sound
// **************************************************
void TrashSound(void)
{
int i;
	if(UseSound) {
        printf("Closing sound system...");
		SoundThreadRun=0;			/* thread aborting...*/
		SoundSubThreadRun=0;		/* thread aborting...*/
		Sleep(1000);
	    CloseHandle( hThread1 );
	    CloseHandle( hWrite );

	    for(i=0; i< WINSOUND_BUFFERS; i++)
		    waveOutUnprepareHeader(hwo,&whdr[i],sizeof(WAVEHDR));
	    waveOutClose( hwo);
	    DeleteCriticalSection( &CriticalSection);
        printf("Done\n");
	   }
}



// **************************************************
//		Init Sound
// **************************************************
int InitSound(void )
{
  HANDLE   hPipe;
  HANDLE   hRead;
  SECURITY_ATTRIBUTES sa;
  int i;

  SoundThreadRun=1;	/* True: Thread run   False: Thread abort */
  SoundSubThreadRun=1;	/* True: Thread run   False: Thread abort */

  if(!UseSound) return(0);
  if(Verbose) printf("Starting sound server:");

  UseSound=0; sounddev=-1; //soundchildpid=0;

#ifdef USERING
  init_soundbuffer(SOUND_BUFSIZE*100);
#endif

 // -------------- open pipe ----------------------------
#ifdef USEPIPE
  if(Verbose) printf("  Opening pipe...");
   sa.nLength = sizeof(SECURITY_ATTRIBUTES);
   sa.lpSecurityDescriptor = NULL;
   sa.bInheritHandle = TRUE;
   if(!CreatePipe( &hRead, &hWrite, &sa, 1024))
  	{
	  putlasterror();
	  return(0);
	}
#endif

 // -------------- Non blocking mode --------------------
/*
 {
  DWORD   Mode     = PIPE_NOWAIT;
  assert( SetNamedPipeHandleState( hRead, &Mode ,NULL, NULL));
 }
*/

#ifdef USEPIPE
  //printf("main) hWrite=%d\n",hWrite);
  //printf("main) hRead=%d\n",hRead);
  hstd =  GetStdHandle( STD_INPUT_HANDLE ); // backup
  if( !SetStdHandle(  STD_INPUT_HANDLE , hRead))
  	{
	  putlasterror();
	  return(0);
	}
#endif

 // -------------- Critical Section --------------------
  InitializeCriticalSection ( &CriticalSection);

 // -------------- start Thread -------------------------------------
  if(Verbose) { printf("OK\n  create Sound Thread...\n"); }

#ifdef USECREATE
  hThread1= CreateThread(NULL,0,
      (LPTHREAD_START_ROUTINE) SoundMainLoop ,
      0 /*(LPVOID)&hwndMain*/,
      0, 
      &dwThreadId1);
  if( !hThread1 )
  	{
	  putlasterror();
	  return(0);
	}
#endif // USEPIPE

 // -------------- open device --------------------------
   if(Verbose) printf("OK\nOpening Sound device...");
     wfx.wFormatTag    = WAVE_FORMAT_PCM;
     wfx.nChannels     = CHANNEL;
     wfx.nSamplesPerSec= SOUND_RATE;		// sampling rate freq.
     wfx.wBitsPerSample= SAMPLING_BITS;		// sampling bit
     wfx.nBlockAlign   = wfx.nChannels * wfx.wBitsPerSample / 8;
     wfx.nAvgBytesPerSec=wfx.nSamplesPerSec * wfx.nBlockAlign;
     wfx.cbSize = 0;

	 mmRes = waveOutOpen( &hwo,WAVE_MAPPER, &wfx,(DWORD)(LPVOID)dwThreadId1
	 ,(DWORD)NULL, CALLBACK_THREAD );
	 if( mmRes != MMSYSERR_NOERROR) {
			messagebox("wave device open error \n","");
	        return(0);
			}

  if(Verbose) puts("OK");

  Sleep(100);
#ifdef USEPIPE
  //  assert(SetStdHandle(  STD_INPUT_HANDLE, hstd)); // $BI{:nMQ%3!<%I$O(Bassert$B$KF~$l$l$J$$(B
  SetStdHandle(  STD_INPUT_HANDLE  , hstd);	// restore std handle
#endif

 // -------------- pomping sound buffers  --------------------------
  for(i=0 ; i< WINSOUND_BUFFERS; i++)
	{
	whdr[i].lpData = (char*)pcmBuffer[ i];
	whdr[i].dwBufferLength = sizeof( soundbuf);
	memset(whdr[i].lpData, 0,sizeof( soundbuf));
	whdr[i].dwBytesRecorded=0;
	whdr[i].dwUser=0;
	whdr[i].dwFlags=0;
	whdr[i].dwLoops=1;
	whdr[i].lpNext =NULL;
	whdr[i].reserved=0;

	//assert(hwo);
	
     mmRes = waveOutUnprepareHeader( hwo, &whdr[i], sizeof(WAVEHDR));
	 if( mmRes != MMSYSERR_NOERROR) {
			messagebox("waveOutUnPrepareHeader(): failed!!","");
	 	        return(0);
			}
	 mmRes = waveOutPrepareHeader(hwo, &whdr[i],sizeof(WAVEHDR));
	 if( mmRes != MMSYSERR_NOERROR) {
			messagebox("waveOutPrepareHeader(): failed!!\n","");
	 	        return(0);
			}
	// ******************** play **********************************
	 mmRes = waveOutWrite(        hwo, &whdr[i],sizeof(WAVEHDR));
	 if( mmRes != MMSYSERR_NOERROR) {
			messagebox("waveOutWrite(): failed!!","");
		        return(0);
			}
	}


  UseSound=1;return(1);
}

// **************************************************
//		Sound Output
// **************************************************
void SoundOut(byte R,byte V)
{
  static unsigned char Buf[1024];
  static int Buffered = 0;
  DWORD  rc;
  int    Result;

  if(UseSound) 
   {
#ifdef USEPIPE
    if((R==0xFF)||(Buffered>=sizeof(Buf))) {
	// write(soundpipe[1],Buf,Buffered);   // send to child
      if( Buffered>1)
		{
		 //printf("write) %d ,%d\n",Buf[0],Buf[1]);
		 Result = WriteFile( hWrite ,Buf,Buffered,&rc,0);
		 assert(Result);
		 //printf("rc=%d ,%d\n",rc);
		}
      Buffered = 0;
     }
    if(R!=0xFF) {
      Buf[Buffered++]=R; Buf[Buffered++]=V;
    }
#else
	ym2203_setreg(R,V);
#endif  // USEPIPE
   }
}

void FlushSound(void)      
		{ 
#ifdef USEPIPE
		SoundOut(0xFF,0);
#endif
 		}
void StopSound(void)       { if(UseSound)  SuspendThread( hThread1); }
void ResumeSound(void)     { if(UseSound)  ResumeThread( hThread1); }
void PSGOut(byte R,byte V) { if(R<0xc0||R==0xFF) SoundOut(R,V); }
void SCCOut(byte R,byte V) { if(UseSCC&&R<0x90) SoundOut(R+0x10,V); }




// **************************************************
//	Sound Sub Thread
// **************************************************
static DWORD WINAPI SoundSubLoop( LPVOID param)
{
	int r=0, v=0, i, j=0, x;
	int rp=-1,vp=-1;
	DWORD rc;
	unsigned char buf[2];
	int Result;
	HANDLE hRead = (HANDLE)param;

	//	printf("SoundSubThread is running...\n");
	while( SoundSubThreadRun)
	{
		// Read from pipe:
		assert( hRead);

		Result= ReadFile( hRead, buf, v<0? 1:2, &rc,(LPOVERLAPPED)0);
		if( !Result) break;
		if( rc == 0 ) break;

		// printf("Done.\nReadFile: rc=%d Result=%d\n",rc,Result);
		// printf("read) r=%X,v=%X \n",buf[0],buf[1]);

		r= buf[0];
		v= buf[1];
		ym2203_setreg(r,v);
		//printf("setreg  r=%d  v=%d \n",r,v);

#ifdef USERING
		if( r==7 && keyclick)
		    {
			int v0,v1;
			v0=ym2203_getreg(0);
			v1=ym2203_getreg(1);
			ym2203_setreg(0,0);
			ym2203_setreg(1,0);
			ym2203_makewave( soundbuf, sizeof(soundbuf));
			write_soundbuffer( soundbuf ,sizeof(soundbuf));
			ym2203_setreg(0,v0);
			ym2203_setreg(1,v1);
		    }
		rp=r; vp=v;
#endif  // USERING
	}
return(0);
}

// **************************************************
//	Sound Thread
// **************************************************
#ifdef USECREATE
static DWORD WINAPI SoundMainLoop( LPVOID param)
#else
void _USERENTRY SoundMainLoop( void *param)
#endif
{
  int ii;
  MSG Msg;
  HANDLE hRead;
  
  int   tmp;

  int   nomsg;
// toma added 2003.08.16
  HANDLE hThreadSubLoop = NULL;
//

#ifdef USEPIPE
  hRead = GetStdHandle( STD_INPUT_HANDLE );
  assert( hRead);
#endif
  sidx=0;		// buffer index 

#if 0
  printf("thread) hRead=%d\n",hRead);
  testPutHeader();      // test WAVE format
  signal( SIGUSR1, SoundSignal );
  signal( SIGUSR2, SoundSignal );
  ay8910_init();
#endif

  ym2203_init();

    if(Verbose) { printf("  creating sound Thread sub..."); }

// toma added 2003.08.16
	hThreadSubLoop = CreateThread(
		NULL,                    // SD
		0,                       // initial stack size
		(LPTHREAD_START_ROUTINE)SoundSubLoop,    // thread function
		(LPVOID)hRead,                           // thread argument
		0,                                       // creation option
		&dwThreadId2                             // thread identifier
	);
	if( hThreadSubLoop !=NULL) 
		{printf("OK\n");} 
	else
        { printf("FAILED\n");putlasterror(); }
	CloseHandle(hThreadSubLoop);
//

  while( SoundThreadRun)
    {
	nomsg=0;
	  if(GetMessage(&Msg, 0,0,0)) 
		 {
		  switch( Msg.message)
			{
			case MM_WOM_CLOSE: //printf("thread) close\n");
					EnterCriticalSection( &CriticalSection);
				  	CloseHandle( hRead);
					LeaveCriticalSection( &CriticalSection);
				  	return(0); 

			case MM_WOM_DONE:  //printf("thread) done\n");
                    {
                    int ret;
                    ret =0;
					EnterCriticalSection( &CriticalSection);
#ifdef USERING
					ret = read_soundbuffer( soundbuf,sizeof(soundbuf));	// for key click sound 
                    if( ret==0)
#endif
                        {
						ym2203_makewave( soundbuf ,sizeof(soundbuf));
                        }

                    play_sub(soundbuf ,sizeof(soundbuf) / ((CHANNEL==2)?1:2));
									// channel=1 , left sound only 2003/1/2
//					testPutData((char*)soundbuf, sizeof(soundbuf));
					LeaveCriticalSection( &CriticalSection);
					break;
                    }
			default:nomsg =1; break;
		   }
		}
     }   	// while(1)
 return(0);
}




// **************************************************
//	idle
// **************************************************
static void idle(DWORD msec)
{
 DWORD i;
 int a;
// for( i= 0; i< 10000000; i++) { a=a+3;}

 for( i= GetTickCount()+msec;  GetTickCount()< i; Sleep(0));

}

// **************************************************
//	   play sub
// ******y********************************************
//static void play_sub(char *src,int len)
static void play_sub(short *src,int len)
{
	EnterCriticalSection( &CriticalSection);

#if 1
     mmRes= waveOutUnprepareHeader( hwo, &whdr[sidx], sizeof(WAVEHDR));
	 if( mmRes != MMSYSERR_NOERROR) {
			printf("waveOutUnPrepareHeader(): failed!!\n");
			}
#endif


//	whdr[sidx].lpData = pcmBuffer[ sidx];
	whdr[sidx].dwBufferLength = len;
	CopyMemory( whdr[sidx].lpData ,(char*)src, len);	// read data

	whdr[sidx].dwBytesRecorded=0;
	whdr[sidx].dwUser=0;
	whdr[sidx].dwFlags=0;
	whdr[sidx].dwLoops=1;
	whdr[sidx].lpNext =NULL;
	whdr[sidx].reserved=0;


	 mmRes = waveOutPrepareHeader(hwo, &whdr[sidx],sizeof(WAVEHDR));
	 if( mmRes != MMSYSERR_NOERROR) {
			messagebox("wave device PrepareHeader: failed!!","");
	 	    return;
			}
	// ******************** play **********************************
	 mmRes = waveOutWrite(        hwo, &whdr[sidx],sizeof(WAVEHDR));
	 if( mmRes != MMSYSERR_NOERROR) {
			messagebox("wave device Write failed!!","");
		    return;
			}
pre_sidx= sidx;
if( sidx < WINSOUND_BUFFERS-1)
    sidx++;
else
    sidx=0;

	LeaveCriticalSection( &CriticalSection);

}






#if 0
// ********************** put data of wav file *****************************
int testPutData(char *src,int length)
    {
      FILE *fp;
      char path[256];
      strcpy( path,"output.wav");

      fp=fopen( path,"a+b");
      if(fp==NULL) {printf(" %s open error\n",path); exit(0);}
      fwrite( src,length,1,fp);
      fclose(fp);
      return(0);
     }

// ********************** put header of wav file *****************************
int testPutHeader(void)
    {
     int maxLen;
     int dataLen;

      WAVEFORMATEX wfx;	// format setting
      FILE *fp;
      char buf[5];
      int tmp;
      char path[256];

     strcpy( path,"output.wav");
   // --------------- user setting -------------------------
     dataLen= SOUND_BUFSIZE*100000;	// length of data
     maxLen = dataLen+46;		// length of max
     wfx.nChannels     = CHANNEL;	// channel             2ch / 1ch
     wfx.nSamplesPerSec= SOUND_RATE;	// sampling rate freq. 44100/ 22050 ...
     wfx.wBitsPerSample= SAMPLING_BITS;// sampling bit        16bit/ 8bit

   // --------------- don't touch  -------------------------
     wfx.wFormatTag    = WAVE_FORMAT_PCM;
     wfx.nBlockAlign   = wfx.nChannels * wfx.wBitsPerSample / 8;
     wfx.nAvgBytesPerSec=wfx.nSamplesPerSec * wfx.nBlockAlign;
     wfx.cbSize = 0;

      fp=fopen(path,"w+b");
      if(fp==NULL) {printf(" output.wav open error\n"); exit(0);}

      strcpy( buf,"RIFF");  fwrite( buf,4,1,fp);
      tmp= maxLen-8;
      memcpy( &buf,&tmp,4); fwrite( buf,4,1,fp);
      strcpy( buf,"WAVE");  fwrite( buf,4,1,fp);

      strcpy( buf,"fmt ");  fwrite( buf,4,1,fp);
      tmp= sizeof(WAVEFORMATEX);
      memcpy( &buf,&tmp,4); fwrite( buf,4,1,fp);
      fwrite( &wfx, tmp,1,fp);

      strcpy( buf,"data");  fwrite( buf,4,1,fp);
      tmp= dataLen;
      memcpy( &buf,&tmp ,4);fwrite( buf,4,1,fp);
      fclose(fp);
      return(0);
     }
#endif

#endif SOUND
#endif WIN32
