/** iP6: PC-6000/6600 series emualtor ************************/
/**                                                         **/
/**                           Option.c                      **/
/** modified by Windy 2002                                  **/
/** This code is based on ISHIOKA Hiroshi 1998-2000         **/
/** This code is based on fMSX written by Marat Fayzullin   **/
/*************************************************************/
/* TO DO :  Win32 $B$+$iC&5Q$9$k!#(B*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>


#include "P6.h"
#include "Sound.h"
#include "Refresh.h"
#include "Help.h"
#include "Option.h"

#include "os.h"

extern int SaveCPU;

#ifdef MITSHM
extern int UseSHM;
#endif

extern int isFullScr;


// ****************************************************************************
//          Internal variable
// ****************************************************************************
static FILE *configStream;
static char ConfigPath[PATH_MAX];	// config file path


// ****************************************************************************
//          CONFIG FILE OPTIONS
// ****************************************************************************
char *ConfigOptions[]=
{ 
"[CONFIG]","P6Version=","UseSound=","disk_num=","CPUclock=","scale=","intLac=",
"CasPath=","DskPath=","CasName=","DskName=","scr4col=","drawWait=","FastTape=",
"UPeriod=","extkanjirom=","extram=","srline=",
"ImgPath=","MemPath=",
"Ext1Name=","Ext2Name=","dummy=",
"CasPath(save)=","CasName(save)=",
"UseSaveTapeMenu=","UseStatusBar=",
"UseDiskLamp=",
NULL
};


// ****************************************************************************
//          ConfigInit
// ****************************************************************************
void ConfigInit(void)
{
//#ifdef WIN32
 ConfigPath[0]=0;
 if( getcwd(ConfigPath, PATH_MAX)==NULL)
	{
	 messagebox("getcwd failed","");
     printf("getcwd failed\n");
	}
 strcat(ConfigPath,"\\ip6kai.ini");
//#endif
}




// ****************************************************************************
//          ConfigWrite
// ****************************************************************************
int ConfigWrite(void)
{
//#ifdef WIN32
// char tmpCasName[PATH_MAX],tmpDskName[ PATH_MAX];

 configStream= (FILE*)fopen( ConfigPath,"w");
 if(configStream==NULL) { messagebox("Cannot write config file ","");return(0);}
    
 if(!WaitFlag) 	sw_nowait_mode(0);// NOWAIT???E?c?A?e?U?Anormal speed?E?s?$B!&(B?B2003/8/24   Thanks  Bernie

 fprintf(configStream,"[CONFIG]\n");
 fprintf(configStream,"P6Version=%d\n",newP6Version);
#ifdef SOUND
 fprintf(configStream,"UseSound=%d\n" ,newUseSound);
#else
 fprintf(configStream,"UseSound=%d\n" ,0);
#endif
 fprintf(configStream,"disk_num=%d\n" ,new_disk_num);

 fprintf(configStream,"CPUclock=%d\n" ,CPUclock);
 fprintf(configStream,"scale=%d\n"    ,scale);
 fprintf(configStream,"intLac=%d\n"   ,IntLac);
 fprintf(configStream,"CasPath=%s\n"  ,CasPath[0]);
 fprintf(configStream,"DskPath=%s\n"  ,DskPath[0]);
 fprintf(configStream,"CasName=%s\n"  ,CasName[0]);
 fprintf(configStream,"DskName=%s\n"  ,DskName[0]);
 fprintf(configStream,"scr4col=%d\n"  ,scr4col);
 fprintf(configStream,"drawWait=%d\n" ,drawwait );
 fprintf(configStream,"FastTape=%d\n" ,FastTape );
 fprintf(configStream,"UPeriod=%d\n"  ,UPeriod );
 fprintf(configStream,"extkanjirom=%d\n"  ,new_extkanjirom );
 fprintf(configStream,"extram=%d\n"  ,new_extram );
 fprintf(configStream,"srline=%d\n"  ,srline );
 fprintf(configStream,"ImgPath=%s\n"  ,ImgPath );
 fprintf(configStream,"MemPath=%s\n"  ,MemPath );
 fprintf(configStream,"Ext1Name=%s\n" ,Ext1Name );
 fprintf(configStream,"Ext2Name=%s\n" ,Ext2Name );

 fprintf(configStream,"CasPath(save)=%s\n"  ,CasPath[1]);
 fprintf(configStream,"CasName(save)=%s\n"  ,CasName[1]);
 fprintf(configStream,"UseSaveTapeMenu=%d\n"  ,UseSaveTapeMenu);
 fprintf(configStream,"UseStatusBar=%d\n"  ,UseStatusBar);

 fprintf(configStream,"UseDiskLamp=%d\n" ,UseDiskLamp);

 fclose( configStream);

	// NOWAIT???E?c?ANOWAIT ?o?O?E?s?$B!&(B?B2003/8/24   Thanks Bernie
 if(!WaitFlag) sw_nowait_mode(1);
//#endif
 return(1);
}



// ****************************************************************************
//          ConfigRead
// ****************************************************************************
int ConfigRead(void)
{
//#ifdef WIN32
 char *p;
 int  i,J,N,K;
 int  max;
 static char tmp[30][256];
 
 printf(" Reading Config file ...");
 configStream= (FILE*)fopen( ConfigPath,"r");
 if(configStream==NULL) { printf("FAILED\n"); return(0);}
 
 for(i=0; i<30; i++)
	{
	if(fgets(tmp[i],255,configStream)==NULL)
		break;
	 K = strlen( tmp[i])-1;
	 if( tmp[i][K]=='\n')
		 tmp[i][K] ='\0';	// chop
	}
 max= i;
 fclose( configStream);

 for(N=0; N< max ; N++)
	{
         for(J=0;  ConfigOptions[J] ; J++)
	   {
	    K= strlen( ConfigOptions[J]);
	    if(!strncmp(tmp[N] ,ConfigOptions[J],K))
			break;
	   }

	 switch( J)
	   {
	     case 0:break;
	     case 1:P6Version= atoi( &tmp[N][K] ); 
			    P6Version = (P6Version <=4)? P6Version: 0; 
			    newP6Version= P6Version;  break;
	     case 2:
#ifdef SOUND
		 		UseSound = atoi( &tmp[N][K] );
			    newUseSound = UseSound; 
#endif
				break;
	     case 3:disk_num = atoi( &tmp[N][K] ); 
		    	new_disk_num= disk_num; 
		    	break;
	     case 4:CPUclock = atoi( &tmp[N][K] ); 
	     		if( CPUclock==0) CPUclock=4; 
	     		break;
	     case 5:scale    = atoi( &tmp[N][K] ); 
	     	    if(scale<=0|| scale >=3) scale=2;
	     	    new_scale= scale; 
	     	    break;
	     case 6:IntLac   = atoi( &tmp[N][K] ); break;
	     case 7: my_strncpy(CasPath[0], &tmp[N][K],PATH_MAX); break;
	     case 8: my_strncpy(DskPath[0], &tmp[N][K],PATH_MAX); break;
	     case 9: my_strncpy(CasName[0], &tmp[N][K],PATH_MAX); break;
	     case 10:my_strncpy(DskName[0], &tmp[N][K],PATH_MAX); break;
	     case 11:scr4col = atoi( &tmp[N][K] ); break;
	     case 12:drawwait= atoi( &tmp[N][K] ); 
	     		 if(drawwait<0) drawwait=0;
	     		 if(drawwait>262) drawwait=262;
	     		 break;
	     case 13:FastTape= atoi( &tmp[N][K] ); break;
	     case 14:UPeriod = atoi( &tmp[N][K] ); 
	     		 if(UPeriod>2 ) UPeriod=2; 
	     		 break;
	     case 15:extkanjirom = atoi( &tmp[N][K] );
		 		 new_extkanjirom = extkanjirom;
	     		 break;
	     case 16:extram      = atoi( &tmp[N][K] );
		 		 new_extram  = extram;
	     		 break;
	     case 17:srline      = atoi( &tmp[N][K] );
		 		 if( srline >80) srline=80;
				 if( srline <0)  srline=80;
	     		 break;
	     case 18: my_strncpy(ImgPath, &tmp[N][K],PATH_MAX); break;
	     case 19: my_strncpy(MemPath, &tmp[N][K],PATH_MAX); break;
	     case 20: my_strncpy(Ext1Name, &tmp[N][K],PATH_MAX); break;
	     case 21: my_strncpy(Ext2Name, &tmp[N][K],PATH_MAX); break;
		 case 22: break;
	     case 23: my_strncpy(CasPath[1], &tmp[N][K],PATH_MAX); break;	/* tape (save)*/
	     case 24: my_strncpy(CasName[1], &tmp[N][K],PATH_MAX); break;
	     case 25: UseSaveTapeMenu    = atoi( &tmp[N][K] ); break;
	     case 26: UseStatusBar       = atoi( &tmp[N][K] ); break;
	     case 27: UseDiskLamp        = atoi( &tmp[N][K] ); break;
	   }
    }
 printf("Done.\n");
//#endif
 return(1);
}



// ****************************************************************************
//          COMMAND LINE OPTIONS
// ****************************************************************************
char *Options[]=
{ 
  "verbose","help","shm","noshm","trap","sound","nosound","patch","scale","notimer",
  "fasttape","extkanjirom","extram","srline","dum","dum","dum",
  "tape","disk","clock","60","62","64","66","68","console",
  "scr4col","drawWait","nointlac","rom1","rom2","extrom",
  "savetape",
  "thread",
  NULL
};


// ****************************************************************************
//          chkOption: check command line options
// ****************************************************************************
/** bug fixed: first option starts from argv[1] 2003/5/11 **/
int chkOption( int argc, char *argv[])
{
  int J;
  int N;




  for(N=1; N<argc; N++)
     {
      for(J=0; Options[J];J++)
	      if( !strcmp(argv[N]+1,Options[J]))
     		      break;
      switch(J)
        {
        case 0:  N++; /* verbose */
                 if(N<argc) Verbose=atoi(argv[N]);
                 else printf("%s: No verbose level supplied\n",argv[0]);
                 TrapBadOps=Verbose&0x10;
                 break;
        case 1:  /* help */
                 printf("%s by ISHIOKA Hiroshi    (C) 1998,1999\n",Title);
                 for(J=0;HelpText[J];J++) puts(HelpText[J]);
                 return(0);
#ifdef MITSHM
        case 2:  UseSHM=1;break; /* shm */
        case 3:  UseSHM=0;break; /* noshm */
#endif
#ifdef DEBUG
        case 4:  N++; /* trap */
                 if(N>=argc)
                   printf("%s: No trap address supplied\n",argv[0]);
                 else
                   if(!strcmp(argv[N],"now")) Trace=1;
                   else sscanf(argv[N],"%hX",&Trap);
                 break;
#endif
#ifdef SOUND
        case 5:  UseSound=1;break; /* sound */
        case 6:  UseSound=0;break; /* nosound */
#endif
        case 7:  N++; /* patch */
                 if(N<argc) PatchLevel=atoi(argv[N]);
                 else printf("%s: No patch level supplied\n",argv[0]);
				 if(PatchLevel<1) PatchLevel=0;
				 if(PatchLevel>1) PatchLevel=1;
                 break;
        case 8:  N++; /* scale */
	         	if(N<argc) scale=atoi(argv[N]);
				 if(scale<1) scale=1;
				 if(scale>2) scale=2;
                 break;
        case 9:  TimerSWFlag=0;	/* notimer */
        		 break;
        case 10: FastTape=1;
		break;
        case 11: extkanjirom=1;
		break;
        case 12: extram  =1;
		break;
        case 13: N++;	/* srline */
	        	 if(N<argc) srline= atoi(argv[N]);
	         	 if( srline>80) srline=80;
                 break;
//#ifndef UNIX
        case 17: N++;  /* tape */
                 if(N<argc)  my_strncpy(CasName[0], argv[N],PATH_MAX);
                 break;
        case 18: N++;  /* disk */
                 if(N<argc)  {
							 my_strncpy(DskName[0], argv[N],PATH_MAX);
							 disk_num=1;		// patch for Unix
							}
                 break;
#ifndef UNIX
        case 19: N++;	/* clock */
	        	 if(N<argc) CPUclock= atoi(argv[N]);
	         	 if( CPUclock==0) CPUclock=4;
                 break;
        case 20:
        case 21:
        case 22:
        case 23:
        case 24:  P6Version =J-20;		/* p6version */
        		 break;
        case 25: Console   =1;		/* console */
        		 break;
        case 26: scr4col   =1;		/* scr4col */
        		 break;
        case 27: N++;				/* drawWait */
	         	if(N<argc) drawwait= atoi(argv[N]);
	         	if( drawwait<0) drawwait=0;
	         	if( drawwait>262) drawwait=262;
	         	break;
        case 28: IntLac    =0;		/* nointlac */
				break;
        case 29: N++;  				/* Ext1Name */
                 if(N<argc)  my_strncpy(Ext1Name, argv[N],PATH_MAX);
                 break;
        case 30: N++;  				/* Ext2Name */
                 if(N<argc)  my_strncpy(Ext2Name, argv[N],PATH_MAX);
                 break;
        case 32: N++;  				/* savetape */
                 if(N<argc)  my_strncpy(CasName[1], argv[N],PATH_MAX);
                 break;
        case 33: N++;  				/* thread */
                 UseCPUThread =1;
                 break;
#endif
        default: printf("Wrong option '%s'\n",argv[N]);
        }
     }
 return(1);
}
