//	MC68K _code SUBQ



	//byte size , data regster direct
	case	0x0100:	case	0x0300:	case	0x0500:	case	0x0700:
	case	0x0900:	case	0x0b00:	case	0x0d00:	case	0x0f00:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.B #$%1X,D%d\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//byte size , mem addr
	case	0x0110:	case	0x0310:	case	0x0510:	case	0x0710:
	case	0x0910:	case	0x0b10:	case	0x0d10:	case	0x0f10:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.B #$%1X,(A%d)\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//byte size , mem addr ,postinc
	case	0x0118:	case	0x0318:	case	0x0518:	case	0x0718:
	case	0x0918:	case	0x0b18:	case	0x0d18:	case	0x0f18:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.B #$%1X,(A%d)+\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//byte size , mem addr ,pridec
	case	0x0120:	case	0x0320:	case	0x0520:	case	0x0720:
	case	0x0920:	case	0x0b20:	case	0x0d20:	case	0x0f20:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.B #$%1X,-(A%d)\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//byte size , mem addr with disp
	case	0x0128:	case	0x0328:	case	0x0528:	case	0x0728:
	case	0x0928:	case	0x0b28:	case	0x0d28:	case	0x0f28:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD1;	sprintf(buf,"SUBQ.B #$%1X,$%04X(A%d)\n",
												TC3,dnm2(1),RN1);	CO(buf);
		r[DPC]+=4;	return;

	//byte size , mem addr with index
	case	0x0130:	case	0x0330:	case	0x0530:	case	0x0730:
	case	0x0930:	case	0x0b30:	case	0x0d30:	case	0x0f30:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		RN2=(dnm2(1)>>12)&15;	//index
		DD1;	sprintf(buf,"SUBQ.B #$%1X,$%02X(A%d,X%d)\n",
											TC3,dnm1(1),RN1,RN2);	CO(buf);
		r[DPC]+=4;	return;

	//byte size , abs
	case	0x0138:	case	0x0338:	case	0x0538:	case	0x0738:
	case	0x0938:	case	0x0b38:	case	0x0d38:	case	0x0f38:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		switch(_code&DC_02){
			case	0x0000:		//word size
				DD1;	sprintf(buf,"SUBQ.B #$%1X,$%04X\n",
													TC3,dnm2(1));	CO(buf);
				r[DPC]+=4;	return;
			case	0x0001:		//long size
				DD2;	sprintf(buf,"SUBQ.B #$%1X,$%08X\n",
													TC3,dnm4(1));	CO(buf);
				r[DPC]+=6;	return;
			default:	DD0;	CO("???\n");	r[DPC]+=2;	return;
		}



	//word size , data regster direct
	case	0x0140:	case	0x0340:	case	0x0540:	case	0x0740:
	case	0x0940:	case	0x0b40:	case	0x0d40:	case	0x0f40:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.W #$%1X,D%d\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr
	case	0x0150:	case	0x0350:	case	0x0550:	case	0x0750:
	case	0x0950:	case	0x0b50:	case	0x0d50:	case	0x0f50:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.W #$%1X,(A%d)\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr ,postinc
	case	0x0158:	case	0x0358:	case	0x0558:	case	0x0758:
	case	0x0958:	case	0x0b58:	case	0x0d58:	case	0x0f58:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.W #$%1X,(A%d)+\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr ,pridec
	case	0x0160:	case	0x0360:	case	0x0560:	case	0x0760:
	case	0x0960:	case	0x0b60:	case	0x0d60:	case	0x0f60:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.W #$%1X,-(A%d)\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr with disp
	case	0x0168:	case	0x0368:	case	0x0568:	case	0x0768:
	case	0x0968:	case	0x0b68:	case	0x0d68:	case	0x0f68:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD1;	sprintf(buf,"SUBQ.W #$%1X,$%04X(A%d)\n",
												TC3,dnm2(1),RN1);	CO(buf);
		r[DPC]+=4;	return;

	//byte size , mem addr with index
	case	0x0170:	case	0x0370:	case	0x0570:	case	0x0770:
	case	0x0970:	case	0x0b70:	case	0x0d70:	case	0x0f70:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		RN2=(dnm2(1)>>12)&15;	//index
		DD1;	sprintf(buf,"SUBQ.W #$%1X,$%02X(A%d,X%d)\n",
											TC3,dnm1(1),RN1,RN2);	CO(buf);
		r[DPC]+=4;	return;

	//abs
	case	0x0178:	case	0x0378:	case	0x0578:	case	0x0778:
	case	0x0978:	case	0x0b78:	case	0x0d78:	case	0x0f78:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		switch(_code&DC_02){
			case	0x0000:		//word size
				DD1;	sprintf(buf,"SUBQ.W #$%1X,$%04X\n",
													TC3,dnm2(1));	CO(buf);
				r[DPC]+=4;	return;
			case	0x0001:		//long size
				DD2;	sprintf(buf,"SUBQ.W #$%1X,$%08X\n",
													TC3,dnm4(1));	CO(buf);
				r[DPC]+=6;	return;
			default:	DD0;	CO("???\n");	r[DPC]+=2;	return;
		}



	//long size , data regster direct
	case	0x0180:	case	0x0380:	case	0x0580:	case	0x0780:
	case	0x0980:	case	0x0b80:	case	0x0d80:	case	0x0f80:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.L #$%1X,D%d\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr
	case	0x0190:	case	0x0390:	case	0x0590:	case	0x0790:
	case	0x0990:	case	0x0b90:	case	0x0d90:	case	0x0f90:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.L #$%1X,(A%d)\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr ,postinc
	case	0x0198:	case	0x0398:	case	0x0598:	case	0x0798:
	case	0x0998:	case	0x0b98:	case	0x0d98:	case	0x0f98:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.L #$%1X,(A%d)+\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr ,pridec
	case	0x01a0:	case	0x03a0:	case	0x05a0:	case	0x07a0:
	case	0x09a0:	case	0x0ba0:	case	0x0da0:	case	0x0fa0:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD0;	sprintf(buf,"SUBQ.L #$%1X,-(A%d)\n",TC3,RN1);	CO(buf);
		r[DPC]+=2;	return;

	//mem addr with disp
	case	0x01a8:	case	0x03a8:	case	0x05a8:	case	0x07a8:
	case	0x09a8:	case	0x0ba8:	case	0x0da8:	case	0x0fa8:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		DD1;	sprintf(buf,"SUBQ.L #$%1X,$%04X(A%d)\n",
												TC3,dnm2(1),RN1);	CO(buf);
		r[DPC]+=4;	return;

	//byte size , mem addr with index
	case	0x01b0:	case	0x03b0:	case	0x05b0:	case	0x07b0:
	case	0x09b0:	case	0x0bb0:	case	0x0db0:	case	0x0fb0:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		RN2=(dnm2(1)>>12)&15;	//index
		DD1;	sprintf(buf,"SUBQ.L #$%1X,$%02X(A%d,X%d)\n",
											TC3,dnm1(1),RN1,RN2);	CO(buf);
		r[DPC]+=4;	return;

	//abs
	case	0x01b8:	case	0x03b8:	case	0x05b8:	case	0x07b8:
	case	0x09b8:	case	0x0bb8:	case	0x0db8:	case	0x0fb8:
		TC3=(_code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		switch(_code&DC_02){
			case	0x0000:		//word size
				DD1;	sprintf(buf,"SUBQ.L #$%1X,$%04X\n",
													TC3,dnm2(1));	CO(buf);
				r[DPC]+=4;	return;
			case	0x0001:		//long size
				DD2;	sprintf(buf,"SUBQ.L #$%1X,$%08X\n",
													TC3,dnm4(1));	CO(buf);
				r[DPC]+=6;	return;
			default:	DD0;	CO("???\n");	r[DPC]+=2;	return;
		}
