#include	"mc68k.h"

#ifdef	_DEBUG
#include	<stdio.h>
#include	"../../window/console/console.h"

extern		CONSOLE		con;
#endif



void	MC68K::intprt(void)
{
	unsigned char	RN1,RN2,RN3,RN4;	//Register Number
	unsigned long	TR1;				//Temp Register
	unsigned char	TC1,TC2,TC3;		//Temp Char
	unsigned short	TS1,TS2,TS3;		//Temp Short
	unsigned long	TL1,TL2,TL3;		//Temp Long
	unsigned short	_code=r2(r[PC]);
#ifdef	_DEBUG
	char			buf[0x1000];



	if(r[VSR]&VSR_DISP_CODE){	sprintf(buf,"%08X ",r[PC]);	CO(buf);	}
#endif
	count.QuadPart++;

	switch(_code & 0xf000){
		case	0x0000:
#include	"intprt/_0xxx.cpp"
		case	0x1000:
#include	"intprt/moveb.cpp"
		case	0x2000:
#include	"intprt/movel.cpp"
		case	0x3000:
#include	"intprt/movew.cpp"
		case	0x4000:
#include	"intprt/_4xxx.cpp"
		case	0x5000:
#include	"intprt/_5xxx.cpp"
		case	0x6000:
#include	"intprt/_6xxx.cpp"
		case	0x7000:
#include	"intprt/moveq.cpp"
		case	0x8000:
#include	"intprt/_8xxx.cpp"
		case	0x9000:
#include	"intprt/_9xxx.cpp"
		case	0xb000:
#include	"intprt/_bxxx.cpp"
		case	0xc000:
#include	"intprt/_cxxx.cpp"
		case	0xd000:
#include	"intprt/_dxxx.cpp"
		case	0xe000:
#include	"intprt/_exxx.cpp"
		default:
			gic();	return;
	}
}
