//	MC68K	0x4xxx Opecode MiSC



case	0xe70:
	switch(RN1){
		case	0:
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				BD0;	sprintf(buf,"RESET <User State! TRAP!>\n");	CO(buf);
#endif
				goto	_TRAP;	}
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"RESET\n");	CO(buf);	}
#endif
			r[PC]+=2;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"NOP\n");	CO(buf);	}
#endif
			r[PC]+=2;	return;



		case	2:
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				BD1;	sprintf(buf,"STOP #$%04X <User State! TRAP!>\n",
					num2(1));	CO(buf);
#endif
		goto	_TRAP;			}
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD1;	sprintf(buf,"STOP #$%04X\n",num2(1));	CO(buf);	}
#endif
			r[SR]=num2(1);
			r[PC]+=4;	return;



		case	3:
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				BD0;	sprintf(buf,"RTE <User State! TRAP!>\n");	CO(buf);
#endif
				goto	_TRAP;	}
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"RTE\n");	CO(buf);	}
#endif
			r[TSR]=r[SR];

			r[SR]=r2(r[A7]);
			r[PC]=r4(r[A7]+2);	r[A7]+=6;

			if((r[TSR]^r[SR])&0x2000)							//Change state
				if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
					else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
			return;



		case	5:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"RTS\n");	CO(buf);	}
#endif
			r[PC]=r4(r[A7]);
			r[A7]+=4;
			return;



		case	6:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"TRAPV\n");	CO(buf);	}
#endif
			if((r[SR]&CCR_VON)==0)	r[PC]+=2;
				else				goto	_TRAP;
			return;




		case	7:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"RTR\n");	CO(buf);	}
#endif
			r[SR]=(r[SR]&0xff00)|(unsigned char)r2(r[A7]);
			r[PC]=r4(r[A7]+2);
			r[A7]+=6;
			return;



		default:
			gic();	return;
}
