//	MC68K code ADDI



case	0x0600:		//byte size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.B #$%02X,D%d\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN1];
	TC2=num1(1);
	TC3=TC1+TC2;

	sr_add_c(TC1,TC2);
	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|TC3;
	r[PC]+=4;	return;



case	0x0610:		//byte size , mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.B #$%02X,(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]);
	TC2=num1(1);
	TC3=TC1+TC2;

	sr_add_c(TC1,TC2);
	w1(r[A0+RN1],TC3);
	r[PC]+=4;	return;



case	0x0618:		//byte size , mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.B #$%02X,(A%d)+\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]);
	TC2=num1(1);
	TC3=TC1+TC2;

	sr_add_c(TC1,TC2);
	w1(r[A0+RN1],TC3);
	r[A0+RN1]++;
	r[PC]+=4;	return;



case	0x0620:		//byte size , mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.B #$%02X,-(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TC1=r1(r[A0+RN1]);
	TC2=num1(1);
	TC3=TC1+TC2;

	sr_add_c(TC1,TC2);
	w1(r[A0+RN1],TC3);
	r[PC]+=4;	return;



case	0x0628:		//byte size , mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.B #$%02X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]+(short)num2(2));
	TC2=num1(1);
	TC3=TC1+TC2;

	sr_add_c(TC1,TC2);
	w1(r[A0+RN1]+(short)num2(2),TC3);
	r[PC]+=6;	return;



case	0x0630:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.B #$%02X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp
	TC1=r1(TR1);
	TC2=num1(1);
	TC3=TC1+TC2;

	sr_add_c(TC1,TC2);
	w1(TR1,TC3);
	r[PC]+=6;	return;



case	0x0638:				//byte size , abs
	switch(_code&DC_02){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.B #$%02X,$%04X\n",
	num1(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			TC1=r1(TR1);
			TC2=num1(1);
			TC3=TC1+TC2;

			sr_add_c(TC1,TC2);
			w1(TR1,TC3);
			r[PC]+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"ADDI.B #$%02X,$%08X\n",
	num1(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			TC1=r1(TR1);
			TC2=num1(1);
			TC3=TC1+TC2;

			sr_add_c(TC1,TC2);
			w1(TR1,TC3);
			r[PC]+=8;	return;



		default:
			gic();	return;
	}





case	0x0640:		//word size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.W #$%04X,D%d\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN1];
	TS2=num2(1);
	TS3=TS1+TS2;

	sr_add_s(TS1,TS2);
	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|TS3;
	r[PC]+=4;	return;



case	0x0650:		//mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.W #$%04X,(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=num2(1);
	TS3=TS1+TS2;

	sr_add_s(TS1,TS2);
	w2(r[A0+RN1],TS3);
	r[PC]+=4;	return;



case	0x0658:		//mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.W #$%04X,(A%d)+\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=num2(1);
	TS3=TS1+TS2;

	sr_add_s(TS1,TS2);
	w2(r[A0+RN1],TS3);
	r[A0+RN1]+=2;
	r[PC]+=4;	return;



case	0x0660:		//mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ADDI.W #$%04X,-(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=r2(r[A0+RN1]);
	TS2=num2(1);
	TS3=TS1+TS2;

	sr_add_s(TS1,TS2);
	w2(r[A0+RN1],TS3);
	r[PC]+=4;	return;



case	0x0668:		//mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.W #$%04X,$%04X(A%d)\n",
	num2(1),num2(2),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]+(short)num2(2));
	TS2=num2(1);
	TS3=TS1+TS2;

	sr_add_s(TS1,TS2);
	w2(r[A0+RN1]+(short)num2(2),TS3);
	r[PC]+=6;	return;



case	0x0670:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.W #$%04X,$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp

	TS1=r2(TR1);
	TS2=num2(1);
	TS3=TS1+TS2;

	sr_add_s(TS1,TS2);
	w2(TR1,TS3);
	r[PC]+=6;	return;



case	0x0678:				//abs
	switch(_code&DC_02){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.W #$%04X,$%04X\n",
	num2(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			TS1=r2(TR1);
			TS2=num2(1);
			TS3=TS1+TS2;

			sr_add_s(TS1,TS2);
			w2(TR1,TS3);
			r[PC]+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"ADDI.W #$%04X,$%08X\n",
	num2(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			TS1=r2(TR1);
			TS2=num2(1);
			TS3=TS1+TS2;

			sr_add_s(TS1,TS2);
			w2(TR1,TS3);
			r[PC]+=8;	return;



		default:
			gic();	return;
	}





case	0x0680:		//long size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.L #$%08X,D%d\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	TL2=num4(1);
	TL3=TL1+TL2;

	sr_add_l(TL1,TL2);
	r[D0+RN1]=TL3;
	r[PC]+=6;	return;



case	0x0690:		//mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.L #$%08X,(A%d)\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]);
	TL2=num4(1);
	TL3=TL1+TL2;

	sr_add_l(TL1,TL2);
	w4(r[A0+RN1],TL3);
	r[PC]+=6;	return;



case	0x0698:		//mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.L #$%08X,(A%d)+\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]);
	TL2=num4(1);
	TL3=TL1+TL2;

	sr_add_l(TL1,TL2);
	w4(r[A0+RN1],TL3);
	r[A0+RN1]+=4;
	r[PC]+=6;	return;



case	0x06a0:		//mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ADDI.L #$%08X,-(A%d)\n",
	num4(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=4;
	TL1=r4(r[A0+RN1]);
	TL2=num4(1);
	TL3=TL1+TL2;

	sr_add_l(TL1,TL2);
	w4(r[A0+RN1],TL3);
	r[PC]+=6;	return;



case	0x06a8:		//mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"ADDI.L #$%08X,$%04X(A%d)\n",
	num4(1),num2(3),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]+(short)num2(3));
	TL2=num4(1);
	TL3=TL1+TL2;

	sr_add_l(TL1,TL2);
	w4(r[A0+RN1],TL3);
	r[PC]+=8;	return;



case	0x06b0:		//byte size , mem addr with index
	RN3=(num2(3)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"ADDI.L #$%08X,$%02X(A%d,X%d)\n",
	num4(1),num1(3),RN1,RN3);	CO(buf);	}
#endif
	if((num2(3)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(3)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(3)+       r[D0+RN3];	//32bitgp
	TL1=r4(TR1);
	TL2=num4(1);
	TL3=TL1+TL2;

	sr_add_l(TL1,TL2);
	w4(TR1,TL3);
	r[PC]+=8;	return;



case	0x06b8:				//abs
	switch(_code&DC_02){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"ADDI.L #$%08X,$%04X\n",
	num4(1),num2(3));	CO(buf);	}
#endif
			TR1=(short)num2(3);
			TL1=r4(TR1);
			TL2=num4(1);
			TL3=TL1+TL2;

			sr_add_l(TL1,TL2);
			w4(TR1,TL3);
			r[PC]+=8;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD4;	sprintf(buf,"ADDI.L #$%08X,$%08X\n",
	num4(1),num4(3));	CO(buf);	}
#endif
			TR1=num4(3);
			TL1=r4(TR1);
			TL2=num4(1);
			TL3=TL1+TL2;

			sr_add_l(TL1,TL2);
			w4(TR1,TL3);
			r[PC]+=10;	return;


		default:
			gic();	return;
	}
