//	MC68K code BSET



case	0x01c0:
case	0x03c0:
case	0x05c0:
case	0x07c0:
case	0x09c0:
case	0x0bc0:
case	0x0dc0:
case	0x0fc0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BSET D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=1<<(r[D0+RN2]&0x1F);
	if((r[D0+RN1]&TL1)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	r[D0+RN1]|=TL1;
	r[PC]+=2;	return;



case	0x01d0:
case	0x03d0:
case	0x05d0:
case	0x07d0:
case	0x09d0:
case	0x0bd0:
case	0x0dd0:
case	0x0fd0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BSET D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=2;	return;



case	0x01d8:
case	0x03d8:
case	0x05d8:
case	0x07d8:
case	0x09d8:
case	0x0bd8:
case	0x0dd8:
case	0x0fd8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BSET D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[A0+RN1]++;
	r[PC]+=2;	return;



case	0x01e0:
case	0x03e0:
case	0x05e0:
case	0x07e0:
case	0x09e0:
case	0x0be0:
case	0x0de0:
case	0x0fe0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BSET D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TR1=r[A0+RN1];
	TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=2;	return;



case	0x01e8:
case	0x03e8:
case	0x05e8:
case	0x07e8:
case	0x09e8:
case	0x0be8:
case	0x0de8:
case	0x0fe8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=4;	return;



case	0x01f0:
case	0x03f0:
case	0x05f0:
case	0x07f0:
case	0x09f0:
case	0x0bf0:
case	0x0df0:
case	0x0ff0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];	//32bitgp
	TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=4;	return;



case	0x01f8:
case	0x03f8:
case	0x05f8:
case	0x07f8:
case	0x09f8:
case	0x0bf8:
case	0x0df8:
case	0x0ff8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TR1=(short)num2(1);
			TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
			if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
				else			r[SR]&=CCR_ZOFF;
			w1(TR1,TC1|TC2);
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BSET D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TR1=num4(1);
			TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
			if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
				else			r[SR]&=CCR_ZOFF;
			w1(TR1,TC1|TC2);
			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET D%d,$%04X(PC)\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TR1=r[PC]+(short)num2(1)+2;
			TC2=1<<(r[D0+RN2]&0x7);	TC1=r1(TR1);
			if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
				else			r[SR]&=CCR_ZOFF;
			w1(TR1,TC1|TC2);
			r[PC]+=4;	return;



		default:
			gic();	return;
	}





case	0x08c0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET #$%1X,D%d\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TL1=1<<(num1(1)&0x1F);
	if((r[D0+RN1]&TL1)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	r[D0+RN1]|=TL1;
	r[PC]+=4;	return;



case	0x08d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET #$%1X,(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=4;	return;



case	0x08d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET #$%1X,(A%d)+\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[A0+RN1]++;
	r[PC]+=4;	return;



case	0x08e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BSET #$%1X,-(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TR1=r[A0+RN1];
	TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=4;	return;



case	0x08e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BSET #$%1X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(2);
	TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=6;	return;



case	0x08f0:
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BSET #$%1X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp
	TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
	if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
		else			r[SR]&=CCR_ZOFF;
	w1(TR1,TC1|TC2);
	r[PC]+=6;	return;



case	0x08f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BSET #$%1X,$%04X\n",
	num1(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
			if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
				else			r[SR]&=CCR_ZOFF;
			w1(TR1,TC1|TC2);
			r[PC]+=6;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"BSET #$%1X,$%08X\n",
	num1(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
			if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
				else			r[SR]&=CCR_ZOFF;
			w1(TR1,TC1|TC2);
			r[PC]+=8;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BSET #$%1X,$%04X(PC)\n",
	num1(1),num2(2));	CO(buf);	}
#endif
			TR1=r[PC]+(short)num2(2)+2;
			TC2=1<<(num1(1)&0x7);	TC1=r1(TR1);
			if((TC1&TC2)==0)	r[SR]|=CCR_ZON;
				else			r[SR]&=CCR_ZOFF;
			w1(TR1,TC1|TC2);
			r[PC]+=6;	return;



		default:
			gic();	return;
	}
