//	MC68K code BTST



case	0x0100:
case	0x0300:
case	0x0500:
case	0x0700:
case	0x0900:
case	0x0b00:
case	0x0d00:
case	0x0f00:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BTST D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	if((r[D0+RN1]&(1<<(r[D0+RN2]&0x1F)))==0)	r[SR]|=CCR_ZON;
		else							r[SR]&=CCR_ZOFF;
	r[PC]+=2;	return;



case	0x0110:
case	0x0310:
case	0x0510:
case	0x0710:
case	0x0910:
case	0x0b10:
case	0x0d10:
case	0x0f10:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BTST D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=2;	return;



case	0x0118:
case	0x0318:
case	0x0518:
case	0x0718:
case	0x0918:
case	0x0b18:
case	0x0d18:
case	0x0f18:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BTST D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[A0+RN1]++;
	r[PC]+=2;	return;



case	0x0120:
case	0x0320:
case	0x0520:
case	0x0720:
case	0x0920:
case	0x0b20:
case	0x0d20:
case	0x0f20:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"BTST D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TR1=r[A0+RN1];
	if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=2;	return;



case	0x0128:
case	0x0328:
case	0x0528:
case	0x0728:
case	0x0928:
case	0x0b28:
case	0x0d28:
case	0x0f28:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=4;	return;



case	0x0130:
case	0x0330:
case	0x0530:
case	0x0730:
case	0x0930:
case	0x0b30:
case	0x0d30:
case	0x0f30:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];	//32bitgp
	if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=4;	return;



case	0x0138:
case	0x0338:
case	0x0538:
case	0x0738:
case	0x0938:
case	0x0b38:
case	0x0d38:
case	0x0f38:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TR1=(short)num2(1);
			if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BTST D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TR1=num4(1);
			if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST D%d,$%04X(PC)\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TR1=r[PC]+(short)num2(1)+2;
			if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST D%d,$%02X(PC,X%d)\n",
	RN2,num1(1),RN3);	CO(buf);	}
#endif
			if((num2(1)&0x0800)==0)
						TR1=r[PC]+(char)num1(1)+(short)r[D0+RN3]+2;	//16bit
				else	TR1=r[PC]+(char)num1(1)+       r[D0+RN3]+2;	//32bit
			if((r1(TR1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST D%d,#$%02X\n",
	RN2,num1(1));	CO(buf);	}
#endif
			if((num1(1)&(1<<(r[D0+RN2]&0x7)))==0)	r[SR]|=CCR_ZON;
				else							r[SR]&=CCR_ZOFF;
			r[PC]+=4;	return;



		default:
			gic();	return;
	}





case	0x0800:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST #$%1X,D%d\n",
	num1(1),RN1);	CO(buf);	}
#endif
	if((r[D0+RN1]&(1<<(num1(1)&0x1F)))==0)	r[SR]|=CCR_ZON;
		else							r[SR]&=CCR_ZOFF;
	r[PC]+=4;	return;



case	0x0810:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST #$%1X,(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=4;	return;



case	0x0818:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST #$%1X,(A%d)+\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[A0+RN1]++;
	r[PC]+=4;	return;



case	0x0820:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"BTST #$%1X,-(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TR1=r[A0+RN1];
	if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=4;	return;



case	0x0828:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BTST #$%1X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(2);
	if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=6;	return;



case	0x0830:
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BTST #$%1X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp
	if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
		else									r[SR]&=CCR_ZOFF;
	r[PC]+=6;	return;



case	0x0838:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BTST #$%1X,$%04X\n",
	num1(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=6;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"BTST #$%1X,$%08X\n",
	num1(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=8;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BTST #$%1X,$%04X(PC)\n",
	num1(1),num2(2));	CO(buf);	}
#endif
			TR1=r[PC]+(short)num2(2)+2;
			if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=6;	return;



		case	3:
			RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"BTST #$%1X,$%02X(PC,X%d)\n",
	num1(1),num1(2),RN3);	CO(buf);	}
#endif
			if((num2(2)&0x0800)==0)
						TR1=r[PC]+(char)num1(2)+(short)r[D0+RN3]+2;	//16bit
				else	TR1=r[PC]+(char)num1(2)+       r[D0+RN3]+2;	//32bit
			if((r1(TR1)&(1<<(num1(1)&0x7)))==0)	r[SR]|=CCR_ZON;
				else									r[SR]&=CCR_ZOFF;
			r[PC]+=6;	return;



		default:
			gic();	return;
	}
