//	MC68K code CLR



case	0x0200:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.B D%d\n",RN1);	CO(buf);	}
#endif
	r[D0+RN1]&=0xffffff00;
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0210:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.B (A%d)\n",RN1);	CO(buf);	}
#endif
	w1(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0218:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.B (A%d)+\n",RN1);	CO(buf);	}
#endif
	w1(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[A0+RN1]++;
	r[PC]+=2;	return;



case	0x0220:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.B -(A%d)\n",RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	w1(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0228:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.B $%04X(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	w1(r[A0+RN1]+(short)num2(1),0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=4;	return;



case	0x0230:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.B $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			w1(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3],0);	//16bitg
	else	w1(r[A0+RN1]+(char)num1(1)+       r[D0+RN3],0);	//32bitg
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=4;	return;



case	0x0238:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.B $%04X\n",
	num2(1));	CO(buf);	}
#endif
			w1((short)num2(1),0);	//16bitg
			r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			r[SR]|=CCR_ZON;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CLR.B $%08X\n",
	num4(1));	CO(buf);	}
#endif
			w1(num4(1),0);	
			r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			r[SR]|=CCR_ZON;
			r[PC]+=6;	return;



		default:
			gic();	return;
	}





case	0x0240:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.W D%d\n",RN1);	CO(buf);	}
#endif
	r[D0+RN1]&=0xffff0000;
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0250:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.W (A%d)\n",RN1);	CO(buf);	}
#endif
	w2(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0258:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.W (A%d)+\n",RN1);	CO(buf);	}
#endif
	w2(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x0260:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.W -(A%d)\n",RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	w2(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0268:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.W $%04X(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	w2(r[A0+RN1]+(short)num2(1),0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=4;	return;



case	0x0270:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			w2(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3],0);	//16bitg
	else	w2(r[A0+RN1]+(char)num1(1)+       r[D0+RN3],0);	//32bitg
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=4;	return;



case	0x0278:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.W $%04X\n",
	num2(1));	CO(buf);	}
#endif
			w2((short)num2(1),0);	//16bitg
			r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			r[SR]|=CCR_ZON;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CLR.W $%08X\n",
	num4(1));	CO(buf);	}
#endif
			w2(num4(1),0);	
			r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			r[SR]|=CCR_ZON;
			r[PC]+=6;	return;



		default:
			gic();	return;
	}





case	0x0280:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.L D%d\n",RN1);	CO(buf);	}
#endif
	r[D0+RN1]=0;
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0290:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.L (A%d)\n",RN1);	CO(buf);	}
#endif
	w4(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x0298:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.L (A%d)+\n",RN1);	CO(buf);	}
#endif
	w4(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[A0+RN1]+=4;
	r[PC]+=2;	return;



case	0x02a0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CLR.L -(A%d)\n",RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	w4(r[A0+RN1],0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=2;	return;



case	0x02a8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.L $%04X(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	w4(r[A0+RN1]+(short)num2(1),0);
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=4;	return;



case	0x02b0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.L $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			w4(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3],0);	//16bitg
	else	w4(r[A0+RN1]+(char)num1(1)+       r[D0+RN3],0);	//32bitg
	r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
	r[SR]|=CCR_ZON;
	r[PC]+=4;	return;



case	0x02b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CLR.L $%04X\n",
	num2(1));	CO(buf);	}
#endif
			w4((short)num2(1),0);	//16bitg
			r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			r[SR]|=CCR_ZON;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CLR.L $%08X\n",
	num4(1));	CO(buf);	}
#endif
			w4(num4(1),0);	
			r[SR]&=CCR_NOFF&CCR_VOFF&CCR_COFF;
			r[SR]|=CCR_ZON;
			r[PC]+=6;	return;



		default:
			gic();	return;
	}





