//	MC68K code EOR






case	0x0100:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.B D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2]^(unsigned char)r[D0+RN1];

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|TC1;
	r[PC]+=2;	return;



case	0x0110:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.B D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2]^r1(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

	w1(r[A0+RN1],TC1);
	r[PC]+=2;	return;



case	0x0118:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.B D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2]^r1(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

	w1(r[A0+RN1],TC1);
	r[A0+RN1]++;
	r[PC]+=2;	return;



case	0x0120:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.B D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TC1=(unsigned char)r[D0+RN2]^r1(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

	w1(r[A0+RN1],TC1);
	r[PC]+=2;	return;



case	0x0128:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.B D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TC1=(unsigned char)r[D0+RN2]^r1(TR1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

	w1(TR1,TC1);
	r[PC]+=4;	return;



case	0x0130:
	RN3=(num2(1)>>12)&15;
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.B D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];	//16bitg
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];	//32bitgp
	TC1=(unsigned char)r[D0+RN2]^r1(TR1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

	w1(TR1,TC1);
	r[PC]+=4;	return;



case	0x0138:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.B D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TC1=(unsigned char)r[D0+RN2]^r1((short)num2(1));

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			r[SR]|=CCR_ZON;
			if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

			w1((short)num2(1),TC1);
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EOR.B D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TC1=(unsigned char)r[D0+RN2]^r1(num4(1));

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			r[SR]|=CCR_ZON;
			if((TC1&0x80)!=0)	r[SR]|=CCR_NON;

			w1(num4(1),TC1);
			r[PC]+=6;	return;



		default:
			gic();	return;
	}





case	0x0140:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.W D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2]^(unsigned short)r[D0+RN1];

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|TS1;
	r[PC]+=2;	return;



case	0x0150:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.W D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2]^r2(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(r[A0+RN1],TS1);
	r[PC]+=2;	return;



case	0x0158:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.W D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2]^r2(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(r[A0+RN1],TS1);
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x0160:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.W D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=(unsigned short)r[D0+RN2]^r2(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(r[A0+RN1],TS1);
	r[PC]+=2;	return;



case	0x0168:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.W D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TS1=(unsigned short)r[D0+RN2]^r2(TR1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(TR1,TS1);
	r[PC]+=4;	return;



case	0x0170:
	RN3=(num2(1)>>12)&15;
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.W D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];	//16bitg
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];	//32bitgp
	TS1=(unsigned short)r[D0+RN2]^r2(TR1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(TR1,TS1);
	r[PC]+=4;	return;



case	0x0178:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.W D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TS1=(unsigned short)r[D0+RN2]^r2((short)num2(1));

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			r[SR]|=CCR_ZON;
			if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

			w2((short)num2(1),TS1);
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EOR.W D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TS1=(unsigned short)r[D0+RN2]^r2(num4(1));

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			r[SR]|=CCR_ZON;
			if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;

			w2(num4(1),TS1);
			r[PC]+=6;	return;



		default:
			gic();	return;
	}





case	0x0180:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.L D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN2]^r[D0+RN1];

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN1]=TL1;
	r[PC]+=2;	return;



case	0x0190:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.L D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN2]^r4(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(r[A0+RN1],TL1);
	r[PC]+=2;	return;



case	0x0198:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.L D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN2]^r4(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(r[A0+RN1],TL1);
	r[A0+RN1]+=4;
	r[PC]+=2;	return;



case	0x01a0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"EOR.L D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=4;
	TL1=r[D0+RN2]^r4(r[A0+RN1]);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(r[A0+RN1],TL1);
	r[PC]+=2;	return;



case	0x01a8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.L D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TL1=r[D0+RN2]^r4(TR1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(TR1,TL1);
	r[PC]+=4;	return;



case	0x01b0:
	RN3=(num2(1)>>12)&15;
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.L D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];	//16bitg
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];	//32bitgp
	TL1=r[D0+RN2]^r4(TR1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(TR1,TL1);
	r[PC]+=4;	return;



case	0x01b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EOR.L D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TL1=r[D0+RN2]^r4((short)num2(1));

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				r[SR]|=CCR_ZON;
			if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

			w4((short)num2(1),TL1);
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EOR.L D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TL1=r[D0+RN2]^r4(num4(1));

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				r[SR]|=CCR_ZON;
			if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;

			w4(num4(1),TL1);
			r[PC]+=6;	return;



		default:
			gic();	return;
	}





