//	MC68K code EORI



case	0x0a00:		//byte size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.B #$%02X,D%d\n",
	num1(1),RN1);	CO(buf);	}
#endif
	r[D0+RN1]^=num1(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if((r[D0+RN1]&0xff)==0)	r[SR]|=CCR_ZON;
	if((r[D0+RN1]&0x80)!=0)	r[SR]|=CCR_NON;
	r[PC]+=4;	return;



	case	0x0a10:		//byte size , mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.B #$%02X,(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1])^num1(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;
	w1(r[A0+RN1],TC1);
	r[PC]+=4;	return;



case	0x0a18:		//byte size , mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.B #$%02X,(A%d)+\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1])^num1(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;
	w1(r[A0+RN1],TC1);
	r[A0+RN1]++;
	r[PC]+=4;	return;



case	0x0a20:		//byte size , mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.B #$%02X,-(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TC1=r1(r[A0+RN1])^num1(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;
	w1(r[A0+RN1],TC1);
	r[PC]+=4;	return;



	case	0x0a28:		//byte size , mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.B #$%02X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]+(short)num2(2))^num1(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;
	w1(r[A0+RN1]+(short)num2(2),TC1);
	r[PC]+=6;	return;



case	0x0a30:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.B #$%02X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp
	TC1=r1(TR1)^num1(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			r[SR]|=CCR_ZON;
	if((TC1&0x80)!=0)	r[SR]|=CCR_NON;
	w1(TR1,TC1);
	r[PC]+=6;	return;



case	0x0a38:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.B #$%02X,$%04X\n",
	num1(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			TC1=r1(TR1)^num1(1);
			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			r[SR]|=CCR_ZON;
			if((TC1&0x80)!=0)	r[SR]|=CCR_NON;
			w1(TR1,TC1);
			r[PC]+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"EORI.B #$%02X,$%08X\n",
	num1(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			TC1=r1(TR1)^num1(1);
			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			r[SR]|=CCR_ZON;
			if((TC1&0x80)!=0)	r[SR]|=CCR_NON;
			w1(TR1,TC1);
			r[PC]+=8;	return;



		case	4:		//EORI to CCR
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI #$%02X,CCR\n",
	num1(1));	CO(buf);	}
#endif
			r[SR]^=num1(1);
			r[PC]+=4;	return;



		default:
			gic();	return;
	}





case	0x0a40:		//word size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.W #$%04X,D%d\n",
	num2(1),RN1);	CO(buf);	}
#endif
	r[D0+RN1]^=num2(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if((r[D0+RN1]&0xffff)==0)	r[SR]|=CCR_ZON;
	if((r[D0+RN1]&0x8000)!=0)	r[SR]|=CCR_NON;
	r[PC]+=4;	return;



case	0x0a50:		//mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.W #$%04X,(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1])^num2(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(r[A0+RN1],TS1);
	r[PC]+=4;	return;



case	0x0a58:		//mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.W #$%04X,(A%d)+\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1])^num2(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(r[A0+RN1],TS1);
	r[A0+RN1]+=2;
	r[PC]+=4;	return;



case	0x0a60:		//mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI.W #$%04X,-(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=r2(r[A0+RN1])^num2(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(r[A0+RN1],TS1);
	r[PC]+=4;	return;



case	0x0a68:		//mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.W #$%04X,$%04X(A%d)\n",
	num2(1),num2(2),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]+(short)num2(2))^num2(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(r[A0+RN1]+(short)num2(2),TS1);
	r[PC]+=6;	return;



case	0x0a70:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.W #$%04X,$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp
	TS1=r2(TR1)^num2(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			r[SR]|=CCR_ZON;
	if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS1);
	r[PC]+=6;	return;



case	0x0a78:				//abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.W #$%04X,$%04X\n",
	num2(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			TS1=r2(TR1)^num2(1);
			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			r[SR]|=CCR_ZON;
			if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;
			w2(TR1,TS1);
			r[PC]+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"EORI.W #$%04X,$%08X\n",
	num2(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			TS1=r2(TR1)^num2(1);
			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			r[SR]|=CCR_ZON;
			if((TS1&0x8000)!=0)	r[SR]|=CCR_NON;
			w2(TR1,TS1);
			r[PC]+=8;	return;



		case	4:		//EORI to r[SR]
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				BD1;
				sprintf(buf,"EORI #$%04X,r[SR] <User State! TRAP!>\n",num2(1));
				CO(buf);
#endif
				goto	_TRAP;								}
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"EORI #$%04X,r[SR]\n",
	num2(1));	CO(buf);	}
#endif
			r[TSR]=r[SR];	r[SR]^=num2(1);
			if((r[TSR]^r[SR])&0x2000)							//Change state
				if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//U2S
					else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//S2U
			r[PC]+=4;	return;



		default:
			gic();	return;
	}





case	0x0a80:		//long size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.L #$%08X,D%d\n",
	num4(1),RN1);	CO(buf);	}
#endif
	r[D0+RN1]^=num4(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(r[D0+RN1]==0)				r[SR]|=CCR_ZON;
	if((r[D0+RN1]&0x80000000)!=0)	r[SR]|=CCR_NON;
	r[PC]+=6;	return;



case	0x0a90:		//mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.L #$%08X,(A%d)\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1])^num4(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	w4(r[A0+RN1],TL1);
	r[PC]+=6;	return;



case	0x0a98:		//mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.L #$%08X,(A%d)+\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1])^num4(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	w4(r[A0+RN1],TL1);
	r[A0+RN1]+=4;
	r[PC]+=6;	return;



case	0x0aa0:		//mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"EORI.L #$%08X,-(A%d)\n",
	num4(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=4;
	TL1=r4(r[A0+RN1])^num4(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	w4(r[A0+RN1],TL1);
	r[PC]+=6;	return;



case	0x0aa8:		//mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"EORI.L #$%08X,$%04X(A%d)\n",
	num4(1),num2(3),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]+(short)num2(3))^num4(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	w4(r[A0+RN1]+(short)num2(3),TL1);
	r[PC]+=8;	return;



case	0x0ab0:		//byte size , mem addr with index
	RN3=(num2(3)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"EORI.L #$%08X,$%02X(A%d,X%d)\n",
	num4(1),num1(3),RN1,RN3);	CO(buf);	}
#endif
	if((num2(3)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(3)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(3)+       r[D0+RN3];	//32bitgp
	TL1=r4(TR1)^num4(1);
	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	w4(TR1,TL1);
	r[PC]+=8;	return;



case	0x0ab8:				//abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"EORI.L #$%08X,$%04X\n",
	num4(1),num2(3));	CO(buf);	}
#endif
			TR1=(short)num2(3);
			TL1=r4(TR1)^num4(1);
			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				r[SR]|=CCR_ZON;
			if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
			w4(TR1,TL1);
			r[PC]+=8;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD4;	sprintf(buf,"EORI.L #$%08X,$%08X\n",
	num4(1),num4(3));	CO(buf);	}
#endif
			TR1=num4(3);
			TL1=r4(TR1)^num4(1);
			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				r[SR]|=CCR_ZON;
			if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
			w4(TR1,TL1);
			r[PC]+=10;	return;


		default:
			gic();	return;
	}
