//	MC68K	MOVE to SR



case	0x06c0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD0;	sprintf(buf,"MOVE D%d,SR\n",RN1);	CO(buf);	}
#endif
	if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
		CO("<User State! TRAP!>\n");
#endif
		goto	_TRAP;	}
	r[TSR]=r[SR];	r[SR]=(unsigned short)r[D0+RN1];
	if((r[TSR]^r[SR])&0x2000)								//Change state
		if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
			else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
	r[PC]+=2;	return;



case	0x06d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD0;	sprintf(buf,"MOVE (A%d),SR\n",RN1);	CO(buf);	}
#endif
	if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
		CO("<User State! TRAP!>\n");
#endif
		goto	_TRAP;	}

	r[TSR]=r[SR];	r[SR]=r2(r[A0+RN1]);
	if((r[TSR]^r[SR])&0x2000)								//Change state
		if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
			else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
	r[PC]+=2;	return;



case	0x06d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD0;	sprintf(buf,"MOVE (A%d)+,SR\n",RN1);	CO(buf);	}
#endif
	if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
		CO("<User State! TRAP!>\n");
#endif
		goto	_TRAP;										}

	r[TSR]=r[SR];	r[SR]=r2(r[A0+RN1]);	r[A0+RN1]+=2;
	if((r[TSR]^r[SR])&0x2000)								//Change state
		if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
			else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
	r[PC]+=2;	return;



case	0x06e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD0;	sprintf(buf,"MOVE -(A%d),SR\n",RN1);	CO(buf);	}
#endif
	if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
		CO("<User State! TRAP!>\n");
#endif
		goto	_TRAP;										}
	r[TSR]=r[SR];	r[A0+RN1]-=2;	r[SR]=r2(r[A0+RN1]);
	if((r[TSR]^r[SR])&0x2000)								//Change state
		if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
			else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
	r[PC]+=2;	return;



case	0x06e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD1;	sprintf(buf,"MOVE $%04X(A%d),SR\n",num2(1),RN1);	CO(buf);	}
#endif
	if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
		CO("<User State! TRAP!>\n");
#endif
		goto	_TRAP;										}

	r[TSR]=r[SR];	r[SR]=r2(r[A0+RN1]+(short)num2(1));
	if((r[TSR]^r[SR])&0x2000)								//Change state
		if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
			else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
	r[PC]+=4;	return;



case	0x06f0:
	RN2=(num2(1)>>12)&15;	//index

#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"MOVE $%02X(A%d,X%d),SR\n",
	num1(1),RN1,RN2);	CO(buf);	}
#endif
	if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
		CO("<User State! TRAP!>\n");
#endif
		goto	_TRAP;	}

	r[TSR]=r[SR];

	if((num2(2)&0x0800)==0)
			r[SR]=r2(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN2]);
	else	r[SR]=r2(r[A0+RN1]+(char)num1(1)+       r[D0+RN2]);

	if((r[TSR]^r[SR])&0x2000)								//Change state
		if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
			else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
	r[PC]+=4;	return;



case	0x06f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD1;	sprintf(buf,"MOVE $%04X,SR\n",num2(1));	CO(buf);	}
#endif
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				CO("<User State! TRAP!>\n");
#endif
				goto	_TRAP;	}

			r[TSR]=r[SR];	r[SR]=r2((short)num2(1));
			if((r[TSR]^r[SR])&0x2000)							//Change state
				if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
					else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD2;	sprintf(buf,"MOVE $%08X,SR\n",num4(1));	CO(buf);	}
#endif
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				CO("<User State! TRAP!>\n");
#endif
				goto	_TRAP;	}

			r[TSR]=r[SR];	r[SR]=r2(num4(1));
			if((r[TSR]^r[SR])&0x2000)							//Change state
				if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
					else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD1;	sprintf(buf,"MOVE $%04X(PC),SR\n",num2(1));	CO(buf);	}
#endif
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				CO("<User State! TRAP!>\n");
#endif
				goto	_TRAP;	}

			r[TSR]=r[SR];	r[SR]=r2(r[PC]+(short)num2(1)+2);
			if((r[TSR]^r[SR])&0x2000)							//Change state
				if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
					else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
			r[PC]+=4;	return;



		case	3:
			RN2=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD1;	sprintf(buf,"MOVE $%02X(PC,X%d),SR\n",num1(1),RN2);	CO(buf);	}
#endif
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				CO("<User State! TRAP!>\n");
#endif
				goto	_TRAP;	}

			r[TSR]=r[SR];

			if((num2(2)&0x0800)==0)
					r[SR]=r2(r[PC]+(char)num1(1)+(short)r[D0+RN2]+2);
			else	r[SR]=r2(r[PC]+(char)num1(1)+       r[D0+RN2]+2);

			if((r[TSR]^r[SR])&0x2000)							//Change state
				if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//UtoS
					else{			r[SSP]=r[A7];	r[A7]=r[USP];	}	//StoU
			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){
	BD1;	sprintf(buf,"MOVE #$%04X,SR\n",num2(1));	CO(buf);	}
#endif
			if(!(r[SR]&0x2000)){								//User state
#ifdef	_DEBUG
				CO("<User State! TRAP!>\n");
#endif
				goto	_TRAP;	}

			r[TSR]=r[SR];	r[SR]=num2(1);
			if((r[TSR]^r[SR])&0x2000)							//Change state
				if(r[SR]&0x2000){	r[USP]=r[A7];	r[A7]=r[SSP];	}	//U2S
					else		{	r[SSP]=r[A7];	r[A7]=r[USP];	}	//S2U
			r[PC]+=4;	return;



		default:
			gic();	return;
	}
