//	MC68K code ROL



case	0x0118:
case	0x0318:
case	0x0518:
case	0x0718:
case	0x0918:
case	0x0b18:
case	0x0d18:
case	0x0f18:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.B #$%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x80)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1<<=1;	}
			else{			r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1<<1)|1;	}	}
	if((unsigned char)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x80)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|(TL1&0xff);
	r[PC]+=2;	return;



case	0x0158:
case	0x0358:
case	0x0558:
case	0x0758:
case	0x0958:
case	0x0b58:
case	0x0d58:
case	0x0f58:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.W #$%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1<<=1;	}
			else{				r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1<<1)|1;	}	}
	if((unsigned short)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x8000)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|(TL1&0xffff);
	r[PC]+=2;	return;



case	0x0198:
case	0x0398:
case	0x0598:
case	0x0798:
case	0x0998:
case	0x0b98:
case	0x0d98:
case	0x0f98:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.L #$%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&0x80000000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1<<=1;	}
			else{					r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1<<1)|1;	}}
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	r[D0+RN1]=TL1;
	r[PC]+=2;	return;





case	0x0138:
case	0x0338:
case	0x0538:
case	0x0738:
case	0x0938:
case	0x0b38:
case	0x0d38:
case	0x0f38:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.B D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x80)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1<<=1;	}
			else{			r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1<<1)|1;	}	}
	if((unsigned char)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x80)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|(TL1&0xff);
	r[PC]+=2;	return;



case	0x0178:
case	0x0378:
case	0x0578:
case	0x0778:
case	0x0978:
case	0x0b78:
case	0x0d78:
case	0x0f78:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.W D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1<<=1;	}
			else{				r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1<<1)|1;	}	}
	if((unsigned short)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x8000)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|(TL1&0xffff);
	r[PC]+=2;	return;



case	0x01b8:
case	0x03b8:
case	0x05b8:
case	0x07b8:
case	0x09b8:
case	0x0bb8:
case	0x0db8:
case	0x0fb8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.L D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&0x80000000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1<<=1;	}
			else{					r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1<<1)|1;	}}
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	r[D0+RN1]=TL1;
	r[PC]+=2;	return;





case	0x07d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.W (A%d)\n",
	RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=TS1<<1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;			}
		else{				r[SR]|=CCR_XON |CCR_CON;	TS2|=1;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=2;	return;



case	0x07d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.W (A%d)+\n",
	RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=TS1<<1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;			}
		else{				r[SR]|=CCR_XON |CCR_CON;	TS2|=1;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x07e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROL.W -(A%d)\n",
	RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=TS1<<1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;			}
		else{				r[SR]|=CCR_XON |CCR_CON;	TS2|=1;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=2;	return;



case	0x07e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROL.W $%04X(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TS1=r2(TR1);
	TS2=TS1<<1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;			}
		else{				r[SR]|=CCR_XON |CCR_CON;	TS2|=1;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



case	0x07f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROL.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];
	TS1=r2(TR1);
	TS2=TS1<<1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;			}
		else{				r[SR]|=CCR_XON |CCR_CON;	TS2|=1;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



case	0x07f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROL.W $%04X\n",
	num2(1));	CO(buf);	}
#endif
	TR1=(short)num2(1);
	TS1=r2(TR1);
	TS2=TS1<<1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;			}
		else{				r[SR]|=CCR_XON |CCR_CON;	TS2|=1;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ROL.W $%08X\n",
	num4(1));	CO(buf);	}
#endif
	TR1=(short)num4(1);
	TS1=r2(TR1);
	TS2=TS1<<1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&0x8000)==0){	r[SR]&=CCR_XOFF&CCR_COFF;			}
		else{				r[SR]|=CCR_XON |CCR_CON;	TS2|=1;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=6;	return;



		default:
			gic();	return;
	}



