//	MC68K code ROR



case	0x0018:
case	0x0218:
case	0x0418:
case	0x0618:
case	0x0818:
case	0x0a18:
case	0x0c18:
case	0x0e18:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.B #$1,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1>>=1;	}
			else{		r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1>>1)|0x80;	}	}
	if((unsigned char)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x80)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|(TL1&0xff);
	r[PC]+=2;	return;



case	0x0058:
case	0x0258:
case	0x0458:
case	0x0658:
case	0x0858:
case	0x0a58:
case	0x0c58:
case	0x0e58:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.W #$1,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1>>=1;	}
			else{		r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1>>1)|0x8000;	}	}
	if((unsigned short)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x8000)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|(TL1&0xffff);
	r[PC]+=2;	return;



case	0x0098:
case	0x0298:
case	0x0498:
case	0x0698:
case	0x0898:
case	0x0a98:
case	0x0c98:
case	0x0e98:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.L #$1,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	for(TC1=0;TC1!=RN2;TC1++){
		if((TL1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1>>=1;	}
			else{		r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1>>1)|0x80000000;	}}
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	r[D0+RN1]=TL1;
	r[PC]+=2;	return;





case	0x0038:
case	0x0238:
case	0x0438:
case	0x0638:
case	0x0838:
case	0x0a38:
case	0x0c38:
case	0x0e38:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.B D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1>>=1;	}
			else{		r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1>>1)|0x80;	}}
	if((unsigned char)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x80)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|(TL1&0xff);
	r[PC]+=2;	return;



case	0x0078:
case	0x0278:
case	0x0478:
case	0x0678:
case	0x0878:
case	0x0a78:
case	0x0c78:
case	0x0e78:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.W D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1>>=1;	}
			else{		r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1>>1)|0x8000;	}}
	if((unsigned short)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x8000)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|(TL1&0xffff);
	r[PC]+=2;	return;



case	0x00b8:
case	0x02b8:
case	0x04b8:
case	0x06b8:
case	0x08b8:
case	0x0ab8:
case	0x0cb8:
case	0x0eb8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.L D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		if((TL1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	TL1>>=1;	}
			else{		r[SR]|=CCR_XON |CCR_CON;	TL1=(TL1>>1)|0x80000000;	}}
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	r[D0+RN1]=TL1;
	r[PC]+=2;	return;





case	0x06d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.W (A%d)\n",
	RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=(unsigned short)TS1>>1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	}
		else{		r[SR]|=CCR_XON |CCR_CON;	TS2|=0x8000;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=2;	return;



case	0x06d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.W (A%d)+\n",
	RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=(unsigned short)TS1>>1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	}
		else{		r[SR]|=CCR_XON |CCR_CON;	TS2|=0x8000;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x06e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROR.W -(A%d)\n",
	RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=(unsigned short)TS1>>1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	}
		else{		r[SR]|=CCR_XON |CCR_CON;	TS2|=0x8000;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=2;	return;



case	0x06e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROR.W $%04X(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TS1=r2(TR1);
	TS2=(unsigned short)TS1>>1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	}
		else{		r[SR]|=CCR_XON |CCR_CON;	TS2|=0x8000;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



case	0x06f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROR.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];
	TS1=r2(TR1);
	TS2=(unsigned short)TS1>>1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	}
		else{		r[SR]|=CCR_XON |CCR_CON;	TS2|=0x8000;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



case	0x06f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROR.W $%04X\n",
	num2(1));	CO(buf);	}
#endif
	TR1=(short)num2(1);
	TS1=r2(TR1);
	TS2=(unsigned short)TS1>>1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	}
		else{		r[SR]|=CCR_XON |CCR_CON;	TS2|=0x8000;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ROR.W $%08X\n",
	num4(1));	CO(buf);	}
#endif
	TR1=(short)num4(1);
	TS1=r2(TR1);
	TS2=(unsigned short)TS1>>1;
	r[SR]&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if((TS1&1)==0){	r[SR]&=CCR_XOFF&CCR_COFF;	}
		else{		r[SR]|=CCR_XON |CCR_CON;	TS2|=0x8000;	}
	if(TS2==0)			r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)	r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=6;	return;



		default:
			gic();	return;
	}



