//	MC68K code ROX



case	0x0010:
case	0x0210:
case	0x0410:
case	0x0610:
case	0x0810:
case	0x0a10:
case	0x0c10:
case	0x0e10:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.B #$1,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	for(TC1=0;TC1!=RN2;TC1++){
		switch((TL1&1)|(r[SR]&CCR_XON)){
			case	0x00:	TL1=(TL1>>1)&0x7f;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
			case	0x10:	TL1=(TL1>>1)|0x80;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
			case	0x01:	TL1=(TL1>>1)&0x7f;	r[SR]|=CCR_XON| CCR_CON;	break;
			case	0x11:	TL1=(TL1>>1)|0x80;	r[SR]|=CCR_XON| CCR_CON;	break;
		}
	}
	if((unsigned char)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x80)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|(TL1&0xff);
	r[PC]+=2;	return;



case	0x0050:
case	0x0250:
case	0x0450:
case	0x0650:
case	0x0850:
case	0x0a50:
case	0x0c50:
case	0x0e50:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.W #$1,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	for(TC1=0;TC1!=RN2;TC1++){
		switch((TL1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TL1=(TL1>>1)&0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TL1=(TL1>>1)|0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TL1=(TL1>>1)&0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TL1=(TL1>>1)|0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
		}
	}
	if((unsigned short)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x8000)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|(TL1&0xffff);
	r[PC]+=2;	return;



case	0x0090:
case	0x0290:
case	0x0490:
case	0x0690:
case	0x0890:
case	0x0a90:
case	0x0c90:
case	0x0e90:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.L #$1,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	if(RN2==0)	RN2=8;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	for(TC1=0;TC1!=RN2;TC1++){
		switch((TL1&1)|(r[SR]&CCR_XON)){
	case	0x00:	TL1=(TL1>>1)&0x7fffffff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
	case	0x10:	TL1=(TL1>>1)|0x80000000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
	case	0x01:	TL1=(TL1>>1)&0x7fffffff;	r[SR]|=CCR_XON| CCR_CON;	break;
	case	0x11:	TL1=(TL1>>1)|0x80000000;	r[SR]|=CCR_XON| CCR_CON;	break;
		}
	}
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	r[D0+RN1]=TL1;
	r[PC]+=2;	return;





case	0x0030:
case	0x0230:
case	0x0430:
case	0x0630:
case	0x0830:
case	0x0a30:
case	0x0c30:
case	0x0e30:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.B D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		switch((TL1&1)|(r[SR]&CCR_XON)){
			case	0x00:	TL1=(TL1>>1)&0x7f;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
			case	0x10:	TL1=(TL1>>1)|0x80;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
			case	0x01:	TL1=(TL1>>1)&0x7f;	r[SR]|=CCR_XON| CCR_CON;	break;
			case	0x11:	TL1=(TL1>>1)|0x80;	r[SR]|=CCR_XON| CCR_CON;	break;
		}
	}
	if((unsigned char)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x80)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffffff00)|(TL1&0xff);
	r[PC]+=2;	return;



case	0x0070:
case	0x0270:
case	0x0470:
case	0x0670:
case	0x0870:
case	0x0a70:
case	0x0c70:
case	0x0e70:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.W D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		switch((TL1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TL1=(TL1>>1)&0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TL1=(TL1>>1)|0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TL1=(TL1>>1)&0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TL1=(TL1>>1)|0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
		}
	}
	if((unsigned short)TL1==0)	r[SR]|=CCR_ZON;
	if((TL1&0x8000)!=0)			r[SR]|=CCR_NON;
	r[D0+RN1]=(r[D0+RN1]&0xffff0000)|(TL1&0xffff);
	r[PC]+=2;	return;



case	0x00b0:
case	0x02b0:
case	0x04b0:
case	0x06b0:
case	0x08b0:
case	0x0ab0:
case	0x0cb0:
case	0x0eb0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.L D%d,D%d\n",
	RN2,RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	TC2=(char)(r[D0+RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		switch((TL1&1)|(r[SR]&CCR_XON)){
	case	0x00:	TL1=(TL1>>1)&0x7fffffff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
	case	0x10:	TL1=(TL1>>1)|0x80000000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
	case	0x01:	TL1=(TL1>>1)&0x7fffffff;	r[SR]|=CCR_XON| CCR_CON;	break;
	case	0x11:	TL1=(TL1>>1)|0x80000000;	r[SR]|=CCR_XON| CCR_CON;	break;
		}
	}
	if(TL1==0)				r[SR]|=CCR_ZON;
	if((TL1&0x80000000)!=0)	r[SR]|=CCR_NON;
	r[D0+RN1]=TL1;
	r[PC]+=2;	return;





case	0x04d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.W (A%d)\n",
	RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=TS1>>1;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TS2&=0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TS2|=0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TS2&=0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TS2|=0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
	}
	if((unsigned short)TS2==0)	r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)			r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=2;	return;



case	0x04d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.W (A%d)+\n",
	RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=TS1>>1;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TS2&=0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TS2|=0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TS2&=0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TS2|=0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
	}
	if((unsigned short)TS2==0)	r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)			r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x04e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"ROX.W -(A%d)\n",
	RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=TS1>>1;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TS2&=0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TS2|=0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TS2&=0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TS2|=0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
	}
	if((unsigned short)TS2==0)	r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)			r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=2;	return;



case	0x04e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROX.W $%04X(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TS1=r2(TR1);
	TS2=TS1>>1;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TS2&=0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TS2|=0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TS2&=0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TS2|=0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
	}
	if((unsigned short)TS2==0)	r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)			r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



case	0x04f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROX.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];
	TS1=r2(TR1);
	TS2=TS1>>1;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TS2&=0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TS2|=0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TS2&=0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TS2|=0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
	}
	if((unsigned short)TS2==0)	r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)			r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



case	0x04f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"ROX.W $%04X\n",
	num2(1));	CO(buf);	}
#endif
	TR1=(short)num2(1);
	TS1=r2(TR1);
	TS2=TS1>>1;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TS2&=0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TS2|=0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TS2&=0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TS2|=0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
	}
	if((unsigned short)TS2==0)	r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)			r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"ROX.W $%08X\n",
	num4(1));	CO(buf);	}
#endif
	TR1=(short)num4(1);
	TS1=r2(TR1);
	TS2=TS1>>1;
	r[SR]&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&1)|(r[SR]&CCR_XON)){
		case	0x00:	TS2&=0x7fff;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x10:	TS2|=0x8000;	r[SR]&=CCR_XOFF&CCR_COFF;	break;
		case	0x01:	TS2&=0x7fff;	r[SR]|=CCR_XON| CCR_CON;	break;
		case	0x11:	TS2|=0x8000;	r[SR]|=CCR_XON| CCR_CON;	break;
	}
	if((unsigned short)TS2==0)	r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)			r[SR]|=CCR_NON;
	w2(TR1,TS2);
	r[PC]+=6;	return;



		default:
			gic();	return;
	}



