#include	"../mc68k.h"



void	MC68K::sr_add_c(	unsigned char	c1,
							unsigned char	c2	)
{							unsigned char	c3=c1+c2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;

	if(c3==0)					r[SR]|=CCR_ZON;
	if((c3&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((c1^c2)&0x80)!=0)		r[SR]|=CCR_VON;
	if(c3<c1){					r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}
}



void	MC68K::sr_add_s(	unsigned short	w1,
							unsigned short	w2	)
{							unsigned short	w3=w1+w2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;

	if(w3==0)					r[SR]|=CCR_ZON;
	if((w3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((w1^w2)&0x8000)!=0)		r[SR]|=CCR_VON;
	if(w3<w1){					r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}
}



void	MC68K::sr_add_l(	unsigned long	l1,
							unsigned long	l2	)
{							unsigned long	l3=l1+l2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;

	if(l3==0)					r[SR]|=CCR_ZON;
	if((l3&0x80000000)!=0)		r[SR]|=CCR_NON;
		else
	if(((l1^l2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(l3<l1){					r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}
}



void	MC68K::sr_sub_c(	unsigned char	c1,
							unsigned char	c2	)
{							unsigned char	c3=c1-c2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;

	if(c3==0)					r[SR]|=CCR_ZON;
	if((c3&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((c1^c2)&0x80)!=0)		r[SR]|=CCR_VON;
	if(c3>c1){					r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}
}



void	MC68K::sr_sub_s(	unsigned short	w1,
							unsigned short	w2	)
{							unsigned short	w3=w1-w2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;

	if(w3==0)					r[SR]|=CCR_ZON;
	if((w3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((w1^w2)&0x8000)!=0)		r[SR]|=CCR_VON;
	if(w3>w1){					r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}
}



void	MC68K::sr_sub_l(	unsigned long	l1,
							unsigned long	l2	)
{							unsigned long	l3=l1-l2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;

	if(l3==0)					r[SR]|=CCR_ZON;
	if((l3&0x80000000)!=0)		r[SR]|=CCR_NON;
		else
	if(((l1^l2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(l3>l1){					r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}
}



