//MC68K macros



//get operand
#define	num1(addr)	(r1(r[PC]+1+addr*2))
#define	num2(addr)	(r2(r[PC]+  addr*2))
#define	num4(addr)	(r4(r[PC]+  addr*2))

//display binary code
#define	BD0	sprintf(buf,"%04X                     ",num2(0));CO(buf)
#define	BD1	sprintf(buf,"%04X %04X                ",num2(0),num2(1));CO(buf)
#define	BD2	sprintf(buf,"%04X %04X %04X           ",num2(0),num2(1),num2(2));CO(buf)
#define	BD3	sprintf(buf,"%04X %04X %04X %04X      ",num2(0),num2(1),num2(2),num2(3));CO(buf)
#define	BD4	sprintf(buf,"%04X %04X %04X %04X %04X ",num2(0),num2(1),num2(2),num2(3),num2(4));CO(buf)



#ifdef	_DEBUG
//get operand
#define	dnm1(addr)	(r1(r[DPC]+1+addr*2))
#define	dnm2(addr)	(r2(r[DPC]+  addr*2))
#define	dnm4(addr)	(r4(r[DPC]+  addr*2))

//display binary code
#define	DD0	sprintf(buf,"%04X                     ",dnm2(0));CO(buf)
#define	DD1	sprintf(buf,"%04X %04X                ",dnm2(0),dnm2(1));CO(buf)
#define	DD2	sprintf(buf,"%04X %04X %04X           ",dnm2(0),dnm2(1),dnm2(2));CO(buf)
#define	DD3	sprintf(buf,"%04X %04X %04X %04X      ",dnm2(0),dnm2(1),dnm2(2),dnm2(3));CO(buf)
#define	DD4	sprintf(buf,"%04X %04X %04X %04X %04X ",dnm2(0),dnm2(1),dnm2(2),dnm2(3),dnm2(4));CO(buf)
#endif



//opecode bit field
#define	DC_02	0x0007
#define	DC_03	0x000f
#define	DC_07	0x00ff
#define	DC_33	0x0008
#define	DC_34	0x0018
#define	DC_35	0x0038
#define	DC_37	0x00f8
#define	DC_38	0x01f8
#define	DC_3b	0x0ff8
#define	DC_55	0x0020
#define	DC_66	0x0040
#define	DC_67	0x00c0
#define	DC_68	0x01c0
#define	DC_88	0x0080
#define	DC_8b	0x0f00
#define	DC_9b	0x0e00

//status bit
#define	CCR_CON		(unsigned short)0x0001
#define	CCR_VON		(unsigned short)0x0002
#define	CCR_ZON		(unsigned short)0x0004
#define	CCR_NON		(unsigned short)0x0008
#define	CCR_XON		(unsigned short)0x0010

#define	CCR_COFF	(unsigned short)0xfffe
#define	CCR_VOFF	(unsigned short)0xfffd
#define	CCR_ZOFF	(unsigned short)0xfffb
#define	CCR_NOFF	(unsigned short)0xfff7
#define	CCR_XOFF	(unsigned short)0xffef

//condition code
enum{	CC_T ,CC_F ,CC_HI,CC_LS,CC_CC,CC_CS,CC_NE,CC_EQ,
		CC_VC,CC_VS,CC_PL,CC_MI,CC_GE,CC_LT,CC_GT,CC_LE	};
