#ifndef		_AZU_MC68K_
#define		_AZU_MC68K_

#include	<windows.h>
#include	"../cpu.h"
#include	"../../device/mat.h"
#include	"../../device/le.h"
#include	"dbg_def.h"
#include	"reg_def.h"
#include	"macros.h"

class	MC68K
{
public:
			MAT				mat[0x10000];
			unsigned char	isl[0x100];				//Interrupt State & Level
			unsigned long	r[MC68K_REG_MAX];
			LARGE_INTEGER	count;
#include	"dbg_pub.h"

			unsigned char	r1(unsigned long);
			unsigned short	r2(unsigned long);
			unsigned long	r4(unsigned long);
			void			w1(unsigned long,unsigned char);
			void			w2(unsigned long,unsigned short);
			void			w4(unsigned long,unsigned long);

#include	"intprt.h"

			void			interrupt(void);
			void			init(void);
			void			por(void);
			void			gic(void);
			void			loop(void);
};

#endif		_AZU_MC68K_
