#include	"mfp.h"

#ifdef	_DEBUG
#include	<stdio.h>
#include	"../../window/console/console.h"

extern	CONSOLE	con;
#endif	_DEBUG



unsigned char	MFP::_r1(unsigned char *dmy,unsigned long addr)
{
#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<MFP>\tR1\t%08X\n",addr);	CO(buf);
#endif
	return(reg[addr]);
}



unsigned short	MFP::_r2(unsigned char *dmy,unsigned long addr)
{
#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<MFP>\tR2\t%08X\n",addr);	CO(buf);
#endif
	return(0xffff);
}



unsigned long	MFP::_r4(unsigned char *dmy,unsigned long addr)
{
#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<MFP>\tR4\t%08X\n",addr);	CO(buf);
#endif
	return(0xffffffff);
}





void	MFP::_w1(unsigned char *dmy,unsigned long addr,unsigned char data)
{
	switch(addr){
		case	0x8001:
			reg[0x01]=0x6b;		return;
		case	0x802d:
			reg[0x2d]|=0x80;	return;		//always buffer empty
		default:
			reg[addr]=data;	return;
	}

#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<MFP>\tW1\t%08X < %02X\n",addr,data);	CO(buf);
#endif
}




void	MFP::_w2(unsigned char *dmy,unsigned long addr,unsigned short data)
{
#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<MFP>\tW2\t%08X < %04X\n",addr,data);	CO(buf);
#endif
}




void	MFP::_w4(unsigned char *dmy,unsigned long addr,unsigned long data)
{
#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<MFP>\tW4\t%08X < %08X\n",addr,data);	CO(buf);
#endif
}
