//	Alpha Blending C code	pixel format A8R8G8B8
#include	"../gfx.h"



void	GFX::vcopy_alpha(
	unsigned char *	fp,			//Front
	unsigned char *	bp,			//Back
	unsigned char *	tp,			//Target
	unsigned long	fx_span,
	unsigned long	bx_span,
	unsigned long	tx_span,
	unsigned long	x,
	unsigned long	y				)
{
	unsigned long	cx,cy;
	unsigned char	*tfp,*tbp,*ttp;

	for(cy=0;cy!=y;cy++){
		tfp=fp+((fx_span*cy)<<2);
		tbp=bp+((bx_span*cy)<<2);
		ttp=tp+((tx_span*cy)<<2);
		for(cx=0;cx!=x;cx++){
			*(ttp+0)=0xff;
			*(ttp+1)=(unsigned char)((			*(tfp+0)*	*(tfp+1)	+
										(255-	*(tfp+0))*	*(tbp+1)	)>>8);
			*(ttp+2)=(unsigned char)((			*(tfp+0)*	*(tfp+2)	+
										(255-	*(tfp+0))*	*(tbp+2)	)>>8);
			*(ttp+3)=(unsigned char)((			*(tfp+0)*	*(tfp+3)	+
										(255-	*(tfp+0))*	*(tbp+3)	)>>8);
			tfp+=4;
			tbp+=4;
			ttp+=4;
		}
	}
}



void	GFX::vcopy(
	unsigned char *	fp,			//Front
	unsigned char *	bp,			//Back
	unsigned char *	tp,			//Target
	unsigned long	fx_span,
	unsigned long	bx_span,
	unsigned long	tx_span,
	unsigned long	x,
	unsigned long	y				)
{
	unsigned long	cx,cy;
	unsigned char	*tfp,*ttp;

	for(cy=0;cy!=y;cy++){
		tfp=fp+((fx_span*cy)<<2);
		ttp=tp+((tx_span*cy)<<2);
		for(cx=0;cx!=x;cx++){
			*(unsigned long*)ttp=*(unsigned long *)tfp;
			*(ttp+0)=0xff;

			tfp+=4;
			ttp+=4;
		}
	}
}



