#include	"gfx.h"
#include	"../../cpu/mc68k/mc68k.h"
#include	"../../device/memory/memory.h"

extern	MC68K					m68k;
extern	MEMORY					v2v;



void	GFX::make_vinfo(void)
{
	unsigned long	s,t,u,v,x,y;
	unsigned long	v2sx=H_RESOLUTION;
	unsigned long	v2sy=V_RESOLUTION;

	switch(vinfo_stat&0xff){
		default:
			ZeroMemory(vinfo,v2sx*v2sy*4);	break;




#ifdef	_DEBUG									//R\[͕K{Ȃ̂
		case	0x02:							//memory view
			ZeroMemory(vinfo,v2sx*v2sy*4);
			if(v2sx<mv_span)	v=v2sx;
				else			v=mv_span;
			switch(mv_bpp){
				default:
				case	32:
					for(y=0;y!=v2sy;y++){
						u=mv_addr+y*(mv_span<<2);
						for(x=0;x!=v;x++){
							s=(y*v2sx+x)<<2;
							t=m68k.r4(u);
							vinfo[s+0]=0xff;			//A
							vinfo[s+1]=(unsigned char)(t>>16);
							vinfo[s+2]=(unsigned char)(t>>8);
							vinfo[s+3]=(unsigned char)t;
							u+=4;
						}
					}
					break;

				case	24:
					for(y=0;y!=v2sy;y++){
						u=mv_addr+y*(mv_span*3);
						for(x=0;x!=v;x++){
							s=(y*v2sx+x)<<2;
							t=m68k.r4(u);
							vinfo[s+0]=0xff;			//A
							vinfo[s+1]=(unsigned char)(t>>24);
							vinfo[s+2]=(unsigned char)(t>>16);
							vinfo[s+3]=(unsigned char)(t>>8);
							u+=3;
						}
					}
					break;

				case	16:
					for(y=0;y!=v2sy;y++){
						u=mv_addr+y*(mv_span<<1);
						for(x=0;x!=v;x++){
							s=(y*v2sx+x)<<2;
							t=m68k.r2(u);
							vinfo[s+0]=0xff;			//A
							vinfo[s+1]=(unsigned char)((t>>8)&0xf8);
							vinfo[s+2]=(unsigned char)((t>>3)&0xfc);
							vinfo[s+3]=(unsigned char)((t<<3)&0xf8);
							u+=2;
						}
					}
					break;

				case	15:
					for(y=0;y!=v2sy;y++){
						u=mv_addr+y*(mv_span<<1);
						for(x=0;x!=v;x++){
							s=(y*v2sx+x)<<2;
							t=m68k.r2(u);
							vinfo[s+0]=0xff;			//A
							vinfo[s+1]=(unsigned char)((t>>7)&0xf8);
							vinfo[s+2]=(unsigned char)((t>>2)&0xf8);
							vinfo[s+3]=(unsigned char)((t<<3)&0xf8);
							u+=2;
						}
					}
					break;

				case	8:
					for(y=0;y!=v2sy;y++){
						u=mv_addr+y*mv_span;
						for(x=0;x!=v;x++){
							s=(y*v2sx+x)<<2;
							t=m68k.r1(u);
							vinfo[s+0]=0xff;			//A
							vinfo[s+1]=(unsigned char)t;
							vinfo[s+2]=(unsigned char)t;
							vinfo[s+3]=(unsigned char)t;
							u++;
						}
					}
					break;

			}
			break;
#endif	_DEBUG



		case	0xfe:							//test	alpha blending
			ZeroMemory(vinfo,v2sx*v2sy*4);
			for(y=0;y!=v2sy;y++){
				for(x=0;x!=v2sx;x++){
					u=(v2sx*y+x)*4;
					vinfo[u+0]=(unsigned char)(y*0xff/v2sy);	//A
					vinfo[u+1]=0;								//R
					vinfo[u+2]=(unsigned char)(x*0xff/v2sx);	//G
					vinfo[u+3]=0;								//B
			}	}
			break;
		case	0xff:							//test	color
			ZeroMemory(vinfo,v2sx*v2sy*4);
			for(y=0;y!=v2sy;y++){
				for(x=0;x!=v2sx;x++){
					u=(v2sx*y+x)*4;
					vinfo[u+0]=0xff;							//A
					vinfo[u+1]=0;								//R
					vinfo[u+2]=(unsigned char)(x*0xff/v2sx);	//G
					vinfo[u+3]=(unsigned char)(y*0xff/v2sy);	//B
			}	}
			break;
	}
}
