#include	<windows.h>
#include	"main.h"
#include	"../window.h"
#include	"../gfx/gfx.h"
#include	"../ipt/ipt.h"

#include	"../console/console.h"
#ifdef	_DEBUG
#include	"../../monitor/monitor.h"



		MONITOR				mon;
#endif
		CONSOLE				con;

extern	HWND				hWnd_main;
extern	HWND				hWnd_splash;

extern	void				get_path(void);
extern	void				create_popup_menu(void);
extern	void				create_main_window(HINSTANCE);
extern	void				create_splash_window(HINSTANCE);
extern	void				mem_bind(void);
extern	void				load_rom(unsigned long);
extern	void				priority_constructor(void);

extern	HANDLE				trdh[TRD_MAX];
extern	DWORD				trdi[TRD_MAX];
extern	unsigned long		trdc;
extern	DWORD WINAPI		trdg(void);

		GFX					gfx;
		IPT					ipt;



int WINAPI WinMain(	HINSTANCE	hNowInstance,
					HINSTANCE	hPreInstance,
					LPSTR		lpCmdLine,
					int			CmdShow		)
{
	MSG				msg;

	get_path();
	create_splash_window(hNowInstance);

/******************************************************************************
	Compile directive
		_DEBUG				debug/release
		VIRTUAL_CLASS		use virtual class method
		DYNAMIC_RECOMPILE	enable/disable dynamic recompile
******************************************************************************/



#ifdef	_DEBUG
	con.init();

#ifdef	VIRTUAL_CLASS
	CO("Enable Virtual Class\n");
#else
	CO("Disable Virtual Class\n");
#endif

#ifdef	DYNAMIC_RECOMPILE
	CO("Enable Dynamic ReCompile\n");
#else
	CO("Disable Dynamic ReCompile\n");
#endif

#endif
	create_popup_menu();
	create_main_window(hNowInstance);

	gfx.init();
	ipt.init(hNowInstance);
	mem_bind();				Sleep(10);
	load_rom(0);			Sleep(10);

	trdh[TRD_MC68K    ]=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)trdg,
						hWnd_main,0,&trdi[TRD_MC68K]);		Sleep(10);
	trdh[TRD_RTI      ]=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)trdg,
							hWnd_main,0,&trdi[TRD_RTI]);	Sleep(10);
#ifdef	_DEBUG
	trdh[TRD_MONITOR  ]=CreateThread(NULL,0,(LPTHREAD_START_ROUTINE)trdg,
						hWnd_main,0,&trdi[TRD_MONITOR]);	Sleep(10);
#endif

	priority_constructor();
	PostMessage(hWnd_main,WM_COMMAND,IDM_GFX_SIZE,NULL);
	DestroyWindow(hWnd_splash);

	while(GetMessage(&msg,NULL,0,0)){
		TranslateMessage(&msg);
		DispatchMessage(&msg);	}
	return(msg.wParam);
}
