#include	<windows.h>
#include	<stdio.h>
#include	"main.h"
#include	"../window.h"

extern	char		path_inifile[_MAX_PATH];
extern	HANDLE		trdh[TRD_MAX];

extern	HMENU	hmenu_priority_m68k;
extern	HMENU	hmenu_priority_rti;

void			priority_constructor(void);
void			priority_destructor(void);
unsigned long	priority_p2m(int);
int				priority_m2p(unsigned long);
void			priority_swm(unsigned long,int,HMENU,unsigned long);



unsigned long	priority_p2m(int x)
{	switch(x){
		case	 15:	return(0);		//TimeCritical
		case	  2:	return(1);		//Highest
		case	  1:	return(2);		//High
		default:
		case	  0:	return(3);		//Normal
		case	 -1:	return(4);		//Low
		case	 -2:	return(5);		//Lowest
		case	-15:	return(6);		//Idle
	}
}



int				priority_m2p(unsigned long x)
{	switch(x){
		case	0:		return( 15);	//TimeCritical
		case	1:		return(  2);	//Highest
		case	2:		return(  1);	//High
		default:
		case	3:		return(  0);	//Normal
		case	4:		return( -1);	//Low
		case	5:		return( -2);	//Lowest
		case	6:		return(-15);	//Idle
	}
}



void			priority_swm(	unsigned long	trd,
								int				pri,
								HMENU			hmenu,
								unsigned long	idm_start)
{
	if(trd>=TRD_MAX)		return;				//invalid trd
	if((pri>15)||(pri<-15))	return;

	SetThreadPriority(trdh[trd],pri);
	CheckMenuRadioItem(hmenu,	idm_start,
								idm_start+6,
								idm_start+priority_p2m(pri),MF_BYCOMMAND);
}



void	priority_constructor(void)
{
	priority_swm(	TRD_MC68K,
					GetPrivateProfileInt("priority","m68k",0,path_inifile),
					hmenu_priority_m68k,
					IDM_M68K_P3);
	priority_swm(	TRD_RTI,
					GetPrivateProfileInt("priority","rti",0,path_inifile),
					hmenu_priority_rti,
					IDM_RTI_P3);
}



void	priority_destructor(void)
{	char			buf[0x100];

	sprintf(buf,"%2d",GetThreadPriority(trdh[TRD_MC68K]));
	WritePrivateProfileString("priority","m68k",buf,path_inifile);
	sprintf(buf,"%2d",GetThreadPriority(trdh[TRD_RTI]));
	WritePrivateProfileString("priority","rti",buf,path_inifile);
}
