#include	<windows.h>
#include	"../cpu/mc68k/mc68k.h"
#include	"../device/memory/memory.h"
#include	"../device/_e8/_e8.h"
#include	"../device/mfp/mfp.h"

		MEMORY				main( 0x00100000,0);
		MEMORY				vram( 0x00280000,0);
		MEMORY				sram( 0x00010000,0);
		MEMORY				cg(   0x000c0000,0);
		MEMORY				boot( 0x00020000,0);

		MC68K				m68k;

		_E8					_e8;
		MFP					mfp;



		void				mem_bind(void);
		void				mem_unbind(void);
		void				bind(unsigned char,unsigned short,unsigned short,
								 unsigned long,unsigned long,DEVICE *,
#ifdef	DYNAMIC_RECOMPILE
								 unsigned char *,unsigned char *);
#else
								 unsigned char *);
#endif



void	mem_bind(void)
{	unsigned long	x,y;

/******************************************************************************
	MC68K
******************************************************************************/

#ifdef	DYNAMIC_RECOMPILE
bind(0,0x0000,    16,MAT_RAM,   0x0000ffff,&main,	main.mem,	main.drc);
bind(0,0x00c0,  0x28,MAT_RAM,   0x0000ffff,&vram,	vram.mem,	vram.drc);
bind(0,0x00e8,     1,MAT_DEVICE,0x0000ffff,&_e8,	NULL,		NULL);
bind(0,0x00ed,     1,MAT_RAM,   0x0000ffff,&sram,	sram.mem,	sram.drc);
bind(0,0x00f0,   0xc,MAT_ROM,   0x0000ffff,&cg,		cg.mem,		cg.drc);
bind(0,0x00fe,     2,MAT_ROM,   0x0000ffff,&boot,	boot.mem,	boot.drc);
#else
bind(0,0x0000,    16,MAT_RAM,   0x0000ffff,&main,	main.mem);
bind(0,0x00c0,  0x28,MAT_RAM,   0x0000ffff,&vram,	vram.mem);
bind(0,0x00e8,     1,MAT_DEVICE,0x0000ffff,&_e8,	NULL);
bind(0,0x00ed,     1,MAT_RAM,   0x0000ffff,&sram,	sram.mem);
bind(0,0x00f0,   0xc,MAT_ROM,   0x0000ffff,&cg,		cg.mem);
bind(0,0x00fe,     2,MAT_ROM,   0x0000ffff,&boot,	boot.mem);
#endif

for(x=0;x!=0x100;x++)
	for(y=0;y!=0x100;y++)
		m68k.mat[(x<<8)+y]=	m68k.mat[y];
}





void	bind(	unsigned char	cpu,
				unsigned short	index,
				unsigned short	length,
				unsigned long	type,
				unsigned long	mask,
				DEVICE *		device,
#ifdef	DYNAMIC_RECOMPILE
				unsigned char *	mem,
				unsigned char *	drc		)
#else
				unsigned char *	mem		)
#endif
{
	unsigned long	x;

	switch(cpu){
		case	0:												//MC68K
					m68k.mat[index].type	=type;
					m68k.mat[index].mask	=mask;
					m68k.mat[index].device	=device;
					m68k.mat[index].mem		=mem;
#ifdef	DYNAMIC_RECOMPILE
					m68k.mat[index].drc		=drc;
#endif

			if(length!=1)
				for(x=1;x!=length;x++){
					m68k.mat[index+x]		=m68k.mat[index];
#ifdef	DYNAMIC_RECOMPILE
					m68k.mat[index+x].drc	+=0x10000*x*DRC_UNIT;
#endif
					m68k.mat[index+x].mem	+=0x10000*x;	}
			break;
	}
}
