#ifdef	_DEBUG

#include	<stdio.h>
#include	"mc68k.h"
#include	"../../window/console/console.h"

extern	CONSOLE	con;



void			MC68K::reg_stat(void)
{
	char			buf[0x100];
	unsigned long	p;

	sprintf(buf,"D0 =%08X D1 =%08X D2 =%08X D3 =%08X PC =%08X\n",
		r[D0],r[D1],r[D2],r[D3],r[PC]);		CO(buf);
	sprintf(buf,"D4 =%08X D5 =%08X D6 =%08X D7 =%08X\n",
		r[D4],r[D5],r[D6],r[D7]);			CO(buf);
	sprintf(buf,"A0 =%08X A1 =%08X A2 =%08X A3 =%08X SSP=%08X\n",
		r[A0],r[A1],r[A2],r[A3],r[SSP]);	CO(buf);
	sprintf(buf,"A4 =%08X A5 =%08X A6 =%08X A7 =%08X USP=%08X\n",
		r[A4],r[A5],r[A6],r[A7],r[USP]);	CO(buf);
	sprintf(buf,"         T S  <I>   XNZVC\nSR =%04X ",
		r[SR]);			CO(buf);
	for(p=0;p!=16;p++)	if((r[SR]>>(15-p))&1)	buf[p]='1';
							else				buf[p]='0';
	buf[p]=NULL;								CO(buf);
	sprintf(buf,"          VSR =%04X\n",r[VSR]);	CO(buf);
}



void			MC68K::mem_dump(unsigned long addr)
{
	unsigned long	x,y;
	char			buf[0x100];
	char			asc[0x100];

	sprintf(buf,"%08X +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F "
		"0123456789ABCDEF\n",addr);	CO(buf);

	for(y=0;y!=16;y++){
		sprintf(buf,"%08X ",y*16+addr);	CO(buf);

		for(x=0;x!=16;x++){
			asc[x]=r1(addr+y*16+x);
			sprintf(buf+x*3,"%02X ",(unsigned char)asc[x]);	}
		CO(buf);
		asc[16]=NULL;	asc[17]=NULL;
		for(x=0;x<=16;){
			if((0x81<=asc[x])&&(0xfc>=asc[x])&&(0x9f>=asc[x])||(0xe0<=asc[x]))
				if((0x40<=asc[x+1])&&(0xfc>=asc[x+1]))	x+=2;
				else{	asc[x]='.';	x++;	}
			else{	if(!isgraph(0x000000ff&(int)asc[x]))	asc[x]='.';
					x++;													}
		}
		asc[16]=NULL;	asc[17]=NULL;	CO(asc);	CO("\n");
	}
}



void	MC68K::dump2file(unsigned long start,unsigned long end,char *fname)
{
	HANDLE			hDUMP;
	unsigned long	tl1,tl2;
	unsigned char	tc;

	hDUMP=CreateFile(fname,GENERIC_WRITE,0,0,CREATE_ALWAYS,
										FILE_ATTRIBUTE_NORMAL,0);
	if(hDUMP==(void *)-1){	CO("may be invalid filename\n");	return;	}
	if(start>end){	tl1=start;	start=end;	end=tl1;	}
	for(tl1=start;tl1<end;tl1++){
		tc=r1(tl1);
		WriteFile(hDUMP,&tc,1,&tl2,NULL);	}
	CloseHandle(hDUMP);
}



void			MC68K::er1(unsigned char reg,unsigned char  data){}
void			MC68K::er2(unsigned char reg,unsigned short data){}
void			MC68K::er4(unsigned char reg,unsigned long  data)
{	r[reg]=data;	}

void			MC68K::em1(unsigned long addr,unsigned char  data)
{	w1(addr,data);	}
void			MC68K::em2(unsigned long addr,unsigned short data)
{	w2(addr,data);	}
void			MC68K::em4(unsigned long addr,unsigned long  data)
{	w4(addr,data);	}

#endif	_DEBUG
