//	MC68K code ORI

case	0x0000:		//byte size , data regster direct
	DD1;	sprintf(buf,"ORI.B #$%02X,D%d\n",dnm1(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0010:		//byte size , mem addr
	DD1;	sprintf(buf,"ORI.B #$%02X,(A%d)\n",dnm1(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0018:		//byte size , mem addr ,postinc
	DD1;	sprintf(buf,"ORI.B #$%02X,(A%d)+\n",dnm1(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0020:		//byte size , mem addr ,pridec
	DD1;	sprintf(buf,"ORI.B #$%02X,-(A%d)\n",dnm1(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0028:		//byte size , mem addr with disp
	DD2;	sprintf(buf,"ORI.B #$%02X,$%04X(A%d)\n",
											dnm1(1),dnm2(2),RN1);	CO(buf);
	r[DPC]+=6;	return;
case	0x0030:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"ORI.B #$%02X,$%02X(A%d,X%d)\n",
										dnm1(1),dnm1(2),RN1,RN3);	CO(buf);
	r[DPC]+=6;	return;

case	0x0038:				//byte size , abs
	switch(RN1){
		case	0:
			DD2;	sprintf(buf,"ORI.B #$%02X,$%04X\n",
												dnm1(1),dnm2(2));	CO(buf);
			r[DPC]+=6;	return;
		case	1:
			DD3;	sprintf(buf,"ORI.B #$%02X,$%08X\n",
												dnm1(1),dnm4(2));	CO(buf);
			r[DPC]+=8;	return;
		case	4:		//ORI to CCR
			DD1;	sprintf(buf,"ORI #$%02X,CCR\n",dnm1(1));	CO(buf);
			r[DPC]+=4;	return;
		default:	DD0;	CO("???\n");	r[DPC]+=2;	return;
	}



case	0x0040:		//word size , data regster direct
	DD1;	sprintf(buf,"ORI.W #$%04X,D%d\n",dnm2(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0050:		//mem addr
	DD1;	sprintf(buf,"ORI.W #$%04X,(A%d)\n",dnm2(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0058:		//mem addr ,postinc
	DD1;	sprintf(buf,"ORI.W #$%04X,(A%d)+\n",dnm2(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0060:		//mem addr ,pridec
	DD1;	sprintf(buf,"ORI.W #$%04X,-(A%d)\n",dnm2(1),RN1);	CO(buf);
	r[DPC]+=4;	return;
case	0x0068:		//mem addr with disp
	DD2;	sprintf(buf,"ORI.W #$%04X,$%04X(A%d)\n",
											dnm2(1),dnm2(2),RN1);	CO(buf);
	r[DPC]+=6;	return;
case	0x0070:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"ORI.W #$%04X,$%02X(A%d,X%d)\n",
										dnm2(1),dnm1(2),RN1,RN3);	CO(buf);
	r[DPC]+=6;	return;

case	0x0078:				//abs
	switch(RN1){
		case	0:		//word size
			DD2;	sprintf(buf,"ORI.W #$%04X,$%04X\n",
												dnm2(1),dnm2(2));	CO(buf);
			r[DPC]+=6;	return;
		case	1:		//long size
			DD3;	sprintf(buf,"ORI.W #$%04X,$%08X\n",
												dnm2(1),dnm4(2));	CO(buf);
			r[DPC]+=8;	return;
		case	4:		//ORI to r[SR]
			DD1;	sprintf(buf,"ORI #$%04X,r[SR]\n",dnm2(1));	CO(buf);
			r[DPC]+=4;	return;
		default:	DD0;	CO("???\n");	r[DPC]+=2;	return;
	}



case	0x0080:		//long size , data regster direct
	DD2;	sprintf(buf,"ORI.L #$%08X,D%d\n",dnm4(1),RN1);	CO(buf);
	r[DPC]+=6;	return;
case	0x0090:		//mem addr
	DD2;	sprintf(buf,"ORI.L #$%08X,(A%d)\n",dnm4(1),RN1);	CO(buf);
	r[DPC]+=6;	return;
case	0x0098:		//mem addr ,postinc
	DD2;	sprintf(buf,"ORI.L #$%08X,(A%d)+\n",dnm4(1),RN1);	CO(buf);
	r[DPC]+=6;	return;
case	0x00a0:		//mem addr ,pridec
	DD2;	sprintf(buf,"ORI.L #$%08X,-(A%d)\n",dnm4(1),RN1);	CO(buf);
	r[DPC]+=6;	return;
case	0x00a8:		//mem addr with disp
	DD3;	sprintf(buf,"ORI.L #$%08X,$%04X(A%d)\n",
											dnm4(1),dnm2(3),RN1);	CO(buf);
	r[DPC]+=8;	return;
case	0x00b0:		//byte size , mem addr with index
	RN3=(dnm2(3)>>12)&15;	//index
	DD3;	sprintf(buf,"ORI.L #$%08X,$%02X(A%d,X%d)\n",
										dnm4(1),dnm1(3),RN1,RN3);	CO(buf);
	r[DPC]+=8;	return;

case	0x00b8:				//abs
	switch(RN1){
		case	0:		//word size
			DD3;	sprintf(buf,"ORI.L #$%08X,$%04X\n",
												dnm4(1),dnm2(3));	CO(buf);
			r[DPC]+=8;	return;
		case	1:		//long size
			DD4;	sprintf(buf,"ORI.L #$%08X,$%08X\n",
												dnm4(1),dnm4(3));	CO(buf);
			r[DPC]+=10;	return;
		default:	DD0;	CO("???\n");	r[DPC]+=2;	return;
	}
