//	MC68K code AND



case	0x0000:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.B D%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN1];
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
	r[PC]+=2;	return;



case	0x0010:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.B (A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
	r[PC]+=2;	return;




case	0x0018:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.B (A%d)+,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
	r[A0+RN1]++;
	r[PC]+=2;	return;



case	0x0020:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.B -(A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TC1=r1(r[A0+RN1]);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
	r[PC]+=2;	return;



case	0x0028:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]+(short)num2(1));
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
	r[PC]+=4;	return;



case	0x0030:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TC1=r1(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TC1=r1(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
	r[PC]+=4;	return;



case	0x0038:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B $%04X,D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
			TC1=r1((short)num2(1));
			TC2=(unsigned char)r[D0+RN2];
			TC3=TC1&TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC3==0)			r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"AND.B $%08X,D%d\n",
	num4(1),RN1,RN2);	CO(buf);	}
#endif
			TC1=r1(num4(1));
			TC2=(unsigned char)r[D0+RN2];
			TC3=TC1&TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC3==0)			r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B $%04X(PC),D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TC1=r1(r[PC]+(short)num2(1)+2);
			TC2=(unsigned char)r[D0+RN2];
			TC3=TC1&TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC3==0)			r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			if((num2(1)&0x0800)==0)
					TC1=r1(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TC1=r1(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TC2=(unsigned char)r[D0+RN2];
			TC3=TC1&TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC3==0)			r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B #$%02X,D%d\n",
	num1(1),RN2);	CO(buf);	}
#endif
			TC1=num1(1);
			TC2=(unsigned char)r[D0+RN2];
			TC3=TC1&TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC3==0)			r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffffff00)|TC3;
			r[PC]+=4;	return;

		default:
			gic();	return;
	}





case	0x0040:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.W D%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN1];
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
	r[PC]+=2;	return;



case	0x0050:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.W (A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
	r[PC]+=2;	return;




case	0x0058:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.W (A%d)+,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x0060:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.W -(A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=r2(r[A0+RN1]);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
	r[PC]+=2;	return;



case	0x0068:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]+(short)num2(1));
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
	r[PC]+=4;	return;



case	0x0070:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TS1=r2(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TS1=r2(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
	r[PC]+=4;	return;



case	0x0078:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W $%04X,D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
			TS1=r2((short)num2(1));
			TS2=(unsigned short)r[D0+RN2];
			TS3=TS1&TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS3==0)			r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"AND.W $%08X,D%d\n",
	num4(1),RN1,RN2);	CO(buf);	}
#endif
			TS1=r2(num4(1));
			TS2=(unsigned short)r[D0+RN2];
			TS3=TS1&TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS3==0)			r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W $%04X(PC),D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=r2(r[PC]+(short)num2(1)+2);
			TS2=(unsigned short)r[D0+RN2];
			TS3=TS1&TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS3==0)			r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			if((num2(1)&0x0800)==0)
					TS1=r2(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TS1=r2(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TS2=(unsigned short)r[D0+RN2];
			TS3=TS1&TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS3==0)			r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W #$%04X,D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=num2(1);
			TS2=(unsigned short)r[D0+RN2];
			TS3=TS1&TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS3==0)			r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=(r[D0+RN2]&0xffff0000)|TS3;
			r[PC]+=4;	return;

		default:
			gic();	return;
	}





case	0x0080:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.L D%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=2;	return;



case	0x0090:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.L (A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=2;	return;




case	0x0098:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.L (A%d)+,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[A0+RN1]+=4;
	r[PC]+=2;	return;



case	0x00a0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.L -(A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]-=4;
	TL1=r4(r[A0+RN1]);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=2;	return;



case	0x00a8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]+(short)num2(1));
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=4;	return;



case	0x00b0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TL1=r4(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TL1=r4(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=4;	return;



case	0x00b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L $%04X,D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
			TL1=r4((short)num2(1));
			TL2=r[D0+RN2];
			TL3=TL1&TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"AND.L $%08X,D%d\n",
	num4(1),RN1,RN2);	CO(buf);	}
#endif
			TL1=r4(num4(1));
			TL2=r[D0+RN2];
			TL3=TL1&TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L $%04X(PC),D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TL1=r4(r[PC]+(short)num2(1)+2);
			TL2=r[D0+RN2];
			TL3=TL1&TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			if((num2(1)&0x0800)==0)
					TL1=r4(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TL1=r4(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TL2=r[D0+RN2];
			TL3=TL1&TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"AND.L #$%08X,D%d\n",
	num4(1),RN2);	CO(buf);	}
#endif
			TL1=num4(1);
			TL2=r[D0+RN2];
			TL3=TL1&TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=6;	return;

		default:
			gic();	return;
	}





case	0x0110:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.B D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TC1=r1(TR1);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	w1(TR1,TC3);
	r[PC]+=2;	return;



case	0x0118:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.B D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TC1=r1(TR1);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	w1(TR1,TC3);
	r[A0+RN1]++;
	r[PC]+=2;	return;



case	0x0120:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.B D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TR1=r[A0+RN1];
	TC1=r1(TR1);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	w1(TR1,TC3);
	r[PC]+=2;	return;



case	0x0128:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TC1=r1(TR1);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	w1(TR1,TC3);
	r[PC]+=4;	return;



case	0x0130:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];
	TC1=r1(TR1);
	TC2=(unsigned char)r[D0+RN2];
	TC3=TC1&TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC3==0)			r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

	w1(TR1,TC3);
	r[PC]+=4;	return;



case	0x0138:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.B D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TR1=(short)num2(1);
			TC1=r1(TR1);
			TC2=(unsigned char)r[D0+RN2];
			TC3=TC1&TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC3==0)			r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

			w1(TR1,TC3);
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"AND.B D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TR1=num4(1);
			TC1=r1(TR1);
			TC2=(unsigned char)r[D0+RN2];
			TC3=TC1&TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC3==0)			r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)	r[SR]|=CCR_NON;

			w1(TR1,TC3);
			r[PC]+=6;	return;

		default:
			gic();	return;
	}





case	0x0150:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.W D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(TR1,TS3);
	r[PC]+=2;	return;



case	0x0158:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.W D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(TR1,TS3);
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x0160:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.W D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TR1=r[A0+RN1];
	TS1=r2(TR1);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(TR1,TS3);
	r[PC]+=2;	return;



case	0x0168:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TS1=r2(TR1);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(TR1,TS3);
	r[PC]+=4;	return;



case	0x0170:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];
	TS1=r2(TR1);
	TS2=(unsigned short)r[D0+RN2];
	TS3=TS1&TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS3==0)			r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

	w2(TR1,TS3);
	r[PC]+=4;	return;



case	0x0178:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.W D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TR1=(short)num2(1);
			TS1=r2(TR1);
			TS2=(unsigned short)r[D0+RN2];
			TS3=TS1&TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS3==0)			r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

			w2(TR1,TS3);
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"AND.W D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TR1=num4(1);
			TS1=r2(TR1);
			TS2=(unsigned short)r[D0+RN2];
			TS3=TS1&TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS3==0)			r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)	r[SR]|=CCR_NON;

			w2(TR1,TS3);
			r[PC]+=6;	return;

		default:
			gic();	return;
	}





case	0x0190:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.L D%d,(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TL1=r4(TR1);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(TR1,TL3);
	r[PC]+=2;	return;



case	0x0198:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.L D%d,(A%d)+\n",
	RN2,RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1];
	TL1=r4(TR1);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(TR1,TL3);
	r[A0+RN1]+=4;
	r[PC]+=2;	return;



case	0x01a0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"AND.L D%d,-(A%d)\n",
	RN2,RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=4;
	TR1=r[A0+RN1];
	TL1=r4(TR1);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(TR1,TL3);
	r[PC]+=2;	return;



case	0x01a8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO(buf);	}
#endif
	TR1=r[A0+RN1]+(short)num2(1);
	TL1=r4(TR1);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(TR1,TL3);
	r[PC]+=4;	return;



case	0x01b0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3];
	else	TR1=r[A0+RN1]+(char)num1(1)+       r[D0+RN3];
	TL1=r4(TR1);
	TL2=r[D0+RN2];
	TL3=TL1&TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	w4(TR1,TL3);
	r[PC]+=4;	return;



case	0x01b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"AND.L D%d,$%04X\n",
	RN2,num2(1));	CO(buf);	}
#endif
			TR1=(short)num2(1);
			TL1=r4(TR1);
			TL2=r[D0+RN2];
			TL3=TL1&TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			w4(TR1,TL3);
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"AND.L D%d,$%08X\n",
	RN2,num4(1));	CO(buf);	}
#endif
			TR1=num4(1);
			TL1=r4(TR1);
			TL2=r[D0+RN2];
			TL3=TL1&TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			w4(TR1,TL3);
			r[PC]+=6;	return;

		default:
			gic();	return;
	}
