//	MC68K code CMP



case	0x0000:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.B D%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2];
	TC2=(unsigned char)r[D0+RN1];
	TC3=TC1-TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC3>TC1){			r[SR]|=CCR_CON;
							r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0010:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.B (A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2];
	TC2=r1(r[A0+RN1]);
	TC3=TC1-TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC3>TC1){			r[SR]|=CCR_CON;
							r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0018:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.B (A%d)+,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2];
	TC2=r1(r[A0+RN1]);
	TC3=TC1-TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC3>TC1){			r[SR]|=CCR_CON;
							r[SR]|=CCR_XON;	}

	r[A0+RN1]++;
	r[PC]+=2;	return;



case	0x0020:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.B -(A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TC1=(unsigned char)r[D0+RN2];
	TC2=r1(r[A0+RN1]);
	TC3=TC1-TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC3>TC1){			r[SR]|=CCR_CON;
							r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0028:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.B $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2];
	TC2=r1(r[A0+RN1]+(short)num2(1));
	TC3=TC1-TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC3>TC1){			r[SR]|=CCR_CON;
							r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x0030:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.B $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN2];
	if((num2(1)&0x0800)==0)
			TC2=r1(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TC2=r1(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TC3=TC1-TC2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC3==0)				r[SR]|=CCR_ZON;
	if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
		else
	if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC3>TC1){			r[SR]|=CCR_CON;
							r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x0038:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.B $%04X,D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
			TC1=(unsigned char)r[D0+RN2];
			TC2=r1((short)num2(1));
			TC3=TC1-TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TC3==0)				r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
				else
			if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
			if(TC3>TC1){			r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMP.B $%08X,D%d\n",
	num4(1),RN1,RN2);	CO(buf);	}
#endif
			TC1=(unsigned char)r[D0+RN2];
			TC2=r1(num4(1));
			TC3=TC1-TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TC3==0)				r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
				else
			if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
			if(TC3>TC1){			r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.B $%04X(PC),D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TC1=(unsigned char)r[D0+RN2];
			TC2=r1(r[PC]+(short)num2(1)+2);
			TC3=TC1-TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TC3==0)				r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
				else
			if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
			if(TC3>TC1){			r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.B $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			TC1=(unsigned char)r[D0+RN2];
			if((num2(1)&0x0800)==0)
					TC2=r1(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TC2=r1(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TC3=TC1-TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TC3==0)				r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
				else
			if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
			if(TC3>TC1){			r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.B #$%02X,D%d\n",
	num1(1),RN2);	CO(buf);	}
#endif
			TC1=(unsigned char)r[D0+RN2];
			TC2=num1(1);
			TC3=TC1-TC2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TC3==0)				r[SR]|=CCR_ZON;
			if((TC3&0x80)!=0)		r[SR]|=CCR_NON;
				else
			if(((TC1^TC2)&0x80)!=0)	r[SR]|=CCR_VON;
			if(TC3>TC1){			r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		default:
			gic();	return;
	}





case	0x0040:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.W D%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2];
	TS2=(unsigned short)r[D0+RN1];
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0048:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.W A%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2];
	TS2=(unsigned short)r[A0+RN1];
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0050:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.W (A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2];
	TS2=r2(r[A0+RN1]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0058:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.W (A%d)+,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2];
	TS2=r2(r[A0+RN1]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x0060:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.W -(A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=(unsigned short)r[D0+RN2];
	TS2=r2(r[A0+RN1]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0068:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.W $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2];
	TS2=r2(r[A0+RN1]+(short)num2(1));
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x0070:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.W $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN2];
	if((num2(1)&0x0800)==0)
			TS2=r2(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TS2=r2(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x0078:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.W $%04X,D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[D0+RN2];
			TS2=r2((short)num2(1));
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMP.W $%08X,D%d\n",
	num4(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[D0+RN2];
			TS2=r2(num4(1));
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.W $%04X(PC),D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[D0+RN2];
			TS2=r2(r[PC]+(short)num2(1)+2);
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.W $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[D0+RN2];
			if((num2(1)&0x0800)==0)
					TS2=r2(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TS2=r2(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.W #$%04X,D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[D0+RN2];
			TS2=num2(1);
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		default:
			gic();	return;
	}





case	0x0080:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.L D%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[D0+RN2];
	TL2=r[D0+RN1];
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0088:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.L A%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[D0+RN2];
	TL2=r[A0+RN1];
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0090:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.L (A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[D0+RN2];
	TL2=r4(r[A0+RN1]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x0098:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.L (A%d)+,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[D0+RN2];
	TL2=r4(r[A0+RN1]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[A0+RN1]+=4;
	r[PC]+=2;	return;



case	0x00a0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMP.L -(A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]-=4;
	TL1=r[D0+RN2];
	TL2=r4(r[A0+RN1]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x00a8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.L %04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TL1=r[D0+RN2];
	TL2=r4(r[A0+RN1]+(short)num2(1));
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x00b0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.L %02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	TL1=r[D0+RN2];
	if((num2(1)&0x0800)==0)
			TL2=r4(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TL2=r4(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x00b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.L $%04X,D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TL1=r[D0+RN2];
			TL2=r4((short)num2(1));
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMP.L $%08X,D%d\n",
	num4(1),RN2);	CO(buf);	}
#endif
			TL1=r[D0+RN2];
			TL2=r4(num4(1));
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.L %04X(PC),D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TL1=r[D0+RN2];
			TL2=r4(r[PC]+(short)num2(1)+2);
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMP.L %02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			TL1=r[D0+RN2];
			if((num2(1)&0x0800)==0)
					TL2=r4(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TL2=r4(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMP.L #$%08X,D%d\n",
	num4(1),RN2);	CO(buf);	}
#endif
			TL1=r[D0+RN2];
			TL2=num4(1);
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=6;	return;



		default:
			gic();	return;
	}





