//	MC68K code CMPA



case	0x00c0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.W D%d,A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[A0+RN2];
	TS2=(unsigned short)r[D0+RN1];
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x00c8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.W A%d,A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[A0+RN2];
	TS2=(unsigned short)r[A0+RN1];
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x00d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.W (A%d),A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[A0+RN2];
	TS2=(short)r2(r[A0+RN1]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x00d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.W (A%d)+,A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[A0+RN2];
	TS2=(short)r2(r[A0+RN1]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x00e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.W -(A%d),A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=(unsigned short)r[A0+RN2];
	TS2=(short)r2(r[A0+RN1]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x00e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.W $%04X(A%d),A%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[A0+RN2];
	TS2=(short)r2(r[A0+RN1]+(short)num2(1));
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x00f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.W $%02X(A%d,X%d),A%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[A0+RN2];
	if((num2(1)&0x0800)==0)
			TS2=(short)r2(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TS2=(short)r2(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TS3=TS1-TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS3==0)					r[SR]|=CCR_ZON;
	if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS3>TS1){				r[SR]|=CCR_CON;
								r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x00f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.W $%04X,A%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[A0+RN2];
			TS2=(short)r2((short)num2(1));
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPA.W $%08X,A%d\n",
	num4(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[A0+RN2];
			TS2=(short)r2(num4(1));
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.W $%04X(PC),A%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[A0+RN2];
			TS2=(short)r2(r[PC]+(short)num2(1)+2);
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.W $%02X(PC,X%d),A%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[A0+RN2];
			if((num2(1)&0x0800)==0)
					TS2=(short)r2(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TS2=(short)r2(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.W #$%04X,A%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=(unsigned short)r[A0+RN2];
			TS2=(short)r2((short)num2(1));
			TS3=TS1-TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS3==0)					r[SR]|=CCR_ZON;
			if((TS3&0x8000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TS1^TS2)&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS3>TS1){				r[SR]|=CCR_CON;
										r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		default:
			gic();	return;
	}





case	0x01c0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.L D%d,A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[A0+RN2];
	TL2=r[D0+RN1];
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x01c8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.L A%d,A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[A0+RN2];
	TL2=r[A0+RN1];
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x01d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.L (A%d),A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[A0+RN2];
	TL2=r4(r[A0+RN1]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x01d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.L (A%d)+,A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TL1=r[A0+RN2];
	TL2=r4(r[A0+RN1]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x01e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"CMPA.L -(A%d),A%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TL1=r[A0+RN2];
	TL2=r4(r[A0+RN1]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=2;	return;



case	0x01e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.L $%04X(A%d),A%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TL1=r[A0+RN2];
	TL2=r4(r[A0+RN1]+(short)num2(1));
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x01f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.L $%02X(A%d,X%d),A%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	TL1=r[A0+RN2];
	if((num2(1)&0x0800)==0)
			TL2=r4(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TL2=r4(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TL3=TL1-TL2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL3==0)						r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
		else
	if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL3>TL1){					r[SR]|=CCR_CON;
									r[SR]|=CCR_XON;	}

	r[PC]+=4;	return;



case	0x01f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.L $%04X,A%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TL1=r[A0+RN2];
			TL2=r4((short)num2(1));
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPA.L $%08X,A%d\n",
	num4(1),RN2);	CO(buf);	}
#endif
			TL1=r[A0+RN2];
			TL2=r4(num4(1));
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.L $%04X(PC),A%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TL1=r[A0+RN2];
			TL2=r4(r[PC]+(short)num2(1)+2);
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPA.L $%02X(PC,X%d),A%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			TL1=r[A0+RN2];
			if((num2(1)&0x0800)==0)
					TL2=r4(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TL2=r4(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPA.L #$%08X,A%d\n",
	num4(1),RN2);	CO(buf);	}
#endif
			TL1=r[A0+RN2];
			TL2=num4(1);
			TL3=TL1-TL2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL3==0)						r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)			r[SR]|=CCR_NON;
				else
			if(((TL1^TL2)&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL3>TL1){					r[SR]|=CCR_CON;
											r[SR]|=CCR_XON;	}

			r[PC]+=6;	return;



		default:
			gic();	return;
	}



