//	MC68K code CMPI



case	0x0c00:		//byte size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.B #$%02X,D%d\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=(unsigned char)r[D0+RN1];
	TC2=TC1-num1(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)					r[SR]|=CCR_ZON;
	if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC2>TC1)					r[SR]|=CCR_CON;

	r[PC]+=4;	return;



case	0x0c10:		//byte size , mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.B #$%02X,(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]);
	TC2=TC1-num1(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)					r[SR]|=CCR_ZON;
	if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC2>TC1)					r[SR]|=CCR_CON;

	r[PC]+=4;	return;



case	0x0c18:		//byte size , mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.B #$%02X,(A%d)+\n",
	num1(1),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]);
	TC2=TC1-num1(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)					r[SR]|=CCR_ZON;
	if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC2>TC1)					r[SR]|=CCR_CON;

	r[A0+RN1]++;
	r[PC]+=4;	return;



case	0x0c20:		//byte size , mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.B #$%02X,-(A%d)\n",
	num1(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]--;
	TC1=r1(r[A0+RN1]);
	TC2=TC1-num1(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)					r[SR]|=CCR_ZON;
	if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC2>TC1)					r[SR]|=CCR_CON;

	r[PC]+=4;	return;



case	0x0c28:		//byte size , mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.B #$%02X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO(buf);	}
#endif
	TC1=r1(r[A0+RN1]+(short)num2(2));
	TC2=TC1-num1(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)					r[SR]|=CCR_ZON;
	if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC2>TC1)					r[SR]|=CCR_CON;

	r[PC]+=6;	return;



case	0x0c30:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.B #$%02X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp
	TC1=r1(TR1);
	TC2=TC1-num1(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)					r[SR]|=CCR_ZON;
	if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
	if(TC2>TC1)					r[SR]|=CCR_CON;

	r[PC]+=6;	return;



case	0x0c38:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.B #$%02X,$%04X\n",
	num1(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			TC1=r1(TR1);
			TC2=TC1-num1(1);

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC2==0)					r[SR]|=CCR_ZON;
			if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
				else
			if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
			if(TC2>TC1)					r[SR]|=CCR_CON;

			r[PC]+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"CMPI.B #$%02X,$%08X\n",
	num1(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			TC1=r1(TR1);
			TC2=TC1-num1(1);

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC2==0)					r[SR]|=CCR_ZON;
			if((TC2&0x80)!=0)			r[SR]|=CCR_NON;
				else
			if(((TC1^num1(1))&0x80)!=0)	r[SR]|=CCR_VON;
			if(TC2>TC1)					r[SR]|=CCR_CON;

			r[PC]+=8;	return;



		default:
			gic();	return;
	}





case	0x0c40:		//word size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.W #$%04X,D%d\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN1];
	TS2=TS1-num2(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS2==0)						r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS2>TS1)						r[SR]|=CCR_CON;

	r[PC]+=4;	return;



case	0x0c50:		//mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.W #$%04X,(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=TS1-num2(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS2==0)						r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS2>TS1)						r[SR]|=CCR_CON;

	r[PC]+=4;	return;



case	0x0c58:		//mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.W #$%04X,(A%d)+\n",
	num2(1),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=TS1-num2(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS2==0)						r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS2>TS1)						r[SR]|=CCR_CON;

	r[A0+RN1]+=2;
	r[PC]+=4;	return;



case	0x0c60:		//mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"CMPI.W #$%04X,-(A%d)\n",
	num2(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=r2(r[A0+RN1]);
	TS2=TS1-num2(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS2==0)						r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS2>TS1)						r[SR]|=CCR_CON;

	r[PC]+=4;	return;



case	0x0c68:		//mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.W #$%04X,$%04X(A%d)\n",
	num2(1),num2(2),RN1);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]+(short)num2(2));
	TS2=TS1-num2(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS2==0)						r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS2>TS1)						r[SR]|=CCR_CON;

	r[PC]+=4;	return;



case	0x0c70:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.W #$%04X,$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN1,RN3);	CO(buf);	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(2)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(2)+       r[D0+RN3];	//32bitgp
	TS1=r2(TR1);
	TS2=TS1-num2(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS2==0)						r[SR]|=CCR_ZON;
	if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
	if(TS2>TS1)						r[SR]|=CCR_CON;

	r[PC]+=6;	return;



case	0x0c78:				//abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.W #$%04X,$%04X\n",
	num2(1),num2(2));	CO(buf);	}
#endif
			TR1=(short)num2(2);
			TS1=r2(TR1);
			TS2=TS1-num2(1);

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS2==0)						r[SR]|=CCR_ZON;
			if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
				else
			if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS2>TS1)						r[SR]|=CCR_CON;

			r[PC]+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"CMPI.W #$%04X,$%08X\n",
	num2(1),num4(2));	CO(buf);	}
#endif
			TR1=num4(2);
			TS1=r2(TR1);
			TS2=TS1-num2(1);

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS2==0)						r[SR]|=CCR_ZON;
			if((TS2&0x8000)!=0)				r[SR]|=CCR_NON;
				else
			if(((TS1^num2(1))&0x8000)!=0)	r[SR]|=CCR_VON;
			if(TS2>TS1)						r[SR]|=CCR_CON;

			r[PC]+=8;	return;



		default:
			gic();	return;
	}





case	0x0c80:		//long size , data regster direct
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.L #$%08X,D%d\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r[D0+RN1];
	TL2=TL1-num4(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL2==0)							r[SR]|=CCR_ZON;
	if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TL2^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL2>TL1)							r[SR]|=CCR_CON;

	r[PC]+=6;	return;



case	0x0c90:		//mem addr
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.L #$%08X,(A%d)\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]);
	TL2=TL1-num4(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL2==0)							r[SR]|=CCR_ZON;
	if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL2>TL1)							r[SR]|=CCR_CON;

	r[PC]+=6;	return;



case	0x0c98:		//mem addr ,postinc
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.L #$%08X,(A%d)+\n",
	num4(1),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]);
	TL2=TL1-num4(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL2==0)							r[SR]|=CCR_ZON;
	if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL2>TL1)							r[SR]|=CCR_CON;

	r[A0+RN1]+=4;
	r[PC]+=6;	return;



case	0x0ca0:		//mem addr ,pridec
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"CMPI.L #$%08X,-(A%d)\n",
	num4(1),RN1);	CO(buf);	}
#endif
	r[A0+RN1]-=4;
	TL1=r4(r[A0+RN1]);
	TL2=TL1-num4(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL2==0)							r[SR]|=CCR_ZON;
	if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL2>TL1)							r[SR]|=CCR_CON;

	r[PC]+=6;	return;



case	0x0ca8:		//mem addr with disp
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"CMPI.L #$%08X,$%04X(A%d)\n",
	num4(1),num2(3),RN1);	CO(buf);	}
#endif
	TL1=r4(r[A0+RN1]+(short)num2(3));
	TL2=TL1-num4(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL2==0)							r[SR]|=CCR_ZON;
	if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL2>TL1)							r[SR]|=CCR_CON;

	r[PC]+=8;	return;



case	0x0cb0:		//byte size , mem addr with index
	RN3=(num2(3)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"CMPI.L #$%08X,$%02X(A%d,X%d)\n",
	num4(1),num1(3),RN1,RN3);	CO(buf);	}
#endif
	if((num2(3)&0x0800)==0)
				TR1=r[A0+RN1]+(char)num1(3)+(short)r[D0+RN3];	//16bitg
		else	TR1=r[A0+RN1]+(char)num1(3)+       r[D0+RN3];	//32bitgp
	TL1=r4(TR1);
	TL2=TL1-num4(1);

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL2==0)							r[SR]|=CCR_ZON;
	if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
	if(TL2>TL1)							r[SR]|=CCR_CON;

	r[PC]+=8;	return;



case	0x0cb8:				//abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD3;	sprintf(buf,"CMPI.L #$%08X,$%04X\n",
	num4(1),num2(3));	CO(buf);	}
#endif
			TR1=(short)num2(3);
			TL1=r4(TR1);
			TL2=TL1-num4(1);

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL2==0)							r[SR]|=CCR_ZON;
			if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
				else
			if(((TL1^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL2>TL1)							r[SR]|=CCR_CON;

			r[PC]+=8;	return;



		case	0x0001:		//long size
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD4;	sprintf(buf,"CMPI.L #$%08X,$%08X\n",
	num4(1),num4(3));	CO(buf);	}
#endif
			TR1=num4(3);
			TL1=r4(TR1);
			TL2=TL1-num4(1);

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL2==0)							r[SR]|=CCR_ZON;
			if((TL2&0x80000000)!=0)				r[SR]|=CCR_NON;
				else
			if(((TL1^num4(1))&0x80000000)!=0)	r[SR]|=CCR_VON;
			if(TL2>TL1)							r[SR]|=CCR_CON;

			r[PC]+=10;	return;


		default:
			gic();	return;
	}
