//	MC68K code MULU



case	0x00c0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"MULU D%d,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=(unsigned short)r[D0+RN1];
	TS2=(unsigned short)r[D0+RN2];
	TL3=(unsigned short)TS1*(unsigned short)TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=2;	return;



case	0x00d0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"MULU (A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=(unsigned short)r[D0+RN2];
	TL3=(unsigned short)TS1*(unsigned short)TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=2;	return;




case	0x00d8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"MULU (A%d)+,D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]);
	TS2=(unsigned short)r[D0+RN2];
	TL3=(unsigned short)TS1*(unsigned short)TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[A0+RN1]+=2;
	r[PC]+=2;	return;



case	0x00e0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD0;	sprintf(buf,"MULU -(A%d),D%d\n",
	RN1,RN2);	CO(buf);	}
#endif
	r[A0+RN1]-=2;
	TS1=r2(r[A0+RN1]);
	TS2=(unsigned short)r[D0+RN2];
	TL3=(unsigned short)TS1*(unsigned short)TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=2;	return;



case	0x00e8:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"MULU $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
	TS1=r2(r[A0+RN1]+(short)num2(1));
	TS2=(unsigned short)r[D0+RN2];
	TL3=(unsigned short)TS1*(unsigned short)TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=4;	return;



case	0x00f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"MULU $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO(buf);	}
#endif
	if((num2(1)&0x0800)==0)
			TS1=r2(r[A0+RN1]+(char)num1(1)+(short)r[D0+RN3]);
	else	TS1=r2(r[A0+RN1]+(char)num1(1)+       r[D0+RN3]);
	TS2=(unsigned short)r[D0+RN2];
	TL3=(unsigned short)TS1*(unsigned short)TS2;

	r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				r[SR]|=CCR_ZON;
	if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

	r[D0+RN2]=TL3;
	r[PC]+=4;	return;



case	0x00f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"MULU $%04X,D%d\n",
	num2(1),RN1,RN2);	CO(buf);	}
#endif
			TS1=r2((short)num2(1));
			TS2=(unsigned short)r[D0+RN2];
			TL3=(unsigned short)TS1*(unsigned short)TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=4;	return;



		case	1:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD2;	sprintf(buf,"MULU $%08X,D%d\n",
	num4(1),RN1,RN2);	CO(buf);	}
#endif
			TS1=r2(num4(1));
			TS2=(unsigned short)r[D0+RN2];
			TL3=(unsigned short)TS1*(unsigned short)TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=6;	return;



		case	2:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"MULU $%04X(PC),D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=r2(r[PC]+(short)num2(1)+2);
			TS2=(unsigned short)r[D0+RN2];
			TL3=(unsigned short)TS1*(unsigned short)TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"MULU $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO(buf);	}
#endif
			if((num2(1)&0x0800)==0)
					TS1=r2(r[PC]+(char)num1(1)+(short)r[D0+RN3]+2);
			else	TS1=r2(r[PC]+(char)num1(1)+       r[D0+RN3]+2);
			TS2=(unsigned short)r[D0+RN2];
			TL3=(unsigned short)TS1*(unsigned short)TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=4;	return;



		case	4:
#ifdef	_DEBUG
if(r[VSR]&VSR_DISP_CODE){	BD1;	sprintf(buf,"MULU #$%04X,D%d\n",
	num2(1),RN2);	CO(buf);	}
#endif
			TS1=num2(1);
			TS2=(unsigned short)r[D0+RN2];
			TL3=(unsigned short)TS1*(unsigned short)TS2;

			r[SR]&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				r[SR]|=CCR_ZON;
			if((TL3&0x80000000)!=0)	r[SR]|=CCR_NON;

			r[D0+RN2]=TL3;
			r[PC]+=4;	return;

		default:
			gic();	return;
	}





