#include	"mc68k.h"
#include	"../../device/mat.h"

#include	<windows.h>
#include	<stdio.h>

#ifdef	_DEBUG
#include	"../../window/console/console.h"
#include	"../../monitor/monitor.h"

extern	CONSOLE	con;
extern	MONITOR	mon;
#endif	_DEBUG



unsigned char	MC68K::r1(unsigned long addr)
{	unsigned short	h=(unsigned short)(addr>>16);

	if(mat[h].type&MAT_USE)
		return(mat[h].device->_r1(mat[h].mem,mat[h].mask&addr));
	else{
#ifdef	_DEBUG
		char	buf[0x100];
		sprintf(buf,"<DEVICE>\tR1\t%08X\n",addr);	CO(buf);
#endif
		return(0xff);
	}
}

unsigned short	MC68K::r2(unsigned long addr)
{	unsigned short	h=(unsigned short)(addr>>16);

	if(mat[h].type&MAT_USE)
		return(mat[h].device->_r2(mat[h].mem,mat[h].mask&addr));
	else{
#ifdef	_DEBUG
		char	buf[0x100];
		sprintf(buf,"<DEVICE>\tR2\t%08X\n",addr);	CO(buf);
#endif
		return(0xffff);
	}
}

unsigned long	MC68K::r4(unsigned long addr)
{	unsigned short	h=(unsigned short)(addr>>16);

	if(mat[h].type&MAT_USE)
		return(mat[h].device->_r4(mat[h].mem,mat[h].mask&addr));
	else{
#ifdef	_DEBUG
		char	buf[0x100];
		sprintf(buf,"<DEVICE>\tR4\t%08X\n",addr);	CO(buf);
#endif
		return(0xffffffff);
	}
}



void	MC68K::w1(unsigned long addr,unsigned char data)
{	unsigned short	h=(unsigned short)(addr>>16);

	if(mat[h].type&MAT_WRITE){
		mat[h].device->_w1(mat[h].mem,mat[h].mask&addr,data);	return;	}
#ifdef	_DEBUG
	else{	char	buf[0x100];
			sprintf(buf,"<DEVICE>\tW1\t%08X < %02X\n",addr,data);
			CO(buf);												}
#endif
}

void	MC68K::w2(unsigned long addr,unsigned short data)
{	unsigned short	h=(unsigned short)(addr>>16);

	if(mat[h].type&MAT_WRITE){
		mat[h].device->_w2(mat[h].mem,mat[h].mask&addr,data);	return;	}
#ifdef	_DEBUG
	else{	char	buf[0x100];
			sprintf(buf,"<DEVICE>\tW2\t%08X < %04X\n",addr,data);
			CO(buf);												}
#endif
}

void	MC68K::w4(unsigned long addr,unsigned long data)
{	unsigned short	h=(unsigned short)(addr>>16);

	if(mat[h].type&MAT_WRITE){
		mat[h].device->_w4(mat[h].mem,mat[h].mask&addr,data);	return;	}
#ifdef	_DEBUG
	else{	char	buf[0x100];
			sprintf(buf,"<DEVICE>\tW4\t%08X < %08X\n",addr,data);
			CO(buf);												}
#endif
}
