#include	"_e8.h"
#include	"../mfp/mfp.h"

#ifdef	_DEBUG
#include	<stdio.h>
#include	"../../window/console/console.h"

extern	CONSOLE	con;
#endif	_DEBUG

extern	MFP		mfp;



unsigned char	_E8::_r1(unsigned char *dmy,unsigned long addr)
{
	if((addr>=0x8000)&&(addr<0x8030))	return(mfp._r1(dmy,addr));

#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<_E8>\tR1\t%08X\n",addr);	CO(buf);
#endif
	return(0xff);
}



unsigned short	_E8::_r2(unsigned char *dmy,unsigned long addr)
{
	if((addr>=0x8000)&&(addr<0x8030))	return(mfp._r2(dmy,addr));

#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<_E8>\tR2\t%08X\n",addr);	CO(buf);
#endif
	return(0xffff);
}



unsigned long	_E8::_r4(unsigned char *dmy,unsigned long addr)
{
	if((addr>=0x8000)&&(addr<0x8030))	return(mfp._r4(dmy,addr));

#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<_E8>\tR4\t%08X\n",addr);	CO(buf);
#endif
	return(0xffffffff);
}





void	_E8::_w1(unsigned char *dmy,unsigned long addr,unsigned char data)
{
	if((addr>=0x8000)&&(addr<0x8030)){	mfp._w1(dmy,addr,data);	return;	}

#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<_E8>\tW1\t%08X < %02X\n",addr,data);	CO(buf);
#endif
}




void	_E8::_w2(unsigned char *dmy,unsigned long addr,unsigned short data)
{
	if((addr>=0x8000)&&(addr<0x8030)){	mfp._w2(dmy,addr,data);	return;	}

#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<_E8>\tW2\t%08X < %04X\n",addr,data);	CO(buf);
#endif
}




void	_E8::_w4(unsigned char *dmy,unsigned long addr,unsigned long data)
{
	if((addr>=0x8000)&&(addr<0x8030)){	mfp._w4(dmy,addr,data);	return;	}

#ifdef	_DEBUG
	char	buf[0x100];
	sprintf(buf,"<_E8>\tW4\t%08X < %08X\n",addr,data);	CO(buf);
#endif
}
