#ifdef	_DEBUG
#include	<windows.h>
#include	<stdio.h>

#include	"../cpu/cpu.h"
#include	"../cpu/mc68k/mc68k.h"
#include	"../window/console/console.h"
#include	"../window/gfx/gfx.h"
#include	"../rti/rti.h"
#include	"../device/le.h"
#include	"monitor.h"



#ifdef	SYSTEM_SATURN
#include	"../cpu/sh2/sh2.h"
#include	"../cpu/scudsp/scudsp.h"
#include	"../device/cd/cd.h"
#include	"../device/scu/scu.h"
#include	"../device/scsp/scsp.h"
#include	"../device/smpc/smpc.h"
#include	"../device/vdp2/vdp2.h"
#include	"../device/vdp1/vdp1.h"
#include	"../device/vexs/vexs.h"
#include	"../device/sh2ld/sh2ld.h"
extern	SH2			sh2m;
extern	SH2			sh2s;
extern	SCUDSP		sdsp;
extern	CD			cd;
extern	SCU			scu;
extern	SCSP		scsp;
extern	SMPC		smpc;
extern	VDP2		vdp2;
extern	VDP1		vdp1;
extern	VEXS		vexs;
extern	SH2LD		sh2mld;
#endif	SYSTEM_SATURN



#ifdef	SYSTEM_HORNET
#include	"../cpu/ppc403ga/ppc403ga.h"
extern	PPC403GA	ppc;
#endif	SYSTEM_HORNET



extern	HWND		hWnd_main;
extern	MC68K		m68k;
extern	CONSOLE		con;
extern	RTI			rti;
extern	GFX			gfx;



void	MONITOR::shell(void)
{
	unsigned char	TC1,TC2;
	unsigned short	TS1,TS2;
	unsigned long	TL1,TL2,TL3;
	char			buf[0x100];
	char			fname[0x100];

	do{
		switch(ccn){
			default:	ccn=1;	goto	COM_EXIT;
			case	CPU_SH2_MASTER:	CO("SH2A>");	break;
			case	CPU_SH2_SLAVE:	CO("SH2B>");	break;
			case	CPU_MC68K:		CO("M68K>");	break;
			case	CPU_SCUDSP:		CO("SDSP>");	break;
			case	CPU_PPC403GA:	CO("PPC >");	break;	}

		for(clp=0;clp!=0x100;clp++)	clb[clp]=NULL;	//buff clear
		ReadFile(con.STDIN,clb,255,&clp,NULL);		//Win32 func
		if(strlen(clb)==0)	goto	COM_EXIT;		//no commands
		for(clp=0;!isspace(clb[clp]);clp++)			//skip first space

		switch(clb[clp]){
			case	'?':			//help message
#include	"help.cpp"
			case	'c':			//change CPU
#include	"chng_cpu.cpp"
			case	'r':			//register
#include	"register.cpp"
			case	'd':			//memory dump
#include	"dump.cpp"
			case	'x':			//vsr ctrl
#include	"vsr_ctrl.cpp"
			case	'w':			//write out
#include	"write.cpp"
			case	'i':			//interrupt
#include	"interupt.cpp"
			case	'b':			//break point
#include	"brkpoint.cpp"
			case	'u':			//disassemble
#include	"disasm.cpp"
			case	'e':			//enter to memory
#include	"ent2mem.cpp"
			case	'm':			//memory viewer
#include	"mem_view.cpp"



			case	't':			//trace
				switch(ccn){
#ifdef	_AZU_SH2_
					case	CPU_SH2_MASTER:
						sh2m.r[VSR]|=VSR_1STEP_TRACE;	break;
					case	CPU_SH2_SLAVE:
						sh2s.r[VSR]|=VSR_1STEP_TRACE;	break;
#endif
					case	CPU_MC68K:
						m68k.r[VSR]|=VSR_1STEP_TRACE;	break;
#ifdef	_AZU_PPC403GA_
					case	CPU_PPC403GA:
						ppc.r[VSR]|=VSR_1STEP_TRACE;	break;
#endif
				}
				goto	COM_EXIT;
			case	'g':			//go
				switch(ccn){
#ifdef	_AZU_SH2_
					case	CPU_SH2_MASTER:
								sh2m.r[VSR]|=VSR_1STEP_TRACE;
								Sleep(5);
								sh2m.r[VSR]|=VSR_PROCESSOR_ACTIVE;	break;
					case	CPU_SH2_SLAVE:
								sh2s.r[VSR]|=VSR_1STEP_TRACE;
								Sleep(5);
								sh2s.r[VSR]|=VSR_PROCESSOR_ACTIVE;	break;
#endif
					case	CPU_MC68K:
								m68k.r[VSR]|=VSR_1STEP_TRACE;
								Sleep(5);
								m68k.r[VSR]|=VSR_PROCESSOR_ACTIVE;	break;
#ifdef	_AZU_PPC403GA_
					case	CPU_PPC403GA:
								ppc.r[VSR]|=VSR_1STEP_TRACE;
								Sleep(5);
								ppc.r[VSR]|=VSR_PROCESSOR_ACTIVE;	break;
#endif
				}
				goto	COM_EXIT;
			case	'p':			//stop
				switch(ccn){
#ifdef	_AZU_SH2_
					case	CPU_SH2_MASTER:
						sh2m.r[VSR]&=~VSR_PROCESSOR_ACTIVE;	break;
					case	CPU_SH2_SLAVE:
						sh2s.r[VSR]&=~VSR_PROCESSOR_ACTIVE;	break;
#endif
					case	CPU_MC68K:
						m68k.r[VSR]&=~VSR_PROCESSOR_ACTIVE;	break;
#ifdef	_AZU_PPC403GA_
					case	CPU_PPC403GA:
						ppc.r[VSR]&=~VSR_PROCESSOR_ACTIVE;	break;
#endif
				}
				goto	COM_EXIT;

			case	'q':			//quit
				SendMessage(hWnd_main,WM_DESTROY,NULL,NULL);
				goto	COM_EXIT;



#ifdef	SYSTEM_SATURN
			case	'v':			//vdp control
#include	"vdp_ctrl.cpp"

			case	'!':
				cd.test();	break;
			case	'"':
				smpc.stat();	break;
			case	'#':
				sh2mld.test();	break;
			case	'$':
				scu.stat();	break;
			case	'%':
				scsp.stat();	break;
			case	'&':
				vexs.stat();	break;
			case	'(':
				rti.test();	break;
#endif	SYSTEM_SATURN



		}
COM_EXIT:
		Sleep(200);
	}
	while(1);
}



#endif	_DEBUG
