#include	<windows.h>
#include	<stdio.h>
#include	"console.h"



#ifdef	_DEBUG

void	CONSOLE::start_redirect(char * clb)
{
	char	fname[0x100];

	if(mode==2)	return;							//already redirect mode
	prev_mode=mode;								//backup prev mode
	sscanf(clb,"%s",fname);
	REDIRECT=CreateFile(fname,GENERIC_WRITE,0,0,CREATE_ALWAYS,
													FILE_ATTRIBUTE_NORMAL,0);
	if(REDIRECT==(void *)-1){
		out("may be invalid filename\n");
		return;								}
	mode=2;
	return;
}



void	CONSOLE::end_redirect(void)
{
	if(mode!=2)	return;							//not redirect mode
	CloseHandle(REDIRECT);
	mode=prev_mode;
	return;
}



void	CONSOLE::out(char *str)
{	switch(mode){
		default:
		case	2:	WriteFile(REDIRECT,str,strlen(str),&TUL,NULL);	//return;
		case	0:	WriteFile(STDOUT,str,strlen(str),&TUL,NULL);	return;
		case	1:	OutputDebugString((LPCTSTR)str);				return;
	}
}

void	CONSOLE::init(void)
{	AllocConsole();
	REDIRECT	=NULL;
	STDIN		=GetStdHandle(STD_INPUT_HANDLE);
	STDOUT		=GetStdHandle(STD_OUTPUT_HANDLE);	}



#else
void	CONSOLE::init(void)	{	NULL;	}
void	CONSOLE::out(char *str)
{	OutputDebugString((LPCTSTR)str);	return;	}
#endif
