#ifndef		_AZU_GFX_
#define		_AZU_GFX_

#include	<windows.h>
#include	<direct.h>
#include	<ddraw.h>
#ifdef	_DEBUG
#include	<dxerr8.h>
#include	<stdio.h>
#include	"../console/console.h"

extern	CONSOLE				con;
#endif

#define	H_RESOLUTION	256		//b
#define	V_RESOLUTION	256

enum{	DS_PRIM,
		DS_BACK,
		DS_DRAW,
		DS_MAX		};

class	GFX	{
		LPDIRECTDRAW7			lpDD7;
		LPDIRECTDRAWSURFACE7	lpDDS7[DS_MAX];
		LPDIRECTDRAWCLIPPER		lpDDC[DS_MAX];

		unsigned char			*vinfo;
		unsigned char			*vvdp2;
		unsigned char			*vdraw;
	public:

		unsigned long			wm_switch;
			//bit	0	Flip	V
			//bit	1	Flip	H
			//bit	2	Rotate	90
			//bit	3	Rotate	180
			//bit	8	0:window resize by vdp2 size
			//			1:gfx fit window size

		unsigned long			vinfo_stat;
			//bit	0	infomation select
			//		:		0	NULL
			//bit	15		1	cram view
			//				2	mem view

#ifdef	_DEBUG
//memory viewer֘A
//	Debug only Ȃ̂́Ap[^͂KvƂ
		unsigned long			mv_addr;
		unsigned long			mv_span;
		unsigned long			mv_bpp;
#endif

		void					make_vinfo(void);
		void					make_vdraw(void);

#include	"vcopy/vcopy.h"

		void					vd2wd(void);
		void					vd2wd_c32_r000(unsigned long,unsigned long);
		void					vd2wd_c32_r090(unsigned long,unsigned long);
		void					vd2wd_c32_r180(unsigned long,unsigned long);
		void					vd2wd_c32_r270(unsigned long,unsigned long);
		void					vd2wd_c24_r000(unsigned long,unsigned long);
		void					vd2wd_c24_r090(unsigned long,unsigned long);
		void					vd2wd_c24_r180(unsigned long,unsigned long);
		void					vd2wd_c24_r270(unsigned long,unsigned long);
		void					vd2wd_c16_r000(unsigned long,unsigned long);
		void					vd2wd_c16_r090(unsigned long,unsigned long);
		void					vd2wd_c16_r180(unsigned long,unsigned long);
		void					vd2wd_c16_r270(unsigned long,unsigned long);

		void					wb2wp(void);

		void					window_resize(void);
		void					init(void);
								~GFX();
};



#endif		_AZU_GFX_
