#include	<windows.h>
#include	<stdio.h>
#include	"../../cpu/mc68k/mc68k.h"
#include	"../../device/device.h"
#include	"../../device/memory/memory.h"
#include	"../../pkzip/pkzip.h"

		PKZIP				pkzip;
extern	HWND				hWnd_main;
extern	char				path_inifile[_MAX_PATH];

extern	MC68K				m68k;
extern	MEMORY				main;
extern	MEMORY				boot;
extern	MEMORY				cg;



void	load_rom(unsigned long);

void	load_rom(unsigned long rom_number)
{
	HANDLE			h_zip;
	unsigned char	*b_zip;
	char			f_zip[256];
	char			f_bin[256];
	unsigned long	s_zip;
	unsigned long	tul1;




	GetPrivateProfileString("system","zip",NULL,f_zip,
												sizeof(f_zip),path_inifile);
	h_zip=CreateFile(f_zip,GENERIC_READ,0,0,OPEN_EXISTING,
													FILE_ATTRIBUTE_NORMAL,0);
	s_zip=GetFileSize(h_zip,NULL);
	b_zip=new unsigned char[s_zip];
	ReadFile(h_zip,b_zip,s_zip,&tul1,NULL);	CloseHandle(h_zip);



	GetPrivateProfileString("system","boot",NULL,f_bin,
												sizeof(f_bin),path_inifile);
	tul1=pkzip.m_search_name(b_zip,s_zip,f_bin);
	if(tul1==0xffffffff){	MessageBox(hWnd_main,"boot rom not found",
					"ERROR",MB_OK|MB_APPLMODAL);	goto	routine_end;	}
	tul1=pkzip.m_extract(							b_zip+tul1+ZNAM+
								*(unsigned short *)(b_zip+tul1+ZFLN)+
								*(unsigned short *)(b_zip+tul1+ZXLN),
								*(unsigned long  *)(b_zip+tul1+ZZLN),
								boot.mem,0x00020000);



	GetPrivateProfileString("system","cg",NULL,f_bin,
												sizeof(f_bin),path_inifile);
	tul1=pkzip.m_search_name(b_zip,s_zip,f_bin);
	if(tul1==0xffffffff){	MessageBox(hWnd_main,"cg rom not found",
					"ERROR",MB_OK|MB_APPLMODAL);	goto	routine_end;	}
	tul1=pkzip.m_extract(						b_zip+tul1+ZNAM+
							*(unsigned short *)(b_zip+tul1+ZFLN)+
							*(unsigned short *)(b_zip+tul1+ZXLN),
							*(unsigned long  *)(b_zip+tul1+ZZLN),
							cg.mem,0x000c0000);

	memcpy(main.mem,boot.mem+0x10000,0x10000);

	m68k.por();
routine_end:
	delete[]	b_zip;
}
