#include	<windows.h>
#include	<windowsx.h>
#include	<stdio.h>
#include	"main.h"
#include	"../window.h"
#include	"../gfx/gfx.h"
#include	"../../cpu/mc68k/mc68k.h"
#include	"../../rti/rti.h"



extern	MC68K	m68k;
extern	GFX		gfx;
extern	RTI		rti;

extern	HWND	hWnd_main;
extern	HMENU	hMenu_popup;

extern	HMENU	hmenu_priority_m68k;
extern	HMENU	hmenu_priority_rti;
extern	HANDLE	trdh[TRD_MAX];
extern	void	priority_destructor(void);
extern	void	priority_swm(unsigned long,int,HMENU,unsigned long);
extern	int		priority_m2p(unsigned long);

LRESULT CALLBACK	wp_main(HWND,UINT,WPARAM,LPARAM);



LRESULT CALLBACK	wp_main(HWND hWnd,UINT uMsg,WPARAM wParam,LPARAM lParam)
{
	POINT	point_tmp;
	char	buf[0x100];

	switch(uMsg){
		case	WM_PAINT:
			gfx.wb2wp();
			return(DefWindowProc(hWnd,uMsg,wParam,lParam));
		case	WM_RBUTTONDOWN:
			point_tmp.x=LOWORD(lParam);
			point_tmp.y=HIWORD(lParam);
			ClientToScreen(hWnd_main,&point_tmp);
			TrackPopupMenu(hMenu_popup,TPM_RIGHTBUTTON|TPM_TOPALIGN|
					TPM_LEFTALIGN,point_tmp.x,point_tmp.y,NULL,hWnd_main,NULL);
			break;



		case	WM_LBUTTONDOWN:
			//̃bZ[Ŵ݁ALvVւ̓͂Ɍ
			PostMessage(hWnd_main,WM_NCLBUTTONDOWN,HTCAPTION,lParam);
			break;



		case	WM_CLOSE:
		case	WM_DESTROY:
			priority_destructor();
			SendMessage(hWnd_main,WM_COMMAND,IDM_STOP,NULL);
			PostQuitMessage(0);
			break;
		case	WM_COMMAND:
			switch(LOWORD(wParam)){
				case	IDM_EXIT:
					SendMessage(hWnd_main,WM_DESTROY,NULL,NULL);
					break;
				case	IDM_VERSION:		
					MessageBox(hWnd_main,"AX68K Generation3\n\tProgrammed "\
						"by AZUCO","Credit",MB_OK|MB_APPLMODAL);	break;
				case	IDM_HARD_RESET:
				case	IDM_SOFT_RESET:
					m68k.isl[0x00]|=0x80;
					break;
				case	IDM_RUN:
					m68k.r[VSR]|=VSR_PROCESSOR_ACTIVE;
					break;
				case	IDM_STOP:
					m68k.r[VSR]&=~VSR_PROCESSOR_ACTIVE;
					Sleep(10);
					break;



#include	"wp_pri.cpp"



				case	IDM_MAXIMIZE:
					ShowWindow(hWnd_main,SW_MAXIMIZE);
					break;
				case	IDM_MINIMIZE:
					ShowWindow(hWnd_main,SW_MINIMIZE);
					break;
				case	IDM_GFX_SIZE:
					gfx.wm_switch&=0xfffffeff;
					gfx.window_resize();
					break;
				case	IDM_WIN_SIZE:
					gfx.wm_switch&=0xfffffeff;
					gfx.wm_switch|=0x00000100;
					gfx.window_resize();
					break;



				case	IDM_FLIP_V:
					gfx.wm_switch^=0x01;	break;
				case	IDM_FLIP_H:
					gfx.wm_switch^=0x02;	break;



				case	IDM_ROTATE_0:
					gfx.wm_switch&=0xfffffff3;
					gfx.window_resize();
					break;
				case	IDM_ROTATE_1:
					gfx.wm_switch&=0xfffffff3;
					gfx.wm_switch|=0x00000004;
					gfx.window_resize();
					break;
				case	IDM_ROTATE_2:
					gfx.wm_switch&=0xfffffff3;
					gfx.wm_switch|=0x00000008;
					gfx.window_resize();
					break;
				case	IDM_ROTATE_3:
					gfx.wm_switch&=0xfffffff3;
					gfx.wm_switch|=0x0000000c;
					gfx.window_resize();
					break;



				case	IDM_VI_NULL:
					gfx.vinfo_stat&=0xffffff00;
					gfx.make_vinfo();
					gfx.make_vdraw();
					gfx.vd2wd();
					break;
#ifdef	_DEBUG
				case	IDM_VI_MEMV:
					gfx.vinfo_stat&=0xffffff00;
					gfx.vinfo_stat|=0x00000002;
					gfx.make_vinfo();
					gfx.make_vdraw();
					gfx.vd2wd();
					break;
#endif



				case	IDM_VI_TEST_1:
					gfx.vinfo_stat&=0xffffff00;
					gfx.vinfo_stat|=0x000000ff;
					gfx.make_vinfo();
					gfx.make_vdraw();
					gfx.vd2wd();
					break;
				case	IDM_VI_TEST_2:
					gfx.vinfo_stat&=0xffffff00;
					gfx.vinfo_stat|=0x000000fe;
					gfx.make_vinfo();
					gfx.make_vdraw();
					gfx.vd2wd();
					break;



				case	IDM_HP_AWORLD:
					ShellExecute(NULL,NULL,
						"http://www.smallnews.net/azuco/",
											NULL,NULL,SW_SHOWNORMAL);	break;
				case	IDM_HP_MEGANE:
					ShellExecute(NULL,NULL,
						"http://www.bekkoame.ne.jp/ro/haiboku/",
											NULL,NULL,SW_SHOWNORMAL);	break;
				case	IDM_HP_ZLIB:
					ShellExecute(NULL,NULL,
						"http://www.gzip.org/zlib/",
											NULL,NULL,SW_SHOWNORMAL);	break;
			}
		default:
			return(DefWindowProc(hWnd,uMsg,wParam,lParam));
	}
	return(0L);
}
