#include	<windows.h>

		HWND				hWnd_splash;
		void				create_splash_window(HINSTANCE);

extern	char				path_inifile[_MAX_PATH];
extern	LRESULT CALLBACK	wp_splash(HWND,UINT,WPARAM,LPARAM);

void	create_splash_window(HINSTANCE hNowInstance)
{
	WNDCLASSEX		wcex;
	LPBITMAPINFO	lpBi;
	LPLOGPALETTE	lpPal;
	RECT			rectBmp;
	RECT			rectWin;
	HANDLE			hPal;
	PAINTSTRUCT		ps;
	char			Ver[256];
	int				x;

	wcex.cbSize			=sizeof(WNDCLASSEX);
	wcex.style			=CS_HREDRAW|CS_VREDRAW;
	wcex.lpfnWndProc	=(WNDPROC)DefWindowProc;
	wcex.cbClsExtra		=NULL;
	wcex.cbWndExtra		=0;
	wcex.hInstance		=hNowInstance;
	wcex.hIcon			=LoadIcon(hNowInstance,"AX68K");
	wcex.hCursor		=LoadCursor(NULL,IDC_ARROW);
	wcex.hbrBackground	=(HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	=NULL;
	wcex.lpszClassName	="AX68K_SPLASH";
	wcex.hIconSm		=NULL;
	RegisterClassEx(&wcex);

	GetPrivateProfileString("system","version_name",
										"AX68K G3",Ver,256,path_inifile);

	lpBi=(LPBITMAPINFO)
		LockResource(
		LoadResource(hNowInstance,
		FindResource(hNowInstance,"AX68K",RT_BITMAP)));
	rectBmp.left	=0;		rectBmp.right	=lpBi->bmiHeader.biWidth;
	rectBmp.top		=0;		rectBmp.bottom	=lpBi->bmiHeader.biHeight;
	AdjustWindowRect(&rectBmp,WS_POPUP,TRUE);
	GetWindowRect(GetDesktopWindow(),&rectWin);

	hWnd_splash=CreateWindow(
		"AX68K_SPLASH",NULL,WS_VISIBLE|WS_POPUP,
		(rectWin.right-rectBmp.right)/2,(rectWin.bottom-rectBmp.bottom)/2,
		rectBmp.right,rectBmp.bottom,NULL,NULL,hNowInstance,NULL);

#ifndef	_DEBUG
//	SetWindowPos(hWnd_splash,HWND_TOPMOST,0,0,0,0,SWP_NOSIZE|SWP_NOMOVE);
#endif

	hPal=GlobalAlloc(GHND,
		sizeof(LOGPALETTE)+(256*sizeof(PALETTEENTRY)));
	lpPal=(LPLOGPALETTE)GlobalLock(hPal);
	lpPal->palVersion=0x300;
	lpPal->palNumEntries=256;
	for(x=0;x<256;x++){
		lpPal->palPalEntry[x].peRed  =lpBi->bmiColors[x].rgbRed;
		lpPal->palPalEntry[x].peGreen=lpBi->bmiColors[x].rgbGreen;
		lpPal->palPalEntry[x].peBlue =lpBi->bmiColors[x].rgbBlue;	}
	BeginPaint(hWnd_splash,&ps);
	SelectPalette(ps.hdc,CreatePalette(lpPal),FALSE);
	RealizePalette(ps.hdc);

	SetDIBitsToDevice(ps.hdc,0,0,
		lpBi->bmiHeader.biWidth,lpBi->bmiHeader.biHeight,
		0,0,0,lpBi->bmiHeader.biHeight,
		(LPSTR)lpBi+lpBi->bmiHeader.biSize+(256*sizeof(RGBQUAD)),
		lpBi,DIB_RGB_COLORS);

	x=(lpBi->bmiHeader.biWidth)/(strlen(Ver)*2);

	SetBkMode(ps.hdc,TRANSPARENT);
	SelectObject(ps.hdc,CreateFont(4*x,x,0,0,0,TRUE,FALSE,FALSE,
		SHIFTJIS_CHARSET,OUT_OUTLINE_PRECIS,CLIP_DEFAULT_PRECIS,
		PROOF_QUALITY,DEFAULT_PITCH,NULL));		//font style

	SetTextColor(ps.hdc,RGB(0x00,0x40,0x80));	//shadow
	rectWin.left=8;	rectWin.right=lpBi->bmiHeader.biWidth;
	rectWin.top=0;	rectWin.bottom=lpBi->bmiHeader.biHeight;
	DrawText(ps.hdc,Ver,strlen(Ver),&rectWin,
		DT_BOTTOM|DT_CENTER|DT_SINGLELINE);

	SetTextColor(ps.hdc,RGB(0x80,0xc0,0xff));	//face
	rectWin.left=0;	rectWin.right=lpBi->bmiHeader.biWidth;
	rectWin.top=0;	rectWin.bottom=lpBi->bmiHeader.biHeight-4;
	DrawText(ps.hdc,Ver,strlen(Ver),&rectWin,
		DT_BOTTOM|DT_CENTER|DT_SINGLELINE);

	EndPaint(hWnd_splash,&ps);
	GlobalUnlock(hPal);
	GlobalFree(hPal);
}
