; FAT buffering

	module	fat_buffers
	
include	"#idedos.def"
include	"#packages.def"
include	"fatfs.def"
	
	; Our definitions
	xdef	buf_emptybuffers
	xdef	buf_findbuf
	xdef	buf_findbuf_noread
	xdef	buf_writebuf
	xdef	buf_update
	xdef	buf_flushbuffers
	

; ***************************************************************************
; * Subroutine to empty/initialise the buffer details                       *
; ***************************************************************************
; BCDEHL corrupted.

.buf_emptybuffers
	ld	hl,buf_mrulist
	ld	bc,buf_numbufs*$100	; B=buffers, C=0
	push	bc
.buf_eb_setmru
	ld	(hl),c			; set MRU list to 0,1,...n-1
	inc	hl
	inc	c
	djnz	buf_eb_setmru
	pop	bc
	ld	hl,buf_handles		; TBD: not strictly necessary
	ld	d,c
	ld	e,fbh_size
.buf_eb_setflags
	ld	(hl),d			; set flags to zero (unused)
	add	hl,de
	djnz	buf_eb_setflags
	ret


; ***************************************************************************
; * Subroutine to set the MRU buffer and obtain its address                 *
; ***************************************************************************
; On entry, A=buffer number (0..n-1)
; On exit, HL=address of buffer
; Enter at buf_getaddress to avoid making buffer MRU
; ABCDE corrupted.

.buf_setmru
	ld	hl,buf_mrulist
	ld	b,a
	ld	c,a
.buf_sm_reorder
	ld	a,(hl)
	ld	(hl),b			; move entries down list
	inc	hl
	ld	b,a
	cp	c
	jr	nz,buf_sm_reorder	; until position of ours is filled
.buf_getaddress
	inc	a
	ld	hl,buf_buffers-buf_secsize
	ld	de,buf_secsize
.buf_sm_formaddr
	add	hl,de			; form address of buffer
	dec	a
	jr	nz,buf_sm_formaddr
	ret


; ***************************************************************************
; Subroutine to get a buffer handle                                         *
; ***************************************************************************
; On entry, A=buffer number (0..n-1)
; On exit, IY=buffer handle
; ADE corrupted.

.buf_gethandle
	ld	iy,buf_handles-fbh_size
	ld	de,fbh_size
	inc	a
.buf_gethandle_formaddr
	add	iy,de			; form address of location info
	dec	a
	jr	nz,buf_gethandle_formaddr
	ret


; ***************************************************************************
; * Subroutine to get buffer for sector, without reading from disk          *
; ***************************************************************************
; On entry, BCDE=sector required, IX=partition handle
; On exit, HL=address of buffer
;          Fc=1 if buffer contents are valid, Fc=0 if needs reading.
; No errors possible.
; This will update the MRU list
; ABCDEHL corrupted.
; Enter at buf_locatebuf to also return buffer handle in IY.
; TBD: Maybe this should be able to return an error, as it does do disk writes.

.buf_findbuf_noread
	push	iy
	call	buf_locatebuf
	pop	iy
	ret
.buf_locatebuf
	ld	iy,buf_handles
	ld	l,buf_numbufs
.buf_fb_search
	bit	bufflag_inuse,(iy+fbh_flags)
	jr	z,buf_fb_mismatch	; no match if not in use
	ld	a,(iy+fbh_sector)	; check sector (lsf first)
	cp	e
	jr	nz,buf_fb_mismatch
	ld	a,(iy+fbh_sector+1)
	cp	d
	jr	nz,buf_fb_mismatch
	ld	a,(iy+fbh_sector+2)
	cp	c
	jr	nz,buf_fb_mismatch
	ld	a,(iy+fbh_sector+3)
	cp	b
	jr	nz,buf_fb_mismatch
	ld	a,ixl			; check partition handle (lsf first)
	cp	(iy+fbh_phandle)
	jr	nz,buf_fb_mismatch
	ld	a,ixh
	cp	(iy+fbh_phandle+1)
	jr	nz,buf_fb_mismatch
	ld	a,buf_numbufs
	sub	l			; A=buffer number
	call	buf_setmru		; set MRU, get address
	scf				; Fc=1, buffer contents valid
	ret
.buf_fb_mismatch
	push	bc
	ld	bc,fbh_size
	add	iy,bc			; step to location of next buffer
	pop	bc
	dec	l
	jr	nz,buf_fb_search	; check remaining buffers
	ld	a,(buf_mrulist+buf_numbufs-1)	; A=LRU buffer number
	push	de
	call	buf_flushone		; leaves IY=buffer handle
	pop	hl			; BCHL=sector
	set	bufflag_inuse,(iy+fbh_flags)
	res	bufflag_upd,(iy+fbh_flags)
	ld	a,ixl
	ld	(iy+fbh_phandle),a	; store partition handle
	ld	a,ixh
	ld	(iy+fbh_phandle+1),a
	ld	(iy+fbh_sector),l	; and sector
	ld	(iy+fbh_sector+1),h
	ld	(iy+fbh_sector+2),c
	ld	(iy+fbh_sector+3),b
	ld	a,(buf_mrulist+buf_numbufs-1)	; A=LRU buffer again
	call	buf_setmru		; set MRU, get address to HL
	and	a			; Fc=0, contents not valid
	ret
	

; ***************************************************************************
; * Subroutine to get buffer for sector, reading from disk if necessary     *
; ***************************************************************************
; On entry, BCDE=sector required, IX=partition handle
; On exit, Fc=1 (success) and HL=address of buffer
; or Fc=0 and A=error.
; This will update the MRU list
; ABCDEHL corrupted.

.buf_findbuf
	push	iy
	call	buf_locatebuf
	jr	c,buf_findbuf_ok	; exit if contents already valid
	push	hl			; save buffer address
	ld	e,(iy+fbh_sector)
	ld	d,(iy+fbh_sector+1)
	ld	c,(iy+fbh_sector+2)
	ld	b,(iy+fbh_sector+3)	; BCDE=sector
	call	PACKAGE_FS_SECTOR_READ	; read sector
	pop	hl			; retrieve buffer address
	jr	c,buf_findbuf_ok	; exit if no error
	res	bufflag_inuse,(iy+fbh_flags)	; not valid if error
.buf_findbuf_ok
	pop	iy
	ret


; ***************************************************************************
; * Subroutine to write the MRU buffer                                      *
; ***************************************************************************
; On exit, Fc=1 (success) or Fc=0 and A=error.
; ABCDEHLIX corrupted.
; IX is changed to the partition handle of the MRU buffer.
; Enter at buf_writeany to write a specific buffer (A) without setting as MRU

.buf_writebuf
	ld	a,(buf_mrulist)
.buf_writeany
	push	iy
	push	af
	call	buf_gethandle		; get buffer handle
	ld	a,(iy+fbh_phandle)	; get partition handle to IX
	ld	ixl,a
	ld	a,(iy+fbh_phandle+1)
	ld	ixh,a
	pop	af
	call	buf_getaddress		; get address in HL
	res	bufflag_upd,(iy+fbh_flags)	; clear update flag
	ld	e,(iy+fbh_sector)	; get sector to BCDE
	ld	d,(iy+fbh_sector+1)
	ld	c,(iy+fbh_sector+2)
	ld	b,(iy+fbh_sector+3)
	pop	iy
	jp	PACKAGE_FS_SECTOR_WRITE	; write sector and exit with error status


; ***************************************************************************
; * Flag the MRU buffer as updated                                          *
; ***************************************************************************
; ADE corrupted.

.buf_update
	push	iy
	ld	a,(buf_mrulist)
	call	buf_gethandle		; get MRU buffer handle
	set	bufflag_upd,(iy+fbh_flags)	; set update flag
	pop	iy
	ret


; ***************************************************************************
; * Flush a single updated buffer                                           *
; ***************************************************************************
; On entry, A=buffer ID
; On exit, IY=buffer handle
;      Fc=1 (success)
;      or, Fc=0 (failure) and A=error
; ADEHL corrupted.

.buf_flushone
	push	af
	call	buf_gethandle
	pop	af
	scf
	bit	bufflag_upd,(iy+fbh_flags)
	ret	z
	bit	bufflag_inuse,(iy+fbh_flags)
	ret	z
	push	bc
	call	buf_writeany		; write the buffer
	pop	bc
	ret


; ***************************************************************************
; * Flush any updated buffers                                               *
; ***************************************************************************
; On exit, Fc=1 (success)
;      or, Fc=0 (failure) and A=error
; ABCDEHL corrupted.

.buf_flushbuffers
	push	ix
	push	iy
	ld	b,buf_numbufs
.buf_flush_loop
	ld	a,buf_numbufs
	sub	b			; A=buffer number
	call	buf_flushone
	jr	nc,buf_flush_error	; exit if error
	djnz	buf_flush_loop		; else do others
.buf_flush_error
	pop	iy
	pop	ix
	ret

