; FAT access

	module	fat_fat
	
include	"#idedos.def"
include	"#p3dos.def"
include	"#packages.def"
include	"fatfs.def"
	
	; In fat_buffers.asm
	xref	buf_findbuf
	xref	buf_writebuf
	
	; Our exports
	xdef	fat_readfat
	xdef	fat_writefat


; TBD: Add support for FAT12 (perhaps)
;      (Note that cluster calls assume FAT16 cluster IDs, so must translate)

; TBD: May be more efficient if writefat just marks buffer as updated, with
;      extra bit set to signify part of FAT (so flushone writes all copies).
;      Then can potentially avoid lots of writes of FAT.


; ***************************************************************************
; * Read FAT entry                                                          *
; ***************************************************************************
; On entry, IX=partition handle & BC=cluster number
; On exit, BC=contents of FAT entry, Fc=1 (success)
; Or, Fc=0, failure (A=error)
; ADEHL corrupted.

.fat_readfat
	bit	7,(ix+fph_fattype)	; FAT12 or FAT16?
	jr	z,fat_readfat12
	ld	a,(ix+fph_fatsize+1)
	and	a
	jr	nz,fat_readfat16_inrange ; >255 sectors per FAT, so must be OK
	ld	a,b
	cp	(ix+fph_fatsize)
	ld	a,rc_seek
	ret	nc			; exit with seek error if FAT too small
.fat_readfat16_inrange	
	push	bc			; save cluster number
	ld	l,(ix+fph_fat1_start)
	ld	h,(ix+fph_fat1_start+1)
	ld	a,(ix+fph_fat1_start+2)	; AHL=start of FAT1
	ld	e,b
	ld	d,0			; DE=sector offset within FAT
	ld	b,(ix+fph_fat_copies)	; B=copies of FAT to try
.fat_readfat16_trynext	
	add	hl,de
	adc	a,0			; AHL=sector in FAT containing entry
	ex	de,hl
	ld	c,a
	ld	b,0			; BCDE=sector to read
	push	de			; save in case of read error
	push	bc
	call	buf_findbuf		; get HL=address of sector in memory
	pop	bc
	pop	de			; restore sector number & copies
	jr	c,fat_readfat16_ok	; on if no error
	dec	b
	jr	z,fat_readfat16_error	; no copies left to try
	ex	de,hl
	ld	a,c			; AHL=sector number (current FAT)
	ld	e,(ix+fph_fatsize)
	ld	d,(ix+fph_fatsize+1)	; DE=offset to next FAT
	jr	fat_readfat16_trynext	; try another
.fat_readfat16_error
	pop	bc			; discard cluster number
	ret				; exit with Fc=0, A=error
.fat_readfat16_ok
	pop	bc			; restore cluster number
	ld	b,0
	add	hl,bc
	add	hl,bc			; HL=address of FAT entry
	ld	c,(hl)
	inc	hl
	ld	b,(hl)			; BC=contents of FAT entry
	scf				; success!
	ret
.fat_readfat12
.fat_writefat12
	ld	a,rc_notimp		; FAT12 not yet implemented
	and	a
	ret
	
	
; ***************************************************************************
; * Write FAT entry                                                         *
; ***************************************************************************
; On entry, IX=partition handle, BC=cluster number, DE=data to write
; On exit, Fc=1 for success
; or Fc=0, A=error
; ABCDEHL corrupted.

.fat_writefat
	push	de			; save data to write
	push	bc			; save cluster number
	call	fat_readfat		; read the FAT entry
	pop	bc
	pop	de
	ret	nc			; exit with any error

	; At this point, the MRU buffer contains the FAT sector to modify
	; (For FAT12, this may be the 2nd of 2 sectors, in which case
	;  the first will be in the next MRU buffer).
	; For FAT16, HL=high byte of data to modify
	; For FAT12, ??

	bit	7,(ix+fph_fattype)	; FAT12 or FAT16?
	jr	z,fat_writefat12
	ld	(hl),d			; modify entry
	dec	hl
	ld	(hl),e
	ld	d,0
	ld	e,b			; DE=sector offset within FAT
	ld	b,d
	and	a
	sbc	hl,bc
	sbc	hl,bc			; HL=sector buffer start
	push	hl			; save buffer address
	ld	l,(ix+fph_fat1_start)
	ld	h,(ix+fph_fat1_start+1)
	ld	a,(ix+fph_fat1_start+2)	; AHL=start of FAT1
	ld	b,(ix+fph_fat_copies)	; B=copies of FAT to write
.fat_writefat16_donext	
	add	hl,de
	adc	a,0			; AHL=sector in FAT containing entry
	ex	de,hl
	pop	hl			; HL=buffer address
	push	hl			; resave
	ld	c,a
	push	bc			; save B=copies to write, C=sector high
	ld	b,0			; BCDE=sector to write
	push	de			; save sector low
	call	PACKAGE_FS_SECTOR_WRITE	; write the sector
	
	; TBD: remove any copies held in buffers? Should be okay, as we should
	;      never have more than the 1st readable copy.
	
	pop	hl			; sector low
	pop	bc			; sector high, copies
	dec	b
	jr	z,fat_writefat16_end	; finished all copies
	ld	a,c			; AHL=sector number (current FAT)
	ld	e,(ix+fph_fatsize)
	ld	d,(ix+fph_fatsize+1)	; DE=offset to next FAT
	jr	fat_writefat16_donext	; back for remaining FAT copies
.fat_writefat16_end
	pop	hl			; discard buffer address
	ret				; exit with success/error
					; TBD: Should succeed if *any* copy written OK
