; FAT directories

	module	fat_dirs
	
include	"#idedos.def"
include	"#p3dos.def"
include	"#residos.def"
include	"fatfs.def"

	; In fat_buffers.asm
	xref	buf_findbuf
	xref	buf_writebuf
	
	; In fat_cluster.asm
	xref	clus_readtobuf
	xref	clus_nextsector
	xref	clus_extendchain
	xref	clus_erase
	xref	clus_allocate
	
	; In fat_drives.asm
	xref	drive_getdirhandle
	xref	drive_getdircopy

	; In fat_files.asm
	xref	file_delete_currententry
	xref	file_create_entry

	; Our exports
	xdef	dir_root
	xdef	dir_home
	xdef	dir_change
	xdef	dir_next
	xdef	dir_getentry
	xdef	dir_entrydetails
	xdef	dir_getfree
	xdef	dir_findvolumelabel
	xdef	dir_parsefilename
	xdef	dir_matchname
	xdef	dir_getfirstmatch
	xdef	dir_getcurrentmatch
	xdef	dir_getnextmatch
	xdef	dir_catalog
	xdef	dir_path
	
	
; ***************************************************************************
; * Initialise directory handle to root of current partition                *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle
; On exit, Fc=1 (success)
; A corrupted.

.dir_root	
	ld	a,ixl			; set partition handle
	ld	(iy+fdh_phandle),a
	ld	a,ixh
	ld	(iy+fdh_phandle+1),a
	set	7,(iy+fdh_flags)	; signal root directory
	xor	a
	ld	(iy+fdh_clusstart),a	; set start sector offset to zero
	ld	(iy+fdh_clusstart+1),a

	; Fall into dir_home to set current entry to first
	
	
; ***************************************************************************
; * "Home" directory handle to first entry                                  *
; ***************************************************************************
; On entry, IY=directory handle
; On exit, Fc=1 (success)
; A corrupted.

.dir_home
	ld	a,(iy+fdh_clusstart)	; copy start cluster (0 for root)
	ld	(iy+fdh_cluster),a
	ld	a,(iy+fdh_clusstart+1)
	ld	(iy+fdh_cluster+1),a
	xor	a
	ld	(iy+fdh_sector),a	; zero sector offset
	ld	(iy+fdh_entry),a	; and entry within sector
	scf				; success!
	ret


; ***************************************************************************
; * Change directory to current entry                                       *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle
; On exit, Fc=1 (success)
; or, Fc=0 (failure) and A=error
; ABCDEHL corrupted.

.dir_change
	call	dir_entrydetails	; get details
	ret	nc			; exit if error
	jr	z,dir_change_badentry	; no good if free entry
	bit	dirattr_dir,a
	jr	z,dir_change_badentry	; no good if not directory
	ld	bc,direntry_cluster
	add	hl,bc
	ld	c,(hl)
	inc	hl
	ld	b,(hl)			; BC=directory start cluster
	ld	a,b
	or	c
	jr	z,dir_root		; set root directory if necessary
	ld	(iy+fdh_clusstart),c
	ld	(iy+fdh_clusstart+1),b	; set start cluster
	res	7,(iy+fdh_flags)	; signal subdirectory
	jr	dir_home		; home to first entry
.dir_change_badentry
	ld	a,rc_notdir
	and	a			; Fc=0
	ret

	
; ***************************************************************************
; * Move to next directory entry                                            *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle
; On exit, Fc=1 (success)
; or, Fc=0 (failure) and A=error
; ABCDEHL corrupted.

.dir_next
	inc	(iy+fdh_entry)		; increment entry number
	bit	4,(iy+fdh_entry)	; Fz=1 if entry < 16
	scf				; success!
	ret	z			; exit if still in same sector
	bit	7,(iy+fdh_flags)	; root directory?
	jr	nz,dir_next_root
	ld	c,(iy+fdh_cluster)
	ld	b,(iy+fdh_cluster+1)
	ld	a,(iy+fdh_sector)
	call	clus_nextsector		; increment to next sector
	ret	nc			; exit if error
	ld	(iy+fdh_cluster),c	; store new location in handle
	ld	(iy+fdh_cluster+1),b
	ld	(iy+fdh_sector),a
	ld	(iy+fdh_entry),0	; first entry in sector
	ret				; exit with Fc=1, success
.dir_next_root
	ld	c,(iy+fdh_cluster)
	ld	b,(iy+fdh_cluster+1)	; BC=sector offset
	inc	bc			; move to next
	ld	l,(ix+fph_rootsize)
	ld	h,(ix+fph_rootsize+1)	; HL=number of sectors in root
	dec	hl			; HL=max sector offset
	and	a
	sbc	hl,bc			; Fc=1 if sector too large
	ld	a,rc_dirfull
	ccf
	ret	nc			; exit if error
	ld	(iy+fdh_cluster),c	; update sector offset
	ld	(iy+fdh_cluster+1),b
	ld	(iy+fdh_entry),0	; first entry in sector
	ret				; exit with Fc=1, success
	

; ***************************************************************************
; * Get address of current entry                                            *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle
; On exit, Fc=1 (success) and HL=address
; or, Fc=0 (failure) and A=error
; ABCDE corrupted.

.dir_getentry
	bit	7,(iy+fdh_flags)	; root directory?
	jr	nz,dir_getentry_root
	ld	c,(iy+fdh_cluster)
	ld	b,(iy+fdh_cluster+1)
	ld	a,(iy+fdh_sector)
	call	clus_readtobuf		; get sector to buffer
.dir_getentry_formaddr
	ret	nc			; exit if error
	ld	e,(iy+fdh_entry)
	ld	d,0			; DE=entry number
	ex	de,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl
	add	hl,hl			; HL=32*entry number
	add	hl,de			; HL=address
	scf				; success!
	ret
.dir_getentry_root
	ld	l,(ix+fph_root_start)
	ld	h,(ix+fph_root_start+1)
	ld	a,(ix+fph_root_start+2)
	ld	c,(iy+fdh_cluster)
	ld	b,(iy+fdh_cluster+1)
	add	hl,bc
	adc	a,0			; AHL=sector to read
	ex	de,hl
	ld	c,a
	ld	b,0			; BCDE=sector to read
	call	buf_findbuf		; read the sector
	jr	dir_getentry_formaddr


; ***************************************************************************
; * Examine current entry                                                   *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle
; On exit, Fc=1 (success), HL=entry address,
;  Fz=1 if unused entry, otherwise A=attributes byte
; or, Fc=0 (failure) and A=error
; ABCDEHL corrupted.

.dir_entrydetails
	call	dir_getentry		; locate entry
	ret	nc			; exit if error
	ld	a,(hl)
	and	a			; free entry if zero
	scf
	ret	z			; exit with Fc=1, Fz=1 if unused
	cp	direntry_deleted
	scf
	ret	z			; or if deleted
	push	hl
	ld	bc,direntry_attr
	add	hl,bc
	ld	a,(hl)			; A=attributes byte
	pop	hl			; restore HL=entry address
	scf				; success!
	ret
	

; ***************************************************************************
; * Get free entry                                                          *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle
; On exit, Fc=1 (success), HL=entry address
; or, Fc=0 (failure) and A=error
; ABCDE corrupted.
; TBD: Could be more efficient if maintained a "last allocated" as per clusters.

.dir_getfree
	call	dir_home		; start at top of directory
.dir_getfree_loop
	call	dir_entrydetails	; check current entry
	ret	nc			; exit if error
	ret	z			; exit if entry is available
	call	dir_next		; next entry
	jr	c,dir_getfree_loop	; keep going until out of entries
	bit	7,(iy+fdh_flags)	; root directory?
	ret	nz			; if so, exit with directory full error
	ld	c,(iy+fdh_cluster)
	ld	b,(iy+fdh_cluster+1)	; BC=last cluster in directory
	call	clus_extendchain	; add another
	ret	nc			; exit if error
	ld	(iy+fdh_cluster),c	; store new cluster
	ld	(iy+fdh_cluster+1),b
	xor	a
	ld	(iy+fdh_sector),a	; set first entry in new cluster
	ld	(iy+fdh_entry),a
	jp	clus_erase		; erase cluster, exiting with HL=address
					;  of first entry in first sector
	

; ***************************************************************************
; * Find volume label                                                       *
; ***************************************************************************
; On entry, IX=partition handle
; On exit, Fc=1 (success), Fz=1 if not found, IY=dirhandle
;                          Fz=0 if found and HL=entry address, IY=dirhandle
; or, Fc=0 (failure) and A=error
; ABCDE corrupted.
	
.dir_findvolumelabel
	ld	iy,sys_directory
	call	dir_root		; get root directory
	ret	nc
.dir_fvl_loop
	call	dir_entrydetails	; get entry details
	ret	nc
	jr	z,dir_fvl_next		; skip unused entries
	bit	dirattr_vol,a		; is it a volume label?
	jr	z,dir_fvl_next
	and	dirattr_lfn		; ignore long filenames
	cp	dirattr_lfn
	scf
	ret	nz			; if not, exit with Fc=1, Fz=0 (found), HL=addr
.dir_fvl_next
	call	dir_next		; move to next entry
	jr	c,dir_fvl_loop
	cp	rc_dirfull		; was error directory full?
	scf
	ret	z			; exit with Fc=1, Fz=1 (not found) if so
	ccf
	ret				; else exit with error
	

; ***************************************************************************
; * Validate character                                                      *
; ***************************************************************************
; On entry, A=character
; On exit, Fc=1 (valid), A=character (possibly modified)
; If invalid, Fc=0, A=rc_badname
; Nothing corrupted.

.dir_validchar
	cp	'a'
	jr	c,dir_validchar_notlower
	cp	'z'+1
	jr	nc,dir_validchar_notlower
	and	$df			; make uppercase
	scf				; now valid
	ret
.dir_validchar_notlower
	cp	'A'
	jr	c,dir_validchar_notupper
	cp	'Z'+1
	ret	c			; valid if uppercase
.dir_validchar_notupper
	cp	'0'
	jr	c,dir_validchar_notdigit
	cp	'9'+1
	ret	c			; valid if digit
.dir_validchar_notdigit
	push	hl
	push	bc
	ld	hl,miscvalidchars	; table of other valid characters
	ld	b,miscvalidchars_end-miscvalidchars
.dir_validchar_miscloop
	cp	(hl)
	scf				; valid
	jr	z,dir_validchar_ismisc	; okay if matches a misc character
	inc	hl
	djnz	dir_validchar_miscloop
	ld	a,rc_badname		; bad filename
	and	a			; Fc=0
.dir_validchar_ismisc
	pop	bc
	pop	hl
	ret

; TBD: These need checking.
.miscvalidchars
	defm	" !#$%^&'()-@_[]{}~"
.miscvalidchars_end
	

; ***************************************************************************
; * Parse filename                                                          *
; ***************************************************************************
; On entry, DE=address of filename/wildcard, $ff-terminated,
;           HL=address to place parsed 11-byte filespec
; On exit, Fc=1 (success), Fz=0 if wildcards used, Fs=1 if filename present
;          A=drive letter (or default)
;          IY=directory handle, IX=partition handle
; or Fc=0 and A=error (bad filename).
; ABCDE corrupted.

; Drive is held internally in C. This is an upper-case letter A-P, for
; which bit 7=0, bit 6=1, bit 5=0 always. Therefore we use bit 7 to
; indicate whether there was a filename segment (after the path)
; and bit 6 to indicate whether wildcards were present.
; Bit 7 is in the same location as the S (sign) flag.
; Bit 6 is in the same location as the Z (zero) flag.

.dir_parsefilename
	ld	a,(fat_defdrive)	; default drive, no wildcards
	ld	c,a			; C=drive
	push	de			; save start address
	ld	a,(de)			; get first char
	inc	de
	cp	'1'			; user area 1 or 10-15?
	jr	nz,dir_parsefilename_lowuser
	ld	a,(de)			; get 2nd user area character
	inc	de
.dir_parsefilename_lowuser
	cp	'0'
	jr	c,dir_parsefilename_nodrive
	cp	'9'+1
	jr	nc,dir_parsefilename_trydrive
	ld	a,(de)
	inc	de
.dir_parsefilename_trydrive
	call	dir_validchar		; drive letter now uppercase
	jr	nc,dir_parsefilename_nodrive
	cp	'A'
	jr	c,dir_parsefilename_nodrive
	cp	'P'+1
	jr	nc,dir_parsefilename_nodrive
	ld	b,a			; save drive from spec
	ld	a,(de)
	inc	de
	cp	':'			; should be : if drive/user
	jr	nz,dir_parsefilename_nodrive
	ld	c,b			; set drive
	pop	af			; discard saved address
	jr	dir_parsefilename_gooddrive
.dir_parsefilename_nodrive
	pop	de			; restore start address
.dir_parsefilename_gooddrive
	push	bc
	push	de
	push	hl
	ld	a,c
	call	drive_getdircopy	; IY=copy of dirhandle, IX=parthandle
	pop	hl
	pop	de
	pop	bc
	ret	nc			; exit if error getting handles
	ld	a,(de)
	cp	'/'			; is root directory wanted?
	jr	z,dir_parsefilename_root
	cp	'\'
	jr	nz,dir_parsefilename_segment
.dir_parsefilename_root
	inc	de			; skip '\' or '/'
	call	dir_root		; change to root
.dir_parsefilename_segment
	res	7,c			; no filename part
	push	hl			; save start of destination
	ld	b,11
.dir_parsefilename_blankspec
	ld	(hl),' '		; erase the filespec
	inc	hl
	djnz	dir_parsefilename_blankspec
	pop	hl			; re-fetch & save destination
	push	hl
	ld	a,(de)
	cp	' '			; check first character not blank
	jr	z,dir_parsefilename_badname
	cp	'.'			; check for . or .. directories
	jr	z,dir_parsefilename_dots
	ld	b,8
.dir_parsefilename_name
	ld	a,(de)
	cp	$ff
	jr	z,dir_parsefilename_skiptoext
	set	7,c			; filename is present
	cp	'.'
	jr	z,dir_parsefilename_skiptoext
	inc	de
	cp	'*'
	jp	z,dir_parsefilename_wildname
	cp	'?'
	jp	z,dir_parsefilename_wildnamechar
	cp	'/'
	jr	z,dir_parsefilename_nextsegment
	cp	'\'
	jr	z,dir_parsefilename_nextsegment
	call	dir_validchar		; make uppercase, check valid
	jr	nc,dir_pfn_exit		; exit if not valid
.dir_parsefilename_storename
	ld	(hl),a			; place in buffer
	inc	hl
	djnz	dir_parsefilename_name
.dir_parsefilename_doext
	ld	b,3			; characters in extension part
	ld	a,(de)
	inc	de
	cp	$ff			; no extension
	jr	z,dir_parsefilename_end
	cp	'.'			; an extension must be present
	jr	nz,dir_parsefilename_badname
.dir_parsefilename_ext
	ld	a,(de)			; get next part of extension
	inc	de
	cp	'*'			; skip rest of ext for '*'
	jr	z,dir_parsefilename_wildext
	cp	'?'			; skip this char for '?'
	jp	z,dir_parsefilename_wildextchar
	cp	'/'
	jr	z,dir_parsefilename_nextsegment
	cp	'\'
	jr	z,dir_parsefilename_nextsegment
	cp	$ff			; rest of ext must be blank
	jr	z,dir_parsefilename_end
	call	dir_validchar		; make uppercase, check valid
	jr	nc,dir_pfn_exit		; exit if not valid
.dir_parsefilename_storeext
	ld	(hl),a			; place in buffer
	inc	hl
	djnz	dir_parsefilename_ext
	ld	a,(de)
	cp	$ff			; last character must be terminator
	jp	nz,dir_parsefilename_badname
.dir_parsefilename_end
	ld	b,c			; B=drive, with bits 7/6 corrupted
	res	7,b			; reset bit 7
	set	6,b			; and set bit 6
	set	0,c			; ensure bit 0 (Fc) is set
	push	bc
	pop	af			; A=drive, Fc=1, Fz=wildcard flag, Fs=filename flag
.dir_pfn_exit
	pop	hl			; discard destination start
	ret
.dir_parsefilename_badname
	pop	hl			; restore destination
	ld	a,rc_badname		; exit with bad filename error
	and	a
	ret
	
.dir_parsefilename_skiptoext
	ld	(hl),' '
	inc	hl
	djnz	dir_parsefilename_skiptoext
	jr	dir_parsefilename_doext

.dir_parsefilename_dots
	set	7,c			; filename is present
	ld	(hl),a			; transfer 1st dot
	inc	de
	inc	hl
	ld	a,(de)
	cp	'.'			; is 2nd char also a dot?
	jr	nz,dir_parsefilename_dotone
	ld	(hl),a			; transfer 2nd dot
	inc	de
.dir_parsefilename_dotone
	ld	a,(de)
	inc	de
	cp	'/'			; must be end of segment or filename
	jr	z,dir_parsefilename_nextsegment
	cp	'\'
	jr	z,dir_parsefilename_nextsegment
	cp	$ff
	jr	z,dir_parsefilename_end
	jp	dir_parsefilename_badname

.dir_parsefilename_nextsegment
	bit	6,c			; no wildcards in paths, please
	jp	z,dir_parsefilename_badname
	pop	hl			; HL=spec for current segment
	push	bc
	push	de
	push	hl
	ex	de,hl
	call	dir_getfirstmatch	; find the directory
	jr	nc,dir_parsefilename_nextsegment_error
	ccf
	ld	a,rc_notdir
	call	z,dir_change		; if successful, change to it
.dir_parsefilename_nextsegment_error
	pop	hl
	pop	de
	pop	bc
	ret	nc			; exit if error
	jp	dir_parsefilename_segment

.dir_parsefilename_wildname
	ld	(hl),'?'		; fill with ?
	inc	hl
	djnz	dir_parsefilename_wildname
	res	6,c			; wildcards present
	jp	dir_parsefilename_doext
.dir_parsefilename_wildnamechar
	res	6,c			; wildcards present
	jp	dir_parsefilename_storename
.dir_parsefilename_wildext
	ld	(hl),'?'		; fill with ?
	inc	hl
	djnz	dir_parsefilename_wildext
	res	6,c			; wildcards present
	jr	dir_parsefilename_end
.dir_parsefilename_wildextchar
	res	6,c			; wildcards present
	jr	dir_parsefilename_storeext
	

; ***************************************************************************
; * Check filename match                                                    *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle, DE=11-byte filespec
; On exit, Fc=1 if successful, and Fz=1 if current entry matches
; or, Fc=0 and A=error
; ABCDEHL corrupted.

.dir_matchname
	push	de
	call	dir_entrydetails	; get HL=entry address
	pop	de
	ret	nc			; exit if error
	jr	z,dir_matchname_nomatch	; no match if free entry
	bit	dirattr_vol,a
	ret	nz			; no match if volume label
	ld	b,11			; 11 bytes to match
.dir_matchname_loop
	ld	a,(de)			; next match char
	inc	de
	cp	'?'			; wild char always matches
	jr	z,dir_matchname_matchchar
	cp	(hl)
	scf
	ret	nz			; exit if match fails
.dir_matchname_matchchar
	inc	hl
	djnz	dir_matchname_loop
	xor	a			; Fz=1, match
	scf				; success!
	ret
.dir_matchname_nomatch
	xor	a
	inc	a			; Fz=0, no match
	scf				; success
	ret


; ***************************************************************************
; * Find next filename match                                                *
; ***************************************************************************
; On entry, IY=directory handle, IX=partition handle, DE=11-byte filespec
; Enter at dir_getfirstmatch to start with first entry in directory,
;       or dir_getcurrentmatch to start with current entry in directory,
;       or dir_getnextmatch to start with next entry
; to skip current entry.
; On exit, Fc=1 (success), Fz=1 if matched (now current entry), or Fz=0 if not
; or, Fc=0 (failure) and A=error
; ABCHL corrupted.

.dir_getfirstmatch
	call	dir_home
	ret	nc
.dir_getcurrentmatch
	push	de
	call	dir_matchname		; does current entry match?
	pop	de
	ret	z			; exit if match
	ret	nc			; or if error
.dir_getnextmatch
	push	de
	call	dir_next		; get next entry
	pop	de
	jr	c,dir_getcurrentmatch
	xor	a
	inc	a			; Fz=0, no match
	scf				; success
	ret


; ***************************************************************************
; * FAT_CATALOG                                                             *
; ***************************************************************************
; Entry: B=buffer size in entries, >=2
;        C=filter, bit 0=include system files if set
;        DE=address of buffer (1st entry initialised)
;        HL=address of filespec (wildcards allowed)
; Exit: Fc=1 (success), B=number of completed entries (inc preloaded)
;       Fc=0 (failure), A=error
; ACDEHLIXIY corrupt

; Uses attribute f8 to indicate if entry is a directory.
; Uses attribute t1 to indicate system (as normal) OR hidden.
; If no filename part is present after path, uses *.* as filespec (as +3DOS).

; TBD: Gives large filesizes as 65535K, so ResiDOS should query correct size?
; TBD: Doesn't sort alphabetically, as per +3DOS spec

defc	CATENTRY_SIZE=$0d

.dir_catalog
	ld	a,1			; just pre-loaded entry "so far"
	push	af
	push	bc
	push	de
	ex	de,hl
	ld	hl,dir_filespec1
	call	dir_parsefilename	; parse the filespec (wildcards ok), and get handles
	jp	nc,dir_catalog_fail
	jp	m,dir_catalog_gotname	; Fs=1 if a filename part was found
	ld	b,11
	ld	hl,dir_filespec1
.dir_catalog_allfiles
	ld	(hl),'?'		; else use ??????????? (*.*)
	inc	hl
	djnz	dir_catalog_allfiles
.dir_catalog_gotname
	pop	hl
	push	hl
	ld	a,(hl)
	and	a
	jr	z,dir_catalog_new	; zeroised pre-loaded, so fresh catalog
	ld	b,11
	ld	de,dir_filespec2
.dir_catalog_clearattrs
	ld	a,(hl)
	inc	hl
	res	7,a			; copy pre-loaded, masking off attribs
	ld	(de),a
	inc	de
	djnz	dir_catalog_clearattrs
	ld	de,dir_filespec2
	call	dir_matchname		; does current entry match pre-loaded?
	jp	nc,dir_catalog_fail
	jr	z,dir_catalog_preloadok	; if so, move on
	ld	de,dir_filespec2
	call	dir_getfirstmatch	; if not, find the one we were on
	jp	nc,dir_catalog_fail
	jr	z,dir_catalog_preloadok	; on if found it
.dir_catalog_nomatch
	pop	de			; discard stuff
	pop	de
	pop	bc			; B=entries
	scf				; success!
	ret
.dir_catalog_new
	call	dir_home		; start at the first entry
	jp	nc,dir_catalog_fail
	jr	dir_catalog_begin
.dir_catalog_preloadok
	call	dir_next		; skip to next entry
	jp	nc,dir_catalog_fail
.dir_catalog_begin
	pop	hl
	ld	bc,CATENTRY_SIZE
	add	hl,bc			; HL=second buffer entry
	push	hl
.dir_catalog_loop
	ld	de,dir_filespec1
	call	dir_getcurrentmatch	; find another match
	jp	nc,dir_catalog_fail
	jr	nz,dir_catalog_nomatch
	call	dir_entrydetails	; HL=entry, A=attribs
	jp	nc,dir_catalog_fail
	pop	de			; DE=buffer address
	pop	bc			; C=filter
	push	bc
	bit	0,c
	jr	nz,dir_catalog_filterok	; including system files
	bit	dirattr_sys,a		; don't show system files
	jr	nz,dir_catalog_filterbad
	bit	dirattr_hid,a		; or hidden files
	jr	z,dir_catalog_filterok
.dir_catalog_filterbad
	push	de
	jr	dir_catalog_next	; skip current if filtered
.dir_catalog_filterok
	ld	bc,7
	ldir				; copy first 7 bytes of filename to buffer
	ld	c,a			; C=attributes
	ld	a,(hl)			; last filename char
	inc	hl
	bit	dirattr_dir,c		; directory?
	jr	z,dir_catalog_fn8
	set	7,a			; set bit 7 of f8 if so
.dir_catalog_fn8
	ld	(de),a
	inc	de
	ld	a,(hl)			; first extension char
	inc	hl
	bit	dirattr_ro,c		; read-only?
	jr	z,dir_catalog_ext1
	set	7,a			; set bit 7 of t1 if so
.dir_catalog_ext1
	ld	(de),a
	inc	de
	ld	a,(hl)			; 2nd extension char
	inc	hl
	bit	dirattr_sys,c		; system?
	jr	nz,dir_catalog_system
	bit	dirattr_hid,c		; or hidden?
	jr	z,dir_catalog_ext2
.dir_catalog_system
	set	7,a			; set bit 7 of t2 if so
.dir_catalog_ext2
	ld	(de),a
	inc	de
	ld	a,(hl)			; 3rd extension char
	inc	hl
	bit	dirattr_arc,c		; archived?
	jr	z,dir_catalog_ext3
	set	7,a			; set bit 7 of t3 if so
.dir_catalog_ext3
	ld	(de),a
	inc	de	
	ld	bc,direntry_filesize-direntry_attr
	add	hl,bc			; point to filesize
	ld	a,(hl)
	inc	hl
	add	a,255			; add 1023, to round up to nearest 1K
	ld	a,(hl)
	inc	hl
	adc	a,3
	ld	c,a
	ld	a,(hl)
	inc	hl
	adc	a,0
	ld	b,a
	ld	a,(hl)
	adc	a,0			; ABC=(filesize+1023)/256, in bytes
	srl	a
	rr	b
	rr	c
	srl	a
	rr	b
	rr	c			; ABC=filesize, in K
	and	a
	jr	z,dir_catalog_sizeok	; okay if 65535K or less
	ld	bc,$ffff		; else "approximate" to 65535K
.dir_catalog_sizeok
	ex	de,hl
	ld	(hl),c			; store in buffer
	inc	hl
	ld	(hl),b
	inc	hl			; HL=next buffer entry
	ex	de,hl
	pop	bc
	pop	af
	inc	a			; 1 more entry added
	cp	b			; is buffer full yet?
	scf
	ret	z			; done if so
	push	af
	push	bc
	push	de
.dir_catalog_next
	call	dir_next		; skip to next entry
	jp	c,dir_catalog_loop
	cp	rc_eof
	jp	z,dir_catalog_nomatch	; finish if end of directory
	cp	rc_dirfull
	jp	z,dir_catalog_nomatch	; (end of root directory)
.dir_catalog_fail
	and	a			; Fc=0, fail
	pop	de
	pop	de
	pop	de
	ret


; ***************************************************************************
; * FAT_PATH                                                                *
; ***************************************************************************
; Entry: HL=address of path (also address of 256-byte buffer for rc_path_get).
;	 A=reason code
; Exit: Fc=1 (success)
;       Fc=0 (failure), A=error
; ACDEHLIXIY corrupt

.dir_path
	cp	rc_path_change
	jr	z,dir_path_change
	cp	rc_path_delete
	jr	z,dir_path_delete
	cp	rc_path_make
	jp	z,dir_path_make
	cp	rc_path_get
	jp	z,dir_path_get
	ld	a,rc_notimp
	and	a
	ret

.dir_path_change
	ex	de,hl
	ld	hl,dir_filespec1
	call	dir_parsefilename	; parse the filespec, and get handles
	ret	nc			; exit if error
	push	af			; save sign flag
	push	iy			; save pathed directory handle
	call	drive_getdirhandle
	push	iy
	pop	de			; DE=current directory handle
	pop	iy			; IY=pathed directory handle
	jr	nc,dir_path_change_fail	; exit if error
	pop	af			; restore sign flag, telling whether filename part present
	jp	p,dir_path_change_pathonly	; only a path, so skip the change
	push	de			; save current directory handle
	ld	de,dir_filespec1
	call	dir_getfirstmatch	; find the directory to change to
	pop	de
	ret	nc			; exit if error
	ld	a,rc_notdir
	ccf
	ret	nz			; exit if not found
	push	de
	call	dir_change		; if successful, change to it
	pop	de
.dir_path_change_pathonly
	push	iy
	pop	hl
	ld	bc,fdh_size
	ldir				; copy to current directory handle
	ret				; exit with any error from dir_change
.dir_path_change_fail
	pop	de			; discard flag
	ret


.dir_path_delete
	ex	de,hl
	ld	hl,dir_filespec1
	call	dir_parsefilename	; parse the filespec, and get handles
	ret	nc			; exit if error
	ccf
	ld	a,rc_badname
	ret	nz			; or if wildcard present
	ret	p			; or if no filename part
	ld	de,dir_filespec1
	call	dir_getfirstmatch	; find the directory to delete
	ret	nc			; exit if error
	ld	a,rc_notdir
	ccf
	ret	nz			; exit if not found
	push	iy
	pop	hl
	ld	de,sys_directory2
	ld	bc,fdh_size
	ldir				; copy to 2nd directory handle
	call	dir_change		; enter the directory
	ret	nc
.dir_path_delete_checkempty
	call	dir_entrydetails	; get next entry details
	ret	nc
	jr	z,dir_path_delete_blankentry	; okay if unused
	ld	a,(hl)
	cp	'.'
	ld	a,rc_dirfull
.dir_path_delete_error
	scf
	ccf
	ret	nz			; error if not "." or ".." entry
.dir_path_delete_blankentry
	call	dir_next
	jr	c,dir_path_delete_checkempty
	ld	iy,sys_directory2	; back to directory handle of parent
	call	dir_getentry		; HL=entry address of directory
	ret	nc
	jp	file_delete_currententry	; delete it and exit

.dir_path_make
	ex	de,hl
	ld	hl,dir_filespec1
	call	dir_parsefilename	; parse the filespec, and get handles
	ret	nc			; exit if error
	ccf
	ld	a,rc_badname
	ret	nz			; or if wildcard present
	ret	p			; or if no filename part
	call	file_create_entry	; create an entry for the new directory
	ret	nc			; exit if error
	call	clus_allocate		; allocate a new cluster
	ret	nc			; exit if error
	push	bc
	call	dir_getentry		; HL=address of entry
	ld	bc,direntry_attr
	add	hl,bc
	set	dirattr_dir,(hl)	; make it into a directory
	ld	bc,direntry_cluster-direntry_attr
	add	hl,bc
	pop	bc
	push	bc
	ld	(hl),c			; store cluster in directory entry
	inc	hl
	ld	(hl),b
	call	buf_writebuf		; write directory entry
	pop	bc
	ret	nc
	push	bc
	call	clus_erase		; erase the cluster, get HL=address of first entry
	pop	bc
	ret	nc
	push	hl
	ex	(sp),ix			; IX=address of entries
	set	dirattr_dir,(ix+direntry_attr)	; mark 1st two entries as directories
	set	dirattr_dir,(ix+direntry_attr+DIRENTRY_ENTRYSIZE)
	ld	(ix+direntry_cluster),c	; set directory's own cluster in 1st entry
	ld	(ix+direntry_cluster+1),b
	ld	c,(iy+fdh_clusstart)	; set parent's cluster in 2nd entry
	ld	b,(iy+fdh_clusstart+1)
	ld	(ix+direntry_cluster+DIRENTRY_ENTRYSIZE),c
	ld	(ix+direntry_cluster+1+DIRENTRY_ENTRYSIZE),b
	pop	ix			; restore partition handle
	ex	de,hl
	ld	hl,fspec_current
	ld	bc,11
	ldir				; copy filespec for "."
	ld	hl,DIRENTRY_ENTRYSIZE-11
	add	hl,de
	ex	de,hl			; DE=address of 2nd entry
	ld	hl,fspec_parent
	ld	bc,11
	ldir				; copy filespec for ".."
	jp	buf_writebuf		; write buffer and exit with any error

.dir_path_get
	ld	a,(hl)			; first 1-2 chars may be user area - just ignore
	inc	hl
	cp	'1'
	jr	nz,dir_path_get_lowuser
	ld	a,(hl)
	inc	hl
.dir_path_get_lowuser
	cp	'0'
	jr	c,dir_path_get_notuser
	cp	'9'+1
	jr	nc,dir_path_get_notuser
	ld	a,(hl)			; first char is drive
	inc	hl
.dir_path_get_notuser
	ld	c,a
	ld	a,(hl)
	inc	hl
	cp	':'
	jp	nz,dir_path_baddrive
	ld	a,(hl)
	cp	$ff
	jp	nz,dir_path_baddrive
	push	hl			; save HL; also destination
	ld	a,c			; A=drive
	call	drive_getdircopy	; IY=dirhandle copy, IX=partition handle for drive A
	pop	hl
	ret	nc			; exit if error
	ld	(hl),'/'		; append a segment delimiter
	inc	hl
	ld	(hl),$ff
	bit	7,(iy+fdh_flags)	; is this the root?
	scf
	ret	nz			; if so, exit with success
	dec	hl
	push	hl			; save earliest unusable address
	ld	de,253
	add	hl,de			; last usable address
	ld	(hl),$ff		; terminate
	dec	hl
.dir_path_nextparent
	push	hl			; save it
	ld	c,(iy+fdh_clusstart)
	ld	b,(iy+fdh_clusstart+1)	; get our start cluster
	push	bc
	ld	de,fspec_parent
	call	dir_getfirstmatch
	jr	nc,dir_path_get_error
	ld	a,rc_notdir
	ccf
	jr	nz,dir_path_get_error	; exit if not found
	call	dir_change		; change to parent directory
.dir_path_finddir
	jr	nc,dir_path_get_error
	call	dir_entrydetails
	jr	nc,dir_path_get_error
	jr	z,dir_path_blankentry	; skip unused entries
	ld	de,direntry_cluster
	add	hl,de			; HL points to cluster
	pop	bc
	push	bc
	ld	a,(hl)			; check if cluster matches ours
	inc	hl
	cp	c
	jr	nz,dir_path_blankentry
	ld	a,(hl)
	cp	b
	jr	z,dir_path_founddir
.dir_path_blankentry
	call	dir_next		; loop to find directory
	jr	dir_path_finddir
.dir_path_founddir
	ld	bc,0+(direntry_ext+2)-(direntry_cluster+1)
	add	hl,bc			; HL points to end of extension
	pop	bc			; discard cluster
	pop	de			; fetch destination address
	ex	(sp),iy			; IY=earliest unusable address
	ld	a,'/'
	ld	b,1
	call	dir_path_inserttextA	; insert delimiter
	ld	b,3
.dir_path_parseext
	ld	a,(hl)
	dec	hl
	cp	' '
	call	nz,dir_path_inserttextA
	djnz	dir_path_parseext
	ld	b,8
.dir_path_parsename
	ld	a,(hl)
	dec	hl
	cp	' '
	call	nz,dir_path_inserttextA
	djnz	dir_path_parsename
	ex	(sp),iy			; IY=dir handle
	ex	de,hl			; HL=current destination
	bit	7,(iy+fdh_flags)	; have we reached the root?
	jr	z,dir_path_nextparent	; back if not
	pop	de
	inc	de			; address to shift up path to
	inc	hl			; start at last character inserted
	ld	bc,253
	ldir				; copy address up
	scf				; success!
	ret

.dir_path_get_error
	pop	bc
	pop	hl
	pop	hl
	ret				; TBD!

.dir_path_baddrive
	ld	a,rc_nodrive
	and	a
	ret

.dir_path_inserttext
	ld	a,(hl)
	dec	hl
.dir_path_inserttextA
	ld	(de),a
	ld	a,iyl
	cp	e
	jr	nz,dir_path_bufokay
	ld	a,iyh
	cp	d
	jr	nz,dir_path_bufokay
	ld	a,'*'			; replace with wildcard char
	ld	(de),a
	pop	hl			; discard return address
	pop	hl			; discard stacked IY
	scf				; success!
	ret
.dir_path_bufokay
	dec	de
	djnz	dir_path_inserttext
	ld	b,1			; fool DJNZ on return
	ret

.fspec_parent
	defm	"."
.fspec_current
	defm	".          "

