; ResiDOS programming example, with calls to IDEDOS and +3DOS.

	defc	ERR_NR=$5c3a		; BASIC system variables
	defc	ERR_SP=$5c3d
	
	include	"#packages.def"		; ResiDOS package-calling defines
	include	"#p3dos.def"		; +3DOS defines
	include "#idedos.def"		; IDEDOS defines

	org	30000

; Start with a jump block to make life easier for the BASIC program.
	
	jp	residetect		; detect if ResiDOS is present
	jp	dosversion		; get the version of +3DOS
	jp	ideversion		; get the version of IDEDOS
	jp	getheader		; get file header information
	jp	resierror		; cause a ResiDOS error


; Detect an installed version of ResiDOS.
;
; This should be done before you attempt to call any other ResiDOS/+3DOS/IDEDOS
; routines, and ensures that the Spectrum is running with ResiDOS installed.
; Since +3DOS and IDEDOS are present only from v1.40, this version must
; be checked for before making any further calls.
;
; If you need to use calls that were only provided from a certain version of
; ResiDOS, you can check that here as well.
;
; The ResiDOS version call is made with a special hook-code after a RST 8,
; which will cause an error on Speccies without ResiDOS v1.20+ installed,
; or error 0 (OK) if ResiDOS v1.20+ is present. Therefore, we need
; to trap any errors here.

.residetect
	ld	hl,(ERR_SP)
	push	hl			; save the existing ERR_SP
	ld	hl,detect_error
	push	hl			; stack error-handler return address
	ld	hl,0
	add	hl,sp
	ld	(ERR_SP),hl		; set the error-handler SP
	rst	RST_HOOK		; invoke the version info hook code
	defb	HOOK_VERSION
	pop	hl			; ResiDOS doesn't return, so if we get
	jr	noresidos		; here, some other hardware is present
.detect_error
	pop	hl
	ld	(ERR_SP),hl		; restore the old ERR_SP
	ld	a,(ERR_NR)
	inc	a			; is the error code now "OK"?
	jr	nz,noresidos		; if not, ResiDOS was not detected
	ex	de,hl			; get HL=ResiDOS version
	push	hl			; save the version
	ld	de,$0140		; DE=minimum version to run with
	and	a
	sbc	hl,de
	pop	bc			; restore the version to BC
	ret	nc			; and return with it if at least v1.40
.noresidos
	ld	bc,0			; no ResiDOS
	ld	a,$ff
	ld	(ERR_NR),a		; clear error
	ret


; +3DOS call example.
; Return the version number of +3DOS.

.dosversion
					; no entry parameters to set up
	exx				; use alternate set
	push	hl			; save HL' (required by BASIC)
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,DOS_VERSION		; +3DOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	ld	b,d			; BC=version number
	ld	c,e
	exx
	pop	hl			; restore BASIC's HL'
	exx
	ret
	

; IDEDOS call example.
; Return the version number of IDEDOS.

.ideversion
					; no entry parameters to set up
	exx				; use alternate set
	push	hl			; save HL' (required by BASIC)
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,IDE_VERSION		; IDEDOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	ld	b,d			; BC=version number
	ld	c,e
	exx
	pop	hl			; restore BASIC's HL'
	exx
	ret
	

; More complex example, including error handling, and obtaining
; data from +3DOS/IDEDOS memory.	
		
	defc	filename=31000		; buffer for filename
	defc	header=32000		; buffer for header info

.getheader
	exx
	push	hl			; save BASIC's HL'
	exx
	
	; Open the file.
	ld	b,0			; use file 0
	ld	c,5			; access: shared-read
	ld	d,0			; create action: error
	ld	e,1			; open action: read header
	ld	hl,filename		; filename
	exx				; switch to alternate set
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,DOS_OPEN		; +3DOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	jr	nc,open_error		; exit if error
	
	; Get the address of the header in +3DOS memory.
	ld	b,0			; file 0
	exx				; switch to alternate set
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,DOS_REF_HEAD		; +3DOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	jr	nc,ref_error		; exit if error
	
	; Calls like DOS_REF_HEAD return "an address in page 7" - in
	; ResiDOS, such memory cannot be accessed directly, but must
	; be copied using the special IDEDOS call IDE_ACCESS_DATA.
	push	ix
	pop	hl			; HL=address of +3DOS header data
	ld	de,header		; address to copy to
	ld	bc,8			; 8 bytes of header data
	exx				; switch to alternate set
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,IDE_ACCESS_DATA	; IDEDOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	jr	nc,access_error		; exit if error

	; Close the file
	ld	b,0			; file 0
	exx				; switch to alternate set
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,DOS_CLOSE		; +3DOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	jr	nc,close_error		; exit if error
	
	; Exit
	exx
	pop	hl			; restore BASIC's HL'
	exx
	ld	bc,-1			; -1=success
	ret
	
	; Error handling. If a file might be in an open state, we
	; should attempt to close or abandon it before exiting.
.ref_error
.access_error
	push	af			; save error code
	; Attempt to close file 0
	ld	b,0			; file 0
	exx				; switch to alternate set
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,DOS_CLOSE		; +3DOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	jr	c,closed_ok		; move on if the close succeeded
	; Otherwise, abandon file 0
	ld	b,0			; file 0
	exx				; switch to alternate set
	ld	b,PKG_IDEDOS		; IDEDOS package for +3DOS/IDEDOS
	ld	hl,DOS_ABANDON		; +3DOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
.closed_ok
	pop	af			; restore error code
.open_error
.close_error
	ld	c,a
	ld	b,0			; BC=error code
	exx
	pop	hl			; restore BASIC's HL'
	exx
	ret
	
	
; Cause a ResiDOS error.
; As well as causing a ResiDOS error in this way, you could examine individual
; error codes: they are defined in the files p3dos.def, idedos.def and
; packages.def with names starting with rc_
	
	defc	errorcode=33000

.resierror
	ld	a,(errorcode)		; ResiDOS code, from +3DOS/IDEDOS call
	exx				; switch to alternate set
	ld	b,PKG_RESIDOS		; ResiDOS package
	ld	hl,RESI_REPORT		; ResiDOS call ID
	rst	RST_HOOK		; invoke the package call hook code
	defb	HOOK_PACKAGE
	
