; **********************
;   CENTRONICS DRIVER.
;       PPI 8255.
;   ================
;       XAVSNAP.
; **********************

;ORG 4082

ORG 3000

@CURSEUR=8F5
@CLEAR=A2A
@KBD=2BB
@CHAINE=B6B
@DECODE=7BD

; REG. 8255.
@ADDRC=3803
@ADDPA=3800
@ADDPB=3801
@ADDPC=3802

;8255 CONFIG MODES
;
;D7:   0-RESET 1-DEF.
;D6-5: MODE DEF.(0-1-2)
;D4:PA 0-OUT 1-IN
;D3:PC 4-7 0-OUT 1-IN
;D2:MODE 0 OR 1
;D1:PB 0-OUT 1-IN
;D0:PC 0-3 0-OUT 1-IN


;READ PORT.
;AC :INPUT
;B  :OUTPUT
;8255 REG= 10011001
@PPIR=99

;WRITE PORT.
;C :INPUT
;AB  :OUTPUT
;8255 REG= 10001001
@PPIW=89


;PB CONTROL REG.
;(OUTPUT)

; STROBE=   00000001
@STOBE=1 

; AUTOFEED= 00000010
@AUTOFEED=2

; INIT=     00000100
@INIT=4

; SEL.IMP.= 00001000
@SELIMP=8


;PC STAT REG.
;(INPUT)
; ERROR = 00001000
@ERR=8

; SELECT  = 00010000
@SELECT=10

;PAPEROUT = 00100000
@PAPEROUT=20

;ACKNOWLAGE = 01000000
@ACKN=40

;BUSY = 10000000
@BUSY=80

;-----------------------

;TEXT TO SEND OFFSET.
@COUNTER1=403C

;TEXT BUFFER.
@COUNTER4=4042

; TEXT LENGHT
@LENS=0022
@LENG=0019

;END OFFSET
@COUNTER2=403E

;SEND COUNTER
@COUNTER3=4040

"DRV" 76
@START
CALL CLEAR 
LD BC,0707  
CALL CURSEUR 
LD BC,0011  
LD DE,TEXT1  
CALL CHAINE
;
;
LD BC,0B0A  
CALL CURSEUR
LD BC,000A 
LD DE,TEXT2  
CALL CHAINE
LD E,03     
@JPG1
CALL TEMPO2
DEC E
JR NZ JPG1

CALL CLEAR 
LD BC,0A07  
CALL CURSEUR 
LD BC,0013  
LD DE,TEXT5  
CALL CHAINE
 
LD BC,0B07  
CALL CURSEUR 
LD BC,0013  
LD DE,TEXT7  
CALL CHAINE
@JPA2
CALL TOUCHE
LD B,00
;"S"     
CP 38       
JR Z SDATATS
;"R"
CP 37       
JR NZ JPA2
LD B,01     
CALL RDATATS
    
RET

@SDATATS
;INIT PPI WRITE MODE
LD A,PPIW
LD (ADDRC),A
;STROBE=1
;AUTO FEED=1
;INIT=1
;SELECT IMP=1


LD A,F
LD (ADDPB),A
;INIT=0
XOR 4
LD (ADDPB),A

;TESTS
;LD A,F0
;LD (ADDPC),A

@LOOP0

;"WAITING"
CALL CLEAR 
LD BC,0101  
CALL CURSEUR 
LD BC,000A  
LD DE,TEXT3  
CALL CHAINE

;TEST PORT
;WAITING FOR PRINTER.

LD HL,DATASOUT
LD (COUNTER1),HL
LD (COUNTER3),HL
LD BC,LENS
ADD HL,BC
LD (COUNTER2),HL


;ACK=0
@LOOP1
LD HL,ADDPC
BIT 3,(HL)  ; ERROR.
JP NZ ERREUR1
BIT 4,(HL)  ; READY.
JP Z LOOP1
BIT 5,(HL)  ; PAPER OUT.
JP NZ LOOP1
BIT 7,(HL)  ;BUSY
JR NZ LOOP1
BIT 6,(HL)  ;ACK
JR Z SEND  
JR LOOP1

@SEND   
LD BC,0101  
CALL CURSEUR 
LD BC,000A  
LD DE,TEXT5  
CALL CHAINE

@LOOP2
LD HL,(COUNTER3)
LD BC,(COUNTER2)
SBC HL,BC
JR Z END1
LD HL,(COUNTER3)

LD A,(HL)
LD (ADDPA),A

LD A,(ADDPB)
XOR STOBE
LD (ADDPB),A

;CALL TEMPO1

LD A,(ADDPB)
XOR STOBE
LD (ADDPB),A

LD HL,(COUNTER3)
INC HL
LD (COUNTER3),HL

;TESTS
;LD A,(ADDPC)
;;XOR BUSY
;XOR ACKN
;LD (ADDPC),A

JR LOOP1

@END1

LD BC,0101  
CALL CURSEUR 
LD BC,000A  
LD DE,TEXT4  
CALL CHAINE
RET

@RDATATS
;INIT PPI READ MODE
LD A,PPIR
LD (ADDRC),A

@LOOPA
CALL CLEAR 
LD BC,0101  
CALL CURSEUR 
LD BC,000A  
LD DE,TEXT3  
CALL CHAINE

;TEST PORT
;WAITING FOR PRINTER.

LD HL,COUNTER4
LD (COUNTER1),HL
LD (COUNTER3),HL
LD BC,LENG
ADD HL,BC
LD (COUNTER2),HL

;ACK=0
@LOOPB
LD HL,ADDPC
BIT 3,(HL)  ;P OUT
JR NZ ERREUR2
BIT 7,(HL)  ;BUSY
JR Z LOOPB
BIT 6,(HL)  ;ACK
JR Z GET  
JR LOOPB

@GET   
LD BC,0101  
CALL CURSEUR 
LD BC,000A  
LD DE,TEXT10 
CALL CHAINE

LD HL,(COUNTER3)

@LOOPC

LD BC,(COUNTER2)
SBC HL,BC
JR Z END2
LD HL,(COUNTER3)

;STORE DATAS
LD A,(ADDPA)
LD (HL),A

;TO TERMINAL ACKN
LD A,(ADDPB)
XOR STOBE
LD (ADDPB),A
XOR STOBE
LD (ADDPB),A

INC HL
LD (COUNTER3),HL

JR LOOPB
@END2

LD BC,0501  
CALL CURSEUR 
LD BC,LENG  
LD DE,COUNTER4 
CALL CHAINE
JP END1
RET

;---------------------

;PRT ERROR SEND
@ERREUR1
CALL ERREUR
JP LOOP0

;PRT ERROR GET
@ERREUR2
CALL ERREUR
JP LOOPA

@ERREUR
CALL CLEAR
LD BC,0A01      
CALL CURSEUR 
LD BC,000E  
LD DE,PRTERR 
CALL CHAINE
CALL TEMPO2
RET

@TOUCHE
CALL KBD
LD A,H       
AND L      
INC A
JR NZ TOUCHE

@JPG0
CALL KBD
LD A,H       
AND L      
INC A
JR Z JPG0
PUSH HL      
POP BC       
CALL DECODE 
LD A,(HL)    
RET 
 
@TEMPO2
LD C,FF     
@JPC1
LD B,FF     
@JPB9
DEC B
JR NZ JPB9
DEC C
JR NZ JPC1
RET 
    
@TEMPO1
LD E,01     
@JPC3
LD D,FF     
@JPC2
DEC D
JR NZ JPC2
DEC E
JR NZ JPC3
RET  

;12
@TEXT1
"CENTRONICS DRIVER."

;B
@TEXT2
"BY "
 BD
 "AV"
 B8
 "NAP"

;A
@TEXT3
"WAITING..."

@TEXT4
"TEST OK   "

@TEXT5
"SEND DATAS"

@TEXT6
", PRESS " B8

@TEXT7
"GET  DATAS"

@TEXT9
", PRESS " B7

@TEXT8
"QUIT, PRESS " B6

@TEXT10
"GET  DATAS"

@DATASOUT

;ZX81 CHAR CODE.
"HELLO WORLD"

;PC CHAR CODE
48 45 4C 4C 4F 20 57 4F
52 4C 44 20 68 65 6C 6C
6F 20 77 6F 72 6C 64

@PRTERR
"PRINTER ERROR"
































