Attribute VB_Name = "BasMain"
Option Explicit

Private Type Ext_integer
Lbyte As Byte
Hbyte As Byte
End Type

' CopyQm Header.
' 174b
' ****************************************************************
' ***                      CopyQM Header                       ***
' ****************************************************************
Public Enum DSK_FORMAT
D_160 = &H30&
D_320 = &H38&
D_xxx = &H40&
D_720 = &H62&
D_1024 = &H74&
End Enum

Public Type CopyQM_header
':1
Tag As String * 2 ' CQ
Version As Byte  ' &h14
':4
B_1 As Byte             ' &h00
B_21 As Byte            ' &h02
B_22 As Byte            ' &h01 ?
B_23 As Byte            ' &h01 ?
B_3 As Byte            ' &h00
B_41 As Byte            ' &h02 ?
B_42 As Byte            ' &hE0 ?
B_43 As Byte             ' &h00
':12
Dsk_type As Byte        ' Disk type Format(&h52=80,&h62=720,&h30=160,&h74=1024,&h38=320).
B_51 As Byte            ' &h0B ?
B_52 As Byte            ' &hF0 ?
B_53 As Byte            ' &h09 ?
B_54 As Byte

':16
Sect_per_Track As Byte  ' Sectors per Tracks.
':18
Cluster_Size As Integer ' Cluster_Size
C_1 As Byte             '
C_2 As Long            ' &h0000
C_3 As Long            ' &h0000
':29
info_disk As String * 60 ' Extra-disk info ("0K Double-Sided")+ &h00...
':89

Info_side As Byte      ' Info side : 0/1 (SD/DD)
Info_density As Byte   ' 0: Low / 1: Hight (DD/HD)
Cylinder_Side1 As Byte ' # Cylinder for side 1.("P")
Cylinder_Side2 As Byte ' # Cylinder for side 2.("P")
Extra1_Side1 As Byte   ' .
Extra1_Side2 As Byte   ' .
Extra2_Side1 As Byte   ' .
Extra2_Side2 As Byte   ' .
Label_disk As String * 11     ' Extra-info/volume label ("** NONE **")
Disk_length As Long    ' .
Comment_Lenght As Byte ' Comment lenght.
C_4 As String * 20     ' Na
C_5 As Byte            ' .
Comment As String * 41 ' Comments for CopyQM disk (offset 136)
                       '  length fixed by previous len-byte.
                       ' (Can't be used in this case, must be redim!)
End Type

Sub Main()
Dim FrmMain As New FrmMain
FrmMain.Show
End Sub


Sub Expend_QM(SourceFileName As String, NewFileName As String)

Dim buffer() As Byte
Dim Hfile1 As Integer
Dim Hfile2 As Integer
Dim offset As Long
Dim Lenght As Ext_integer
Dim Filler As Byte
Dim Cnt As Long
offset = 175


On Error GoTo Err_H

'Input file.
Hfile1 = FreeFile
Open SourceFileName For Binary Lock Write As #Hfile1


'Output file.
Hfile2 = FreeFile
If Dir(NewFileName) <> "" Then Kill NewFileName
Open NewFileName For Binary Lock Read As #Hfile2

Do While Not EOF(Hfile1)
Get #Hfile1, offset, Lenght
offset = offset + 2

If (Lenght.Hbyte And 128) = 128 Then
'fill

ReDim buffer((Eint(Lenght) Xor 65535))
Get #Hfile1, offset, Filler
offset = offset + 1
For Cnt = 0 To UBound(buffer)
buffer(Cnt) = Filler
Next

Else
ReDim buffer(Eint(Lenght) - 1)
Get #Hfile1, offset, buffer
offset = offset + Eint(Lenght)
End If

Put #Hfile2, , buffer
If offset >= LOF(Hfile1) Then Exit Do
Loop
Err_H:
Close #Hfile2
Close #Hfile1
Reset
Beep
End Sub

Function Eint(datas As Ext_integer) As Long
Eint = (CLng(datas.Hbyte) * 256) + CLng(datas.Lbyte)
End Function

Sub createQM(RawFile As String, NewFile As String, HeaderName As String)
Dim Hfile1 As Integer, Hfile2 As Integer
Dim Cluster_Lenght As Integer
Dim header As CopyQM_header
Dim DSk_Buff() As Byte
Dim Track_Cnt As Integer

If Dir(NewFile) <> "" Then Kill NewFile
FileCopy App.path & "\" & HeaderName, NewFile

' Open Dest. file.
Hfile1 = FreeFile
Open NewFile For Binary As #Hfile1
Get #Hfile1, 1, header
Cluster_Lenght = header.Cluster_Size * header.Sect_per_Track
ReDim DSk_Buff(Cluster_Lenght - 1)

' Open Source file.
Hfile2 = FreeFile
Open RawFile For Binary As #Hfile2
For Track_Cnt = 0 To (header.Cylinder_Side1 * IIf(header.Cylinder_Side1 > 0 And header.Cylinder_Side2 > 0, 2, 1)) - 1
If EOF(Hfile2) Then Exit For
Get #Hfile2, , DSk_Buff
Put #Hfile1, , Cluster_Lenght
Put #Hfile1, , DSk_Buff
Next
Close #Hfile2
Close #Hfile1
Beep
End Sub

Sub createQM1()
Dim CopyQM_header As CopyQM_header
'Offset      0  1  2  3  4  5  6  7   8  9 10 11 12 13 14 15

'00000000   43 51 14 00 02 00 00 00  00 00 00 74 00 00 00 00   CQ.........t....
'00000016   12 00 02 00 00 00 00 00  00 00 00 00 30 4B 20 44   ............0K D
'00000032   6F 75 62 6C 65 2D 53 69  64 65 64 00 00 00 00 00   ouble-Sided.....
'00000048   00 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00   ................
'00000064   00 00 00 00 00 00 00 00  00 00 00 00 00 00 00 00   ................
'00000080   00 00 00 00 00 00 00 00  01 01 50 50 36 50 8D 7E   ..........PP6P~
'00000096   2A 2A 20 4E 4F 4E 45 20  2A 2A 00 A5 B3 2F 39 29   ** NONE **./9)
'00000112   00 00 00 00 01 00 04 00  00 00 00 00 00 00 00 00   ................
'00000128   00 00 00 00 89 49 6D 61  67 65 20 66 69 6C 65 20   ....Image file
'00000144   63 72 65 61 74 65 64 20  62 79 20 75 6E 72 65 67   created by unreg
'00000160   69 73 74 65 72 65 64 20  43 6F 70 79 51 4D         istered CopyQM

CopyQM_header.Tag = "CQ"
CopyQM_header.Version = &H14
CopyQM_header.B_1 = &H0
CopyQM_header.B_21 = &H2
CopyQM_header.B_22 = &H1
CopyQM_header.B_23 = &H1
CopyQM_header.B_3 = &H0
CopyQM_header.B_41 = &H2
CopyQM_header.B_42 = &HE0
CopyQM_header.B_43 = &H0
CopyQM_header.Dsk_type = &H74      ' Disk type Format(&h62=720,&h30=160,&h74=1024,&h38=320).
CopyQM_header.B_51 = &HB
CopyQM_header.B_52 = &HF0
CopyQM_header.B_53 = &H9

CopyQM_header.Sect_per_Track = 12 ' Sectors per Tracks.
CopyQM_header.Info_side = 1         ' Sides: 0 or 1 (mono or double)
CopyQM_header.C_1 = 0          ' Na
CopyQM_header.C_2 = &H0           ' &h0000
CopyQM_header.C_3 = &H0            ' &h0000
CopyQM_header.info_disk = "0K Double-Sided" + Chr(&H0)
CopyQM_header.Info_side = 1
CopyQM_header.Info_density = 0
CopyQM_header.Cylinder_Side1 = 0
CopyQM_header.Cylinder_Side2 = 0
CopyQM_header.Extra1_Side1 = 0
CopyQM_header.Extra1_Side2 = 0
CopyQM_header.Extra2_Side1 = 0
CopyQM_header.Extra2_Side2 = 0
CopyQM_header.Label_disk = "** NONE **" + String$(45, Chr(0)) ' Extra-info/volume label ("** NONE **")
CopyQM_header.Disk_length = 0
CopyQM_header.Comment_Lenght = 41
CopyQM_header.C_4 = String$(21, Chr(0))      ' Na
CopyQM_header.C_5 = &H89           ' Na
CopyQM_header.Comment = "Image file created by CopyQM converter   "
End Sub
