ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0001
LONG FUNCTIONS 01/02/2007

                            1 *
                            2 * long functions for C99 2.0
                            3 *
                            4 * Frederik G. Kaal      01/02/2007
                            5 *
                            6 * Because not every project need all long functions
                            7 * you can copy this file to the project directory
                            8 * and comment-out the functions you don't need.
                            9 *
                           10 * A library with all functions is available in the Tilib.
                           11 *
                           12 * Name convention:
                           13 *   Lxxx(*L)      Functions with one argument
                           14 *   LxxxL(*L,*L)  Functions with two arguments and both are long
                           15 *   LxxxS(*L, S)  Functions with two arguments first is long second short
                           16 *   SLxxxS(*L, S) Functions with two arguments first is long second short
                           17 *                   and result is short
                           18 *
                           19         TITL 'LONG FUNCTIONS 01/02/2007'
                           20 
                           21         IDT 'LONG'
                           22 
                           23         DEF LCLR,LSETO,LINC,LDEC,LINV,LABS,LNEG
                           24         DEF LCPYS,LCPYL,LCMPL,LTST
                           25         DEF LANDL,LORL,LXORL,LSHLS,LSHRS
                           26         DEF LADDS,LADDL,LSUBS,LSUBL
                           27         DEF LMPYS,LMPYL,LDIVS,LMODS,LDIVL,LMODL
                           28         DEF LMPY#S,LDIV#S
                           29         
                           30 *****************************
                           31 *       AORG    >A000
                           32 *TEST   LWPI    MYWS
                           33 *       LI      13,RETURN
                           34 *       LI      14,STACK
                           35 *       
                           36 *START  LI      8,LONG1
                           37 *       BL      15
                           38 *       LI      8,LONG2
                           39 **      LI      8,>6666
                           40 *       BL      15
                           41 *       BL      @GOSUB
                           42 *       DATA    LDIV
                           43 *       
                           44 *STOP   JMP     STOP    
                           45 *
                           46 *GOSUB  MOV     *11+,7  
                           47 *       DECT    14
                           48 *       MOV     11,*14
                           49 *       B       *7
                           50 *
                           51 *RETURN MOV     *14+,7
                           52 *       B       *7
                           53 *
                           54 *
                           55 *MYWS   DATA    0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                           56 *PUSH   DECT    14
                           57 *       MOV     8,*14
                           58 *       B       *11
                           59 *
                           60 *
                           61 *LONG1  DATA    >3332,>CCCD
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0002
LONG FUNCTIONS 01/02/2007

                           62 *LONG2  DATA    >0000,>6666
                           63 *
                           64 *       DATA    0,0,0,0,0
                           65 *       DATA    0,0,0,0,0 
                           66 *       DATA    0,0,0,0,0 
                           67 *STACK  DATA    0,0,0,0,0 
                           68 *       DATA    0,0,0,0,0 
                           69 *
                           70 *
                           71 ******************************
 0000  0000  0000          72 L0000  DATA >0000,>0000
                           73 
                           74 * lclr(long) int *long;
                           75 *
                           76 * long = 0
                           77 * returns *long
                           78 *
 0004  04E8  0002          79 LCLR   CLR @2(8)         R8=&long
 0008  04D8                80        CLR *8
 000A  045D                81        B   *13
                           82         
                           83 * lseto(long) int *long;
                           84 *
                           85 * long = 0xffffffff = -1
                           86 * returns *long
                           87 *
 000C  0728  0002          88 LSETO  SETO @2(8)        R8=&long
 0010  0718                89        SETO *8
 0012  045D                90        B    *13
                           91 
                           92 * linc(long) int *long;
                           93 * 
                           94 * long += 1
                           95 * returns *long
                           96 *
 0014  05A8  0002          97 LINC   INC @2(8)         R8=&long
 0018  1701                98        JNC LINC#X
 001A  0598                99        INC *8
 001C  045D               100 LINC#X B   *13
                          101 
                          102 * ldec(long) int *long;
                          103 *
                          104 * long -= 1
                          105 * returns *long
                          106 *
 001E  0628  0002         107 LDEC   DEC @2(8)         R8=&long
 0022  1801               108        JOC LDEC#X
 0024  0618               109        DEC *8
 0026  045D               110 LDEC#X B   *13
                          111 
                          112 * linv(long) int *long
                          113 *
                          114 * long = ~long
                          115 * returns *long
                          116 *
 0028  0568  0002         117 LINV   INV @2(8)         R8=&long
 002C  0558               118        INV *8
 002E  045D               119        B   *13
                          120 
                          121 * labs(long) int *long
                          122 *
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0003
LONG FUNCTIONS 01/02/2007

                          123 * long = ABS(long)
                          124 * returns *long
                          125 *
 0030  C018               126 LABS   MOV *8,0          R8=&long
 0032  1101               127        JLT LNEG 
 0034  045D               128        B   *13
                          129 
                          130 * lneg(long) int *long
                          131 *
                          132 * long = -long
                          133 * returns *long
                          134 *
 0036  0558               135 LNEG   INV *8            R8=&long
 0038  0528  0002         136        NEG @2(8)
 003C  1701               137        JNC LNEG#X
 003E  0598               138        INC *8
 0040  045D               139 LNEG#X B   *13
                          140 
                          141 * lcpys(long,short) int *long,short;
                          142 *
                          143 * long = short
                          144 * returns *long
                          145 *
 0042  C048               146 LCPYS  MOV  8,1          R1=short
 0044  C22E  0004         147        MOV  @4(14),8     R8=&long
 0048  04D8               148        CLR  *8
 004A  CA01  0002         149        MOV  1,@2(8)
 004E  045D               150        B    *13
                          151 
                          152 * lcpyl(long1, long2) int *long1, *long2;
                          153 *
                          154 * long1 = long2
                          155 * returns *long1
                          156 *
 0050  C06E  0002         157 LCPYL  MOV  @2(14),1     R1=&long1
 0054  C22E  0004         158        MOV  @4(14),8     R8=&long2
 0058  C631               159        MOV  *1+,*8
 005A  CA11  0002         160        MOV  *1,@2(8)
 005E  045D               161        B    *13 
                          162 
                          163 * lcmpl(long1,long2) int *long1,*long2;
                          164 *
                          165 * compare long1 and long2
                          166 * returns > 0 if long1 > long2
                          167 * returns   0 if long1 = long2
                          168 * returns < 0 if long1 < long2
                          169 *
 0060  C02E  0004         170 LCMPL  MOV  @4(14),0     R0=&long1
 0064  C048               171        MOV  8,1          R1=&long2
 0066  1003               172        JMP  LTST#X
                          173 
                          174 * ltst(long) int *long
                          175 *
                          176 * compare long with 0
                          177 *
                          178 * returns > 0 if long > 0
                          179 * returns   0 if long = 0
                          180 * returns < 0 if long < 0
                          181 *
 0068  C008               182 LTST   MOV  8,0          R0=&Long       
 006A  0201  0000'        183 LTST#0 LI   1,L0000      R1=&>00000000
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0004
LONG FUNCTIONS 01/02/2007

 006E  04C8               184 LTST#X CLR  8
 0070  8C70               185        C    *0+,*1+      HOW(long1)-HOW(long2)
 0072  1A06               186        JL   LTST#L
 0074  1B03               187        JH   LTST#H
 0076  8450               188        C    *0,*1        LOW(long1)-LOW(long2)
 0078  1A03               189        JL   LTST#L
 007A  1301               190        JEQ  LTST#E
 007C  0588               191 LTST#H INC  8
 007E  045D               192 LTST#E B    *13
 0080  0708               193 LTST#L SETO 8
 0082  045D               194        B    *13
                          195        
                          196 * landl(long1,long2) int *long1,*long2
                          197 *
                          198 * long1 &= long2
                          199 * returns *long1
                          200 *
 0084  C048               201 LANDL  MOV  8,1          R1=&long2
 0086  C22E  0004         202        MOV  @4(14),8     R8=&long1
 008A  C031               203        MOV  *1+,0
 008C  0540               204        INV  0
 008E  4600               205        SZC  0,*8
 0090  C011               206        MOV  *1,0
 0092  0540               207        INV  0
 0094  4A00  0002         208        SZC  0,@2(8)
 0098  045D               209        B    *13 
                          210 
                          211 * lorl(long1,long2) int *long1,*long2
                          212 *
                          213 * long1 |= long2
                          214 * returns *long1
                          215 *
 009A  C048               216 LORL   MOV  8,1          R1=&long2
 009C  C22E  0004         217        MOV  @4(14),8     R8=&long1
 00A0  E631               218        SOC  *1+,*8
 00A2  EA11  0002         219        SOC  *1,@2(8)
 00A6  045D               220        B    *13 
                          221 
                          222 * lxorl(long1,long2) int *long1,*long2
                          223 *
                          224 * long1 ^= long2
                          225 * returns *long1
                          226 *
 00A8  C048               227 LXORL  MOV  8,1          R1=&long2
 00AA  C22E  0004         228        MOV  @4(14),8     R8=&long1
 00AE  C088               229        MOV  8,2          R2=&long1
 00B0  C012               230        MOV  *2,0         HOW XOR HOW
 00B2  2831               231        XOR  *1+,0
 00B4  CC80               232        MOV  0,*2+
 00B6  C012               233        MOV  *2,0         LOW XOR LOW
 00B8  2811               234        XOR  *1,0
 00BA  C480               235        MOV  0,*2
 00BC  045D               236        B    *13 
                          237 
                          238 * lshls(long,shcnt) int *long, shcnt
                          239 *
                          240 * long <<= shcnt (1-16)
                          241 * returns *long
                          242 *
 00BE  C008               243 LSHLS  MOV  8,0          R0=shcnt
 00C0  1310               244        JEQ  LSHL#X       =0
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0005
LONG FUNCTIONS 01/02/2007

 00C2  C22E  0004         245        MOV  @4(14),8     R8=&long
                          246 
 00C6  C058               247        MOV  *8,1
 00C8  C0A8  0002         248        MOV  @2(8),2
 00CC  C0C2               249        MOV  2,3
 00CE  0A01               250        SLA  1,0
 00D0  0A02               251        SLA  2,0
 00D2  0500               252        NEG  0
 00D4  0220  0010         253        AI   0,16
 00D8  0903               254        SRL  3,0
 00DA  A043               255        A    3,1
 00DC  C601               256        MOV  1,*8
 00DE  CA02  0002         257        MOV  2,@2(8)     
 00E2  045D               258 LSHL#X B    *13
                          259 
                          260 * lshrs(long,shcnt) int *long, shcnt
                          261 *
                          262 * long >>= shcnt (1-16)
                          263 * returns *long
                          264 *
 00E4  C008               265 LSHRS  MOV 8,0           R0=shcnt
 00E6  13FD               266        JEQ LSHL#X
 00E8  C22E  0004         267        MOV @4(14),8      R8=&long
                          268        
 00EC  C058               269        MOV *8,1
 00EE  C0A8  0002         270        MOV @2(8),2
 00F2  C0C1               271        MOV 1,3
 00F4  0901               272        SRL 1,0
 00F6  0902               273        SRL 2,0
 00F8  0500               274        NEG 0
 00FA  0220  0010         275        AI  0,16
 00FE  0A03               276        SLA 3,0
 0100  A083               277        A   3,2
 0102  C601               278        MOV 1,*8
 0104  CA02  0002         279        MOV 2,@2(8)      
 0108  045D               280 LSHR#X B   *13
                          281 
                          282 * ladds(long, short) int *long, short;
                          283 *
                          284 * long += short
                          285 * returns *long
                          286 *
 010A  C048               287 LADDS  MOV  8,1          R1=short
 010C  C22E  0004         288        MOV  @4(14),8     R8=&long
 0110  AA01  0002         289        A    1,@2(8)
 0114  1701               290        JNC  LADS#1
 0116  0598               291        INC  *8
 0118  045D               292 LADS#1 B    *13
                          293 
                          294 * laddl(long1, long2) int *long1, long2;
                          295 *
                          296 * long1 += long2
                          297 * returns *long1
                          298 *
 011A  C048               299 LADDL  MOV  8,1          R1=&long2
 011C  C22E  0004         300        MOV  @4(14),8     R8=&long1
 0120  AA21  0002  0002   301        A    @2(1),@2(8)
 0126  1701               302        JNC  LADD#1
 0128  0598               303        INC  *8
 012A  A611               304 LADD#1 A    *1,*8
 012C  045D               305        B    *13
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0006
LONG FUNCTIONS 01/02/2007

                          306 
                          307 * lsubs(long, short) int *long, short;
                          308 *
                          309 * long -= short
                          310 * returns *long
                          311 *
 012E  C048               312 LSUBS  MOV  8,1          R1=short
 0130  C22E  0004         313        MOV  @4(14),8     R8=&long
 0134  6A01  0002         314        S    1,@2(8)
 0138  1801               315        JOC  LSBS#1
 013A  0618               316        DEC  *8
 013C  045D               317 LSBS#1 B    *13
                          318 
                          319 * lsubl(long1, long2) int *long1, long2;
                          320 *
                          321 * long1 -= long2
                          322 * returns *long1
                          323 *
 013E  C048               324 LSUBL  MOV  8,1          R1=&long2
 0140  C22E  0004         325        MOV  @4(14),8     R8=&long1
 0144  6A21  0002  0002   326        S    @2(1),@2(8)
 014A  1801               327        JOC  LSUB#1
 014C  0618               328        DEC  *8
 014E  6611               329 LSUB#1 S    *1,*8
 0150  045D               330        B    *13
                          331 
                          332 * lmpys(long,short) int *long,short;
                          333 *
                          334 * long *= short = (short*LOW(long))        overflow if:
                          335 *               + (short*HOW(long)) 0000   HOW(result)!=0
                          336 * returns *long
                          337 *
                          338 * overflow if: 
                          339 *
 0152  04C7               340 LMPYS  CLR  7            R7=HOW(short)
 0154  C188               341        MOV  8,6          R6=LOW(short)
 0156  C22E  0004         342        MOV  @4(14),8     R8=&Long 
                          343 
 015A  C068  0002         344        MOV  @2(8),1      LOW(long)
 015E  3846               345        MPY  6,1          LOW(short)*LOW(long)
 0160  06A0  0190'        346        BL   @LMPY#1
 0164  045D               347        B    *13
                          348 
                          349 * lmpyl(long1,long2) int *long1,*long2;
                          350 *
                          351 * unsigned multiply
                          352 *
                          353 * long1 *= long2 = (LOW(long2) * LOW(long1))            overflow if:
                          354 *                + (HOW(long2) * LOW(long1)) 0000       HOW(result)!=0
                          355 *                + (LOW(long2) * HOW(long1)) 0000       HOW(result)!=0
                          356 *                + (HOW(long2) * HOW(long1)) 0000 0000      result !=0
                          357 *
                          358 * returns *long1, if overflow occured long1=0xFFFFFFFF 
                          359 *
                          360 *
                          361 *
 0166  C198               362 LMPYL  MOV  *8,6     R6=HOW(long2)
 0168  C1E8  0002         363        MOV  @2(8),7  R7=LOW(long2)
 016C  C22E  0004         364        MOV  @4(14),8 R8=&long1
 0170  06A0  0176'        365        BL   @LMPY#S
 0174  045D               366        B    *13
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0007
LONG FUNCTIONS 01/02/2007

                          367        
 0176  C0D8               368 LMPY#S MOV  *8,3     HOW(long1)=0
 0178  1302               369        JEQ  LMPY#0
 017A  C0C6               370        MOV  6,3      HOW(long2)=0
 017C  1613               371        JNE  LMPY#V   Overflow
                          372 
 017E  C068  0002         373 LMPY#0 MOV  @2(8),1  LOW(long1)
 0182  C0C1               374        MOV  1,3
 0184  3847               375        MPY  7,1      LOW(long2)*LOW(long1)
                          376        
 0186  38C6               377        MPY  6,3      HOW(long2)*LOW(long1)
 0188  A044               378        A    4,1
 018A  180C               379        JOC  LMPY#V   Overflow
 018C  0743               380        ABS  3        !=0
 018E  160A               381        JNE  LMPY#V   Overflow
                          382       
 0190  C0D8               383 LMPY#1 MOV  *8,3     HOW(long1)
 0192  38C7               384        MPY  7,3      LOW(long2)*HOW(long1)
 0194  A044               385        A    4,1
 0196  1806               386        JOC  LMPY#V   Overflow
 0198  0743               387        ABS  3        !=0
 019A  1604               388        JNE  LMPY#V   Overflow
                          389 
 019C  C601               390 LMPY#X MOV  1,*8     HOW(long1*long2)
 019E  CA02  0002         391        MOV  2,@2(8)  LOW(long1*long2)
 01A2  045B               392        B    *11 
                          393        
 01A4  0718               394 LMPY#V SETO *8       Overflow
 01A6  0728  0002         395        SETO @2(8)
 01AA  045B               396        B    *11
                          397 
                          398 * sldivs(long,short) int *long1,short;
                          399 *
                          400 * result = long / short
                          401 * returns result
                          402 *
 01AC  C048               403 SLDIVS MOV  8,1          R1=short
 01AE  C0AE  0004         404        MOV  @4(14),2     R2=&long
 01B2  C212               405        MOV  *2,8         R7=HOW(long)
 01B4  C262  0002         406        MOV  @2(2),9      R8=LOW(long)
 01B8  3E01               407        DIV  1,8          R8=quotient
 01BA  045D               408        B    *13
                          409 
                          410 * ldivs(long,short) int *long1,short;
                          411 *
                          412 * long = long / short
                          413 * returns *long
                          414 *
 01BC  C048               415 LDIVS  MOV  8,1          R1=short=dividend
 01BE  C22E  0004         416        MOV  @4(14),8     R8=&long
                          417        
 01C2  04C2               418        CLR  2            R2=HOW(divisor)
 01C4  C0D8               419        MOV  *8,3         R3=HOW(long)=LOW(divisor)
 01C6  3C81               420        DIV  1,2          R2=quotient=HOW(result),R3=remainder=HOW(divisor)
                          421 
 01C8  C128  0002         422        MOV  @2(8),4      R4=LOW(long)=LOW(divisor)
 01CC  3CC1               423        DIV  1,3          R3=LOW(result), R4=remainder
                          424        
 01CE  C602               425        MOV  2,*8
 01D0  CA03  0002         426        MOV  3,@2(8)
 01D4  045D               427        B    *13
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0008
LONG FUNCTIONS 01/02/2007

                          428 
                          429 * lmods(long,short) int *long,short
                          430 *
                          431 * result = long % short
                          432 * returns result
                          433 *
 01D6  C048               434 LMODS  MOV  8,1          R1=short
 01D8  C0AE  0004         435        MOV  @4(14),2     R2=&long
 01DC  C1F2               436        MOV  *2+,7        R7=HOW(long)
 01DE  C212               437        MOV  *2,8         R8=LOW(long)
 01E0  3DC1               438        DIV  1,7          R8=modulo
 01E2  045D               439        B    *13
                          440 
                          441 * ldivl(long1,long2) int *long1,*long2
                          442 *
                          443 * unsigned divide
                          444 *
                          445 * long1 = long1 / long2
                          446 * returns *long1
                          447 *
 01E4  06A0  01FC'        448 LDIVL  BL   @LDIV#U
 01E8  C604               449        MOV  4,*8         R8=&long1
 01EA  CA05  0002         450        MOV  5,@2(8)
 01EE  045D               451        B    *13
                          452 
                          453 * lmodl(long1,long2) int *long1,*long2
                          454 *
                          455 * unsigned modulo
                          456 *
                          457 * long1 = long1 % long2
                          458 * returns *long1
                          459 *
 01F0  06A0  01FC'        460 LMODL  BL   @LDIV#U
 01F4  C602               461        MOV  2,*8         R8=&long1
 01F6  CA03  0002         462        MOV  3,@2(8)
 01FA  045D               463        B    *13
                          464 
                          465 * ldiv0(long1,long2) int *long1,*long2
                          466 *
                          467 * R4,5 = long1 / long2
                          468 * R2,3 = long1 % long2
                          469 *
 01FC  C02E  0004         470 LDIV#U MOV  @4(14),0
 0200  C230               471        MOV  *0+,8    Dividend HOW
 0202  C250               472        MOV  *0,9     LOW
 0204  C02E  0002         473        MOV  @2(14),0
 0208  C1B0               474        MOV  *0+,6    Divider HOW
 020A  C1D0               475        MOV  *0,7     LOW
                          476 
 020C  04C2               477 LDIV#S CLR  2        Modulo HOW
 020E  04C3               478        CLR  3        LOW
 0210  04C4               479        CLR  4        Quotient HOW
 0212  04C5               480        CLR  5        LOW
                          481 
 0214  C046               482        MOV  6,1      Divide by 0?
 0216  E047               483        SOC  7,1    
 0218  1603               484        JNE  LDIV#0   No!
 021A  0704               485        SETO 4        Result = long max  
 021C  0705               486        SETO 5   
 021E  045B               487        B    *11
                          488        
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0009
LONG FUNCTIONS 01/02/2007

 0220  0201  0020         489 LDIV#0 LI   1,32     32bits divide
                          490        
 0224  0A14               491 LDIV#1 SLA  4,1      Quotient *=2
 0226  0A15               492        SLA  5,1
 0228  1701               493        JNC  LDIV#2
 022A  0584               494        INC  4        HOW+C
                          495        
 022C  0A12               496 LDIV#2 SLA  2,1      Modulo *=2
 022E  0A13               497        SLA  3,1
 0230  1701               498        JNC  LDIV#3
 0232  0582               499        INC  2        HOW+C
                          500        
 0234  0A18               501 LDIV#3 SLA  8,1      Divider *=2
 0236  1701               502        JNC  LDIV#4
 0238  0583               503        INC  3        Modulo+C
 023A  0A19               504 LDIV#4 SLA  9,1
 023C  1701               505        JNC  LDIV#5
 023E  0588               506        INC  8        HOW+C
                          507  
 0240  8182               508 LDIV#5 C    2,6      HOW(Modulo) > HOW(Divider) ?
 0242  1A0A               509        JL   LDIV#8   No!        
 0244  1B02               510        JH   LDIV#6   Yes! 
 0246  81C3               511        C    3,7      LOW(Modulo) >= LOW(Modulo)
 0248  1A07               512        JL   LDIV#8
 024A  60C7               513 LDIV#6 S    7,3      Modulo -= Divider
 024C  1801               514        JOC  LDIV#7
 024E  0602               515        DEC  2
 0250  6086               516 LDIV#7 S    6,2
 0252  0585               517        INC  5        Quotient +=1
 0254  1701               518        JNC  LDIV#8
 0256  0586               519        INC  6        HOW+C
                          520               
 0258  0601               521 LDIV#8 DEC  1
 025A  16E4               522        JNE  LDIV#1
 025C  C22E  0004         523        MOV  @4(14),8 R8=&long1
 0260  045B               524        B    *11
                          525 
                          526        END
ASM990 1.0.6     LONG                       Wed Feb 04 20:38:06 2009 Page 0010
LONG FUNCTIONS 01/02/2007

 L0000    0000'  LABS     0030G  LADD#1   012A'  LADDL    011AG  LADDS    010AG 
 LADS#1   0118'  LANDL    0084G  LCLR     0004G  LCMPL    0060G  LCPYL    0050G 
 LCPYS    0042G  LDEC     001EG  LDEC#X   0026'  LDIV#0   0220'  LDIV#1   0224' 
 LDIV#2   022C'  LDIV#3   0234'  LDIV#4   023A'  LDIV#5   0240'  LDIV#6   024A' 
 LDIV#7   0250'  LDIV#8   0258'  LDIV#S   020CG  LDIV#U   01FC'  LDIVL    01E4G 
 LDIVS    01BCG  LINC     0014G  LINC#X   001C'  LINV     0028G  LMODL    01F0G 
 LMODS    01D6G  LMPY#0   017E'  LMPY#1   0190'  LMPY#S   0176G  LMPY#V   01A4' 
 LMPY#X   019C'  LMPYL    0166G  LMPYS    0152G  LNEG     0036G  LNEG#X   0040' 
 LORL     009AG  LSBS#1   013C'  LSETO    000CG  LSHL#X   00E2'  LSHLS    00BEG 
 LSHR#X   0108'  LSHRS    00E4G  LSUB#1   014E'  LSUBL    013EG  LSUBS    012EG 
 LTST     0068G  LTST#0   006A'  LTST#E   007E'  LTST#H   007C'  LTST#L   0080' 
 LTST#X   006E'  LXORL    00A8G  R0       0000   R1       0001   R10      000A  
 R11      000B   R12      000C   R13      000D   R14      000E   R15      000F  
 R2       0002   R3       0003   R4       0004   R5       0005   R6       0006  
 R7       0007   R8       0008   R9       0009   SLDIVS   01AC' 

asm990: 0 Errors in assembly
