*
* long functions for C99 2.0
*
* Frederik G. Kaal	01/02/2007
*
* Because not every project need all long functions
* you can copy this file to the project directory
* and comment-out the functions you don't need.
*
* A library with all functions is available in the Tilib.
*
* Name convention:
*   Lxxx(*L)      Functions with one argument
*   LxxxL(*L,*L)  Functions with two arguments and both are long
*   LxxxS(*L, S)  Functions with two arguments first is long second short
*   SLxxxS(*L, S) Functions with two arguments first is long second short
*                   and result is short
*
        TITL 'LONG FUNCTIONS 01/02/2007'

        IDT 'LONG'

        DEF LCLR,LSETO,LINC,LDEC,LINV,LABS,LNEG
        DEF LCPYS,LCPYL,LCMPL,LTST
        DEF LANDL,LORL,LXORL,LSHLS,LSHRS
        DEF LADDS,LADDL,LSUBS,LSUBL
        DEF LMPYS,LMPYL,LDIVS,LMODS,LDIVL,LMODL
        DEF LMPY#S,LDIV#S
	
*****************************
*	AORG    >A000
*TEST	LWPI	MYWS
*	LI      13,RETURN
*	LI	14,STACK
*	
*START	LI      8,LONG1
*	BL      15
*	LI      8,LONG2
**	LI      8,>6666
*	BL      15
*	BL	@GOSUB
*	DATA	LDIV
*	
*STOP	JMP	STOP	
*
*GOSUB	MOV	*11+,7	
*	DECT	14
*	MOV	11,*14
*	B	*7
*
*RETURN	MOV	*14+,7
*	B	*7
*
*
*MYWS	DATA	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
*PUSH	DECT	14
*	MOV	8,*14
*	B	*11
*
*
*LONG1	DATA	>3332,>CCCD
*LONG2	DATA	>0000,>6666
*
*	DATA	0,0,0,0,0
*	DATA	0,0,0,0,0 
*	DATA	0,0,0,0,0 
*STACK	DATA	0,0,0,0,0 
*	DATA	0,0,0,0,0 
*
*
******************************
L0000  DATA >0000,>0000

* lclr(long) int *long;
*
* long = 0
* returns *long
*
LCLR   CLR @2(8)         R8=&long
       CLR *8
       B   *13
	
* lseto(long) int *long;
*
* long = 0xffffffff = -1
* returns *long
*
LSETO  SETO @2(8)        R8=&long
       SETO *8
       B    *13

* linc(long) int *long;
* 
* long += 1
* returns *long
*
LINC   INC @2(8)         R8=&long
       JNC LINC#X
       INC *8
LINC#X B   *13

* ldec(long) int *long;
*
* long -= 1
* returns *long
*
LDEC   DEC @2(8)         R8=&long
       JOC LDEC#X
       DEC *8
LDEC#X B   *13

* linv(long) int *long
*
* long = ~long
* returns *long
*
LINV   INV @2(8)         R8=&long
       INV *8
       B   *13

* labs(long) int *long
*
* long = ABS(long)
* returns *long
*
LABS   MOV *8,0          R8=&long
       JLT LNEG	
       B   *13

* lneg(long) int *long
*
* long = -long
* returns *long
*
LNEG   INV *8	         R8=&long
       NEG @2(8)
       JNC LNEG#X
       INC *8
LNEG#X B   *13

* lcpys(long,short) int *long,short;
*
* long = short
* returns *long
*
LCPYS  MOV  8,1          R1=short
       MOV  @4(14),8     R8=&long
       CLR  *8
       MOV  1,@2(8)
       B    *13

* lcpyl(long1, long2) int *long1, *long2;
*
* long1 = long2
* returns *long1
*
LCPYL  MOV  @2(14),1     R1=&long1
       MOV  @4(14),8     R8=&long2
       MOV  *1+,*8
       MOV  *1,@2(8)
       B    *13	

* lcmpl(long1,long2) int *long1,*long2;
*
* compare long1 and long2
* returns > 0 if long1 > long2
* returns   0 if long1 = long2
* returns < 0 if long1 < long2
*
LCMPL  MOV  @4(14),0     R0=&long1
       MOV  8,1          R1=&long2
       JMP  LTST#X

* ltst(long) int *long
*
* compare long with 0
*
* returns > 0 if long > 0
* returns   0 if long = 0
* returns < 0 if long < 0
*
LTST   MOV  8,0          R0=&Long	
LTST#0 LI   1,L0000      R1=&>00000000
LTST#X CLR  8
       C    *0+,*1+      HOW(long1)-HOW(long2)
       JL   LTST#L
       JH   LTST#H
       C    *0,*1        LOW(long1)-LOW(long2)
       JL   LTST#L
       JEQ  LTST#E
LTST#H INC  8
LTST#E B    *13
LTST#L SETO 8
       B    *13
       
* landl(long1,long2) int *long1,*long2
*
* long1 &= long2
* returns *long1
*
LANDL  MOV  8,1          R1=&long2
       MOV  @4(14),8     R8=&long1
       MOV  *1+,0
       INV  0
       SZC  0,*8
       MOV  *1,0
       INV  0
       SZC  0,@2(8)
       B    *13 

* lorl(long1,long2) int *long1,*long2
*
* long1 |= long2
* returns *long1
*
LORL   MOV  8,1          R1=&long2
       MOV  @4(14),8     R8=&long1
       SOC  *1+,*8
       SOC  *1,@2(8)
       B    *13 

* lxorl(long1,long2) int *long1,*long2
*
* long1 ^= long2
* returns *long1
*
LXORL  MOV  8,1          R1=&long2
       MOV  @4(14),8     R8=&long1
       MOV  8,2          R2=&long1
       MOV  *2,0         HOW XOR HOW
       XOR  *1+,0
       MOV  0,*2+
       MOV  *2,0         LOW XOR LOW
       XOR  *1,0
       MOV  0,*2
       B    *13 

* lshls(long,shcnt) int *long, shcnt
*
* long <<= shcnt (1-16)
* returns *long
*
LSHLS  MOV  8,0          R0=shcnt
       JEQ  LSHL#X	 =0
       MOV  @4(14),8     R8=&long

       MOV  *8,1
       MOV  @2(8),2
       MOV  2,3
       SLA  1,0
       SLA  2,0
       NEG  0
       AI   0,16
       SRL  3,0
       A    3,1
       MOV  1,*8
       MOV  2,@2(8)	
LSHL#X B    *13

* lshrs(long,shcnt) int *long, shcnt
*
* long >>= shcnt (1-16)
* returns *long
*
LSHRS  MOV 8,0           R0=shcnt
       JEQ LSHL#X
       MOV @4(14),8      R8=&long
       
       MOV *8,1
       MOV @2(8),2
       MOV 1,3
       SRL 1,0
       SRL 2,0
       NEG 0
       AI  0,16
       SLA 3,0
       A   3,2
       MOV 1,*8
       MOV 2,@2(8)	
LSHR#X B   *13

* ladds(long, short) int *long, short;
*
* long += short
* returns *long
*
LADDS  MOV  8,1          R1=short
       MOV  @4(14),8     R8=&long
       A    1,@2(8)
       JNC  LADS#1
       INC  *8
LADS#1 B    *13

* laddl(long1, long2) int *long1, long2;
*
* long1 += long2
* returns *long1
*
LADDL  MOV  8,1          R1=&long2
       MOV  @4(14),8     R8=&long1
       A    @2(1),@2(8)
       JNC  LADD#1
       INC  *8
LADD#1 A    *1,*8
       B    *13

* lsubs(long, short) int *long, short;
*
* long -= short
* returns *long
*
LSUBS  MOV  8,1          R1=short
       MOV  @4(14),8     R8=&long
       S    1,@2(8)
       JOC  LSBS#1
       DEC  *8
LSBS#1 B    *13

* lsubl(long1, long2) int *long1, long2;
*
* long1 -= long2
* returns *long1
*
LSUBL  MOV  8,1          R1=&long2
       MOV  @4(14),8     R8=&long1
       S    @2(1),@2(8)
       JOC  LSUB#1
       DEC  *8
LSUB#1 S    *1,*8
       B    *13

* lmpys(long,short) int *long,short;
*
* long *= short = (short*LOW(long))        overflow if:
*               + (short*HOW(long)) 0000   HOW(result)!=0
* returns *long
*
* overflow if: 
*
LMPYS  CLR  7            R7=HOW(short)
       MOV  8,6          R6=LOW(short)
       MOV  @4(14),8     R8=&Long 

       MOV  @2(8),1      LOW(long)
       MPY  6,1          LOW(short)*LOW(long)
       BL   @LMPY#1
       B    *13

* lmpyl(long1,long2) int *long1,*long2;
*
* unsigned multiply
*
* long1 *= long2 = (LOW(long2) * LOW(long1))            overflow if:
*                + (HOW(long2) * LOW(long1)) 0000       HOW(result)!=0
*                + (LOW(long2) * HOW(long1)) 0000       HOW(result)!=0
*                + (HOW(long2) * HOW(long1)) 0000 0000      result !=0
*
* returns *long1, if overflow occured long1=0xFFFFFFFF 
*
*
*
LMPYL  MOV  *8,6     R6=HOW(long2)
       MOV  @2(8),7  R7=LOW(long2)
       MOV  @4(14),8 R8=&long1
       BL   @LMPY#S
       B    *13
       
LMPY#S MOV  *8,3     HOW(long1)=0
       JEQ  LMPY#0
       MOV  6,3      HOW(long2)=0
       JNE  LMPY#V   Overflow

LMPY#0 MOV  @2(8),1  LOW(long1)
       MOV  1,3
       MPY  7,1      LOW(long2)*LOW(long1)
       
       MPY  6,3      HOW(long2)*LOW(long1)
       A    4,1
       JOC  LMPY#V   Overflow
       ABS  3        !=0
       JNE  LMPY#V   Overflow
      
LMPY#1 MOV  *8,3     HOW(long1)
       MPY  7,3      LOW(long2)*HOW(long1)
       A    4,1
       JOC  LMPY#V   Overflow
       ABS  3        !=0
       JNE  LMPY#V   Overflow

LMPY#X MOV  1,*8     HOW(long1*long2)
       MOV  2,@2(8)  LOW(long1*long2)
       B    *11	
       
LMPY#V SETO *8       Overflow
       SETO @2(8)
       B    *11

* sldivs(long,short) int *long1,short;
*
* result = long / short
* returns result
*
SLDIVS MOV  8,1          R1=short
       MOV  @4(14),2     R2=&long
       MOV  *2,8         R7=HOW(long)
       MOV  @2(2),9      R8=LOW(long)
       DIV  1,8          R8=quotient
       B    *13

* ldivs(long,short) int *long1,short;
*
* long = long / short
* returns *long
*
LDIVS  MOV  8,1          R1=short=dividend
       MOV  @4(14),8     R8=&long
       
       CLR  2            R2=HOW(divisor)
       MOV  *8,3         R3=HOW(long)=LOW(divisor)
       DIV  1,2          R2=quotient=HOW(result),R3=remainder=HOW(divisor)

       MOV  @2(8),4      R4=LOW(long)=LOW(divisor)
       DIV  1,3          R3=LOW(result), R4=remainder
       
       MOV  2,*8
       MOV  3,@2(8)
       B    *13

* lmods(long,short) int *long,short
*
* result = long % short
* returns result
*
LMODS  MOV  8,1          R1=short
       MOV  @4(14),2     R2=&long
       MOV  *2+,7        R7=HOW(long)
       MOV  *2,8         R8=LOW(long)
       DIV  1,7          R8=modulo
       B    *13

* ldivl(long1,long2) int *long1,*long2
*
* unsigned divide
*
* long1 = long1 / long2
* returns *long1
*
LDIVL  BL   @LDIV#U
       MOV  4,*8         R8=&long1
       MOV  5,@2(8)
       B    *13

* lmodl(long1,long2) int *long1,*long2
*
* unsigned modulo
*
* long1 = long1 % long2
* returns *long1
*
LMODL  BL   @LDIV#U
       MOV  2,*8         R8=&long1
       MOV  3,@2(8)
       B    *13

* ldiv0(long1,long2) int *long1,*long2
*
* R4,5 = long1 / long2
* R2,3 = long1 % long2
*
LDIV#U MOV  @4(14),0
       MOV  *0+,8    Dividend HOW
       MOV  *0,9     LOW
       MOV  @2(14),0
       MOV  *0+,6    Divider HOW
       MOV  *0,7     LOW

LDIV#S CLR  2        Modulo HOW
       CLR  3        LOW
       CLR  4        Quotient HOW
       CLR  5        LOW

       MOV  6,1	     Divide by 0?
       SOC  7,1    
       JNE  LDIV#0   No!
       SETO 4        Result = long max	
       SETO 5	
       B    *11
       
LDIV#0 LI   1,32     32bits divide
       
LDIV#1 SLA  4,1      Quotient *=2
       SLA  5,1
       JNC  LDIV#2
       INC  4        HOW+C
       
LDIV#2 SLA  2,1      Modulo *=2
       SLA  3,1
       JNC  LDIV#3
       INC  2        HOW+C
       
LDIV#3 SLA  8,1      Divider *=2
       JNC  LDIV#4
       INC  3        Modulo+C
LDIV#4 SLA  9,1
       JNC  LDIV#5
       INC  8        HOW+C
 
LDIV#5 C    2,6      HOW(Modulo) > HOW(Divider) ?
       JL   LDIV#8   No!	
       JH   LDIV#6   Yes! 
       C    3,7      LOW(Modulo) >= LOW(Modulo)
       JL   LDIV#8
LDIV#6 S    7,3      Modulo -= Divider
       JOC  LDIV#7
       DEC  2
LDIV#7 S    6,2
       INC  5        Quotient +=1
       JNC  LDIV#8
       INC  6        HOW+C
              
LDIV#8 DEC  1
       JNE  LDIV#1
       MOV  @4(14),8 R8=&long1
       B    *11

       END
